/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.template.java.JavaDocContextType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocCompletionEvaluator;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavadocCompletionProcessor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class JavaDocCompletionProcessor
implements IContentAssistProcessor {
    private static final String PROCESSOR_CONTRIBUTION_ID = "javadocCompletionProcessor";
    private IEditorPart fEditor;
    private char[] fProposalAutoActivationSet;
    private CompletionProposalComparator fComparator;
    private TemplateEngine fTemplateEngine;
    private int fSubProcessorFlags;
    private String fErrorMessage;
    private IJavadocCompletionProcessor[] fSubProcessors;

    public JavaDocCompletionProcessor(IEditorPart editor) {
        this.fEditor = editor;
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("javadoc");
        if (contextType == null) {
            contextType = new JavaDocContextType();
            JavaPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fSubProcessorFlags = 0;
        this.fComparator = new CompletionProposalComparator();
        this.fSubProcessors = null;
        this.fErrorMessage = null;
    }

    private IJavadocCompletionProcessor[] getContributedProcessors() {
        if (this.fSubProcessors == null) {
            try {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.jdt.ui", PROCESSOR_CONTRIBUTION_ID);
                IJavadocCompletionProcessor[] result = new IJavadocCompletionProcessor[elements.length];
                int i = 0;
                while (i < elements.length) {
                    result[i] = (IJavadocCompletionProcessor)elements[i].createExecutableExtension("class");
                    ++i;
                }
                this.fSubProcessors = result;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                this.fSubProcessors = new IJavadocCompletionProcessor[]{new JavaDocCompletionEvaluator()};
            }
        }
        return this.fSubProcessors;
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
        this.fSubProcessorFlags = restrict ? 1 : 0;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        ArrayList<IContextInformation> result = new ArrayList<IContextInformation>();
        String errorMessage = null;
        IJavadocCompletionProcessor[] processors = this.getContributedProcessors();
        int i = 0;
        while (i < processors.length) {
            IJavadocCompletionProcessor curr = processors[i];
            IContextInformation[] contextInfos = curr.computeContextInformation(cu, offset);
            if (contextInfos != null) {
                int k = 0;
                while (k < contextInfos.length) {
                    result.add(contextInfos[k]);
                    ++k;
                }
            }
            if (curr.getErrorMessage() != null) {
                errorMessage = curr.getErrorMessage();
            }
            ++i;
        }
        this.fErrorMessage = result.isEmpty() ? errorMessage : null;
        return result.toArray(new IContextInformation[result.size()]);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        int offset = documentOffset;
        int length = 0;
        Point selection = viewer.getSelectedRange();
        if (selection.y > 0) {
            offset = selection.x;
            length = selection.y;
        }
        ArrayList<IJavaCompletionProposal> result = new ArrayList<IJavaCompletionProposal>();
        String errorMessage = null;
        IJavadocCompletionProcessor[] processors = this.getContributedProcessors();
        int i = 0;
        while (i < processors.length) {
            IJavadocCompletionProcessor curr = processors[i];
            IJavaCompletionProposal[] proposals = curr.computeCompletionProposals(cu, offset, length, this.fSubProcessorFlags);
            if (proposals != null) {
                int k = 0;
                while (k < proposals.length) {
                    result.add(proposals[k]);
                    ++k;
                }
            }
            if (curr.getErrorMessage() != null) {
                errorMessage = curr.getErrorMessage();
            }
            ++i;
        }
        if (this.fTemplateEngine != null) {
            this.fTemplateEngine.reset();
            this.fTemplateEngine.complete(viewer, offset, cu);
            TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
            int k = 0;
            while (k < templateResults.length) {
                result.add(templateResults[k]);
                ++k;
            }
        }
        this.fErrorMessage = result.isEmpty() ? errorMessage : null;
        IJavaCompletionProposal[] total = result.toArray(new IJavaCompletionProposal[result.size()]);
        return this.order(total);
    }

    private IJavaCompletionProposal[] order(IJavaCompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }
}

