/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public final class GenericJavaTypeProposal
extends LazyJavaTypeCompletionProposal {
    private IRegion fSelectedRegion;
    private final CompletionContext fContext;
    private TypeArgumentProposal[] fTypeArgumentProposals;

    public GenericJavaTypeProposal(CompletionProposal typeProposal, CompletionContext context, ICompilationUnit cu) {
        super(typeProposal, cu);
        this.fContext = context;
    }

    public void apply(IDocument document, char trigger, int offset) {
        if (this.shouldAppendArguments(document, offset)) {
            try {
                TypeArgumentProposal[] typeArgumentProposals = this.computeTypeArgumentProposals();
                if (typeArgumentProposals.length > 0) {
                    int[] offsets = new int[typeArgumentProposals.length];
                    int[] lengths = new int[typeArgumentProposals.length];
                    StringBuffer buffer = this.createParameterList(typeArgumentProposals, offsets, lengths);
                    super.setReplacementString(buffer.toString());
                    super.apply(document, trigger, offset);
                    if (this.getTextViewer() != null) {
                        if (this.hasAmbiguousProposals(typeArgumentProposals)) {
                            this.adaptOffsets(offsets, buffer);
                            this.installLinkedMode(document, offsets, lengths, typeArgumentProposals);
                        } else {
                            this.fSelectedRegion = new Region(this.getReplacementOffset() + this.getReplacementString().length(), 0);
                        }
                    }
                    return;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        super.apply(document, trigger, offset);
    }

    private void adaptOffsets(int[] offsets, StringBuffer buffer) {
        String replacementString = this.getReplacementString();
        int delta = buffer.length() - replacementString.length();
        int i = 0;
        while (i < offsets.length) {
            int n = i++;
            offsets[n] = offsets[n] - delta;
        }
    }

    private TypeArgumentProposal[] computeTypeArgumentProposals() throws JavaModelException {
        if (this.fTypeArgumentProposals == null) {
            IType type = this.getProposedType();
            if (type == null) {
                return new TypeArgumentProposal[0];
            }
            ITypeParameter[] parameters = type.getTypeParameters();
            if (parameters.length == 0) {
                return new TypeArgumentProposal[0];
            }
            TypeArgumentProposal[] arguments = new TypeArgumentProposal[parameters.length];
            ITypeBinding expectedTypeBinding = this.getExpectedType();
            if (expectedTypeBinding != null && expectedTypeBinding.isParameterizedType()) {
                IType expectedType = (IType)expectedTypeBinding.getJavaElement();
                IType[] path = this.computeInheritancePath(type, expectedType);
                if (path == null) {
                    return new TypeArgumentProposal[0];
                }
                int[] indices = new int[parameters.length];
                int paramIdx = 0;
                while (paramIdx < parameters.length) {
                    indices[paramIdx] = this.mapTypeParameterIndex(path, path.length - 1, paramIdx);
                    ++paramIdx;
                }
                ITypeBinding[] typeArguments = expectedTypeBinding.getTypeArguments();
                int paramIdx2 = 0;
                while (paramIdx2 < parameters.length) {
                    if (indices[paramIdx2] != -1) {
                        ITypeBinding binding = typeArguments[indices[paramIdx2]];
                        arguments[paramIdx2] = this.computeTypeProposal(binding, parameters[paramIdx2]);
                    }
                    ++paramIdx2;
                }
            }
            int i = 0;
            while (i < arguments.length) {
                if (arguments[i] == null) {
                    arguments[i] = this.computeTypeProposal(type, parameters[i]);
                }
                ++i;
            }
            this.fTypeArgumentProposals = arguments;
        }
        return this.fTypeArgumentProposals;
    }

    private TypeArgumentProposal computeTypeProposal(IType type, ITypeParameter parameter) throws JavaModelException {
        String[] bounds = parameter.getBounds();
        String elementName = parameter.getElementName();
        String displayName = this.computeTypeParameterDisplayName(parameter, bounds);
        if (bounds.length == 1 && !"java.lang.Object".equals(bounds[0])) {
            return new TypeArgumentProposal(Signature.getSimpleName((String)bounds[0]), true, displayName);
        }
        return new TypeArgumentProposal(elementName, true, displayName);
    }

    private String computeTypeParameterDisplayName(ITypeParameter parameter, String[] bounds) {
        if (bounds.length == 0 || bounds.length == 1 && "java.lang.Object".equals(bounds[0])) {
            return parameter.getElementName();
        }
        StringBuffer buf = new StringBuffer(parameter.getElementName());
        buf.append(" extends ");
        int i = 0;
        while (i < bounds.length) {
            buf.append(Signature.getSimpleName((String)bounds[i]));
            if (i < bounds.length - 1) {
                buf.append(" & ");
            }
            ++i;
        }
        return buf.toString();
    }

    private TypeArgumentProposal computeTypeProposal(ITypeBinding binding, ITypeParameter parameter) throws JavaModelException {
        String name = binding.getName();
        if (binding.isWildcardType()) {
            String contextName = name.replaceFirst("\\?", parameter.getElementName());
            if (binding.isUpperbound()) {
                return new TypeArgumentProposal(binding.getBound().getName(), true, contextName);
            }
            return new TypeArgumentProposal("Object", true, contextName);
        }
        if (binding.isTypeVariable()) {
            ITypeBinding[] bounds = binding.getTypeBounds();
            if (bounds.length == 1) {
                return new TypeArgumentProposal(bounds[0].getName(), true, name);
            }
            return new TypeArgumentProposal(name, true, name);
        }
        return new TypeArgumentProposal(name, false, name);
    }

    private IType[] computeInheritancePath(IType subType, IType superType) throws JavaModelException {
        if (superType == null) {
            return null;
        }
        if (superType.equals(subType)) {
            return new IType[]{subType};
        }
        ITypeHierarchy hierarchy = subType.newSupertypeHierarchy((IProgressMonitor)this.getProgressMonitor());
        if (!hierarchy.contains(superType)) {
            return null;
        }
        LinkedList<IType> path = new LinkedList<IType>();
        path.add(superType);
        do {
            superType = hierarchy.getSubtypes(superType)[0];
            path.add(superType);
        } while (!superType.equals(subType));
        return path.toArray(new IType[path.size()]);
    }

    private NullProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    private int mapTypeParameterIndex(IType[] path, int pathIndex, int paramIndex) throws JavaModelException, ArrayIndexOutOfBoundsException {
        ITypeParameter param;
        if (pathIndex == 0) {
            return paramIndex;
        }
        IType subType = path[pathIndex];
        IType superType = path[pathIndex - 1];
        String superSignature = this.findMatchingSuperTypeSignature(subType, superType);
        int index = this.findMatchingTypeArgumentIndex(superSignature, (param = subType.getTypeParameters()[paramIndex]).getElementName());
        if (index == -1) {
            return -1;
        }
        return this.mapTypeParameterIndex(path, pathIndex - 1, index);
    }

    private String findMatchingSuperTypeSignature(IType subType, IType superType) throws JavaModelException {
        String[] signatures = this.getSuperTypeSignatures(subType, superType);
        int i = 0;
        while (i < signatures.length) {
            String superFQN;
            String signature = signatures[i];
            String qualified = SignatureUtil.qualifySignature(signature, subType);
            String subFQN = SignatureUtil.stripSignatureToFQN(qualified);
            if (subFQN.equals(superFQN = superType.getFullyQualifiedName())) {
                return signature;
            }
            ++i;
        }
        throw new JavaModelException(new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "Illegal hierarchy", null)));
    }

    private int findMatchingTypeArgumentIndex(String signature, String argument) {
        String[] typeArguments = Signature.getTypeArguments((String)signature);
        int i = 0;
        while (i < typeArguments.length) {
            if (Signature.getSignatureSimpleName((String)typeArguments[i]).equals(argument)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String[] getSuperTypeSignatures(IType subType, IType superType) throws JavaModelException {
        if (superType.isInterface()) {
            return subType.getSuperInterfaceTypeSignatures();
        }
        return new String[]{subType.getSuperclassTypeSignature()};
    }

    private ITypeBinding getExpectedType() {
        char[][] chKeys = this.fContext.getExpectedTypesKeys();
        if (chKeys == null || chKeys.length == 0) {
            return null;
        }
        String[] keys = new String[chKeys.length];
        int i = 0;
        while (i < keys.length) {
            keys[i] = String.valueOf(chKeys[0]);
            ++i;
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(this.fCompilationUnit.getJavaProject());
        parser.setResolveBindings(true);
        final HashMap bindings = new HashMap();
        ASTRequestor requestor = new ASTRequestor(){

            public void acceptBinding(String bindingKey, IBinding binding) {
                bindings.put(bindingKey, binding);
            }
        };
        parser.createASTs(new ICompilationUnit[0], keys, requestor, null);
        if (bindings.size() > 0) {
            return (ITypeBinding)bindings.get(keys[0]);
        }
        return null;
    }

    private IType getProposedType() throws JavaModelException {
        if (this.fCompilationUnit != null) {
            String fullType = SignatureUtil.stripSignatureToFQN(String.valueOf(this.fProposal.getSignature()));
            return this.fCompilationUnit.getJavaProject().findType(fullType);
        }
        return null;
    }

    private boolean shouldAppendArguments(IDocument document, int offset) {
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            String line = document.get(region.getOffset(), region.getLength());
            int index = offset - region.getOffset();
            while (index != line.length() && Character.isUnicodeIdentifierPart(line.charAt(index))) {
                ++index;
            }
            if (index == line.length()) {
                return true;
            }
            char ch = line.charAt(index);
            return ch != '<';
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    private StringBuffer createParameterList(TypeArgumentProposal[] typeArguments, int[] offsets, int[] lengths) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getReplacementString());
        FormatterPrefs prefs = new FormatterPrefs(this.fCompilationUnit == null ? null : this.fCompilationUnit.getJavaProject());
        if (prefs.beforeOpeningBracket) {
            buffer.append(' ');
        }
        buffer.append('<');
        if (prefs.afterOpeningBracket) {
            buffer.append(' ');
        }
        StringBuffer separator = new StringBuffer(3);
        if (prefs.beforeComma) {
            separator.append(' ');
        }
        separator.append(',');
        if (prefs.afterComma) {
            separator.append(' ');
        }
        int i = 0;
        while (i != typeArguments.length) {
            if (i != 0) {
                buffer.append(separator);
            }
            offsets[i] = buffer.length();
            buffer.append(typeArguments[i]);
            lengths[i] = buffer.length() - offsets[i];
            ++i;
        }
        if (prefs.beforeClosingBracket) {
            buffer.append(' ');
        }
        buffer.append('>');
        return buffer;
    }

    private void installLinkedMode(IDocument document, int[] offsets, int[] lengths, TypeArgumentProposal[] typeArgumentProposals) {
        int replacementOffset = this.getReplacementOffset();
        String replacementString = this.getReplacementString();
        try {
            LinkedModeModel model = new LinkedModeModel();
            int i = 0;
            while (i != offsets.length) {
                if (typeArgumentProposals[i].isAmbiguous()) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, replacementOffset + offsets[i], lengths[i], -1));
                    model.addGroup(group);
                }
                ++i;
            }
            model.forceInstall();
            JavaEditor editor = this.getJavaEditor();
            if (editor != null) {
                model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
            }
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
            ui.setExitPosition(this.getTextViewer(), replacementOffset + replacementString.length(), 0, Integer.MAX_VALUE);
            ui.setDoContextInfo(true);
            ui.enter();
            this.fSelectedRegion = ui.getSelectedRegion();
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            this.openErrorDialog(e);
        }
    }

    private boolean hasAmbiguousProposals(TypeArgumentProposal[] typeArgumentProposals) {
        boolean hasAmbiguousProposals = false;
        int i = 0;
        while (i < typeArgumentProposals.length) {
            if (typeArgumentProposals[i].isAmbiguous()) {
                hasAmbiguousProposals = true;
                break;
            }
            ++i;
        }
        return hasAmbiguousProposals;
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return super.getSelection(document);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)JavaTextMessages.ExperimentalProposal_error_msg, (String)e.getMessage());
    }

    protected IContextInformation computeContextInformation() {
        if (this.fTypeArgumentProposals != null) {
            try {
                TypeArgumentProposal[] proposals;
                if (this.hasParameters() && this.hasAmbiguousProposals(proposals = this.computeTypeArgumentProposals())) {
                    return new ContextInformation(this);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return super.computeContextInformation();
    }

    protected int computeCursorPosition() {
        if (this.fSelectedRegion != null) {
            return this.fSelectedRegion.getOffset() - this.getReplacementOffset();
        }
        return super.computeCursorPosition();
    }

    private boolean hasParameters() {
        try {
            IType type = this.getProposedType();
            if (type == null) {
                return false;
            }
            return type.getTypeParameters().length > 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private static class ContextInformation
    implements IContextInformation,
    IContextInformationExtension {
        private final String fInformationDisplayString;
        private final String fContextDisplayString;
        private final Image fImage;
        private final int fPosition;

        ContextInformation(GenericJavaTypeProposal proposal) {
            this.fContextDisplayString = proposal.getDisplayString();
            this.fInformationDisplayString = this.computeContextString(proposal);
            this.fImage = proposal.getImage();
            this.fPosition = proposal.getReplacementOffset() + proposal.getReplacementString().indexOf(60) + 1;
        }

        public String getContextDisplayString() {
            return this.fContextDisplayString;
        }

        public Image getImage() {
            return this.fImage;
        }

        public String getInformationDisplayString() {
            return this.fInformationDisplayString;
        }

        private String computeContextString(GenericJavaTypeProposal proposal) {
            try {
                TypeArgumentProposal[] proposals = proposal.computeTypeArgumentProposals();
                if (proposals.length == 0) {
                    return null;
                }
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < proposals.length) {
                    buf.append(proposals[i].getDisplayName());
                    if (i < proposals.length - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                return buf.toString();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContextInformation) {
                ContextInformation ci = (ContextInformation)obj;
                return this.getContextInformationPosition() == ci.getContextInformationPosition() && this.getInformationDisplayString().equals(ci.getInformationDisplayString());
            }
            return false;
        }
    }

    private static final class TypeArgumentProposal {
        private final boolean fIsAmbiguous;
        private final String fProposal;
        private final String fTypeDisplayName;

        TypeArgumentProposal(String proposal, boolean ambiguous, String typeDisplayName) {
            this.fIsAmbiguous = ambiguous;
            this.fProposal = proposal;
            this.fTypeDisplayName = typeDisplayName;
        }

        public String getDisplayName() {
            return this.fTypeDisplayName;
        }

        boolean isAmbiguous() {
            return this.fIsAmbiguous;
        }

        String getProposals() {
            return this.fProposal;
        }

        public String toString() {
            return this.fProposal;
        }
    }

    private static final class FormatterPrefs {
        final boolean beforeOpeningBracket;
        final boolean afterOpeningBracket;
        final boolean beforeComma;
        final boolean afterComma;
        final boolean beforeClosingBracket;

        FormatterPrefs(IJavaProject project) {
            this.beforeOpeningBracket = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_parameterized_type_reference", false);
            this.afterOpeningBracket = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_parameterized_type_reference", false);
            this.beforeComma = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_parameterized_type_reference", false);
            this.afterComma = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_parameterized_type_reference", true);
            this.beforeClosingBracket = this.getCoreOption(project, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_parameterized_type_reference", false);
        }

        private boolean getCoreOption(IJavaProject project, String key, boolean def) {
            String option = this.getCoreOption(project, key);
            if ("insert".equals(option)) {
                return true;
            }
            if ("do not insert".equals(option)) {
                return false;
            }
            return def;
        }

        private String getCoreOption(IJavaProject project, String key) {
            if (project == null) {
                return JavaCore.getOption((String)key);
            }
            return project.getOption(key, true);
        }
    }
}

