/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.swt.graphics.Image;

public class CorrectMainTypeNameProposal
extends ASTRewriteCorrectionProposal {
    private String fOldName;
    private String fNewName;
    private final CompilationUnit fRoot;

    public CorrectMainTypeNameProposal(ICompilationUnit cu, CompilationUnit root, String oldTypeName, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fRoot = root;
        this.fNewName = Signature.getQualifier((String)cu.getElementName());
        this.setDisplayName(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_renametype_description, this.fNewName));
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fOldName = oldTypeName;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = this.fRoot;
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        AbstractTypeDeclaration decl = this.findTypeDeclaration(astRoot.types(), this.fOldName);
        if (decl != null) {
            SimpleName[] sameNodes = LinkedNodeFinder.findByNode((ASTNode)astRoot, decl.getName());
            int i = 0;
            while (i < sameNodes.length) {
                rewrite.replace((ASTNode)sameNodes[i], (ASTNode)ast.newSimpleName(this.fNewName), null);
                ++i;
            }
        }
        return rewrite;
    }

    private AbstractTypeDeclaration findTypeDeclaration(List types, String name) {
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            AbstractTypeDeclaration decl = (AbstractTypeDeclaration)iter.next();
            if (!name.equals(decl.getName().getIdentifier())) continue;
            return decl;
        }
        return null;
    }
}

