/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.ui.CodeGeneration;

public abstract class AbstractSerialVersionProposal
extends LinkedCorrectionProposal {
    protected static final String LONG_SUFFIX = "L";
    protected static final long SERIAL_VALUE = 1L;
    protected static final String DEFAULT_EXPRESSION = "1L";
    protected static final String NAME_FIELD = "serialVersionUID";
    private static final int PROPOSAL_RELEVANCE = 9;
    private final ASTNode fNode;

    protected AbstractSerialVersionProposal(String label, ICompilationUnit unit, ASTNode node) {
        super(label, unit, (ASTRewrite)null, 9, JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif"));
        Assert.isNotNull(node);
        this.fNode = node;
    }

    protected abstract void addInitializer(VariableDeclarationFragment var1);

    protected abstract void addLinkedPositions(ASTRewrite var1, VariableDeclarationFragment var2);

    protected abstract Expression computeDefaultExpression(IProgressMonitor var1);

    protected final AST getAST() {
        return this.fNode.getAST();
    }

    protected final ASTNode getDeclarationNode() {
        ASTNode parent = this.fNode.getParent();
        if (!(parent instanceof AbstractTypeDeclaration)) {
            if ((parent = parent.getParent()) instanceof ParameterizedType || parent instanceof Type) {
                parent = parent.getParent();
            }
            if (parent instanceof ClassInstanceCreation) {
                ClassInstanceCreation creation = (ClassInstanceCreation)parent;
                parent = creation.getAnonymousClassDeclaration();
            }
        }
        return parent;
    }

    protected final ASTRewrite getRewrite() throws CoreException {
        String comment;
        ASTNode node = this.getDeclarationNode();
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(NAME_FIELD));
        FieldDeclaration declaration = ast.newFieldDeclaration(fragment);
        declaration.setType((Type)ast.newPrimitiveType(PrimitiveType.LONG));
        declaration.modifiers().addAll(ASTNodeFactory.newModifiers(ast, 26));
        this.addInitializer(fragment);
        if (fragment.getInitializer() != null) {
            if (node instanceof AbstractTypeDeclaration) {
                rewrite.getListRewrite(node, ((AbstractTypeDeclaration)node).getBodyDeclarationsProperty()).insertAt((ASTNode)declaration, 0, null);
            } else if (node instanceof AnonymousClassDeclaration) {
                rewrite.getListRewrite(node, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY).insertAt((ASTNode)declaration, 0, null);
            } else {
                Assert.isTrue(false);
            }
            this.addLinkedPositions(rewrite, fragment);
        }
        if ((comment = CodeGeneration.getFieldComment(this.getCompilationUnit(), declaration.getType().toString(), NAME_FIELD, StubUtility.getLineDelimiterUsed((IJavaElement)this.getCompilationUnit()))) != null && comment.length() > 0) {
            Javadoc doc = (Javadoc)rewrite.createStringPlaceholder(comment, 29);
            declaration.setJavadoc(doc);
        }
        return rewrite;
    }
}

