/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.Arrays;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSavePreferences;
import org.eclipse.jdt.internal.ui.refactoring.actions.ListDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.GlobalBuildAction;

public class RefactoringSaveHelper {
    private boolean fFilesSaved;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveEditors(Shell shell) {
        IEditorPart[] dirtyEditors = JavaPlugin.getDirtyEditors();
        if (dirtyEditors.length == 0) {
            return true;
        }
        if (!this.saveAllDirtyEditors(shell)) {
            return false;
        }
        try {
            boolean autoBuild;
            IWorkspaceDescription description;
            IWorkspace workspace;
            block9: {
                block8: {
                    workspace = ResourcesPlugin.getWorkspace();
                    description = workspace.getDescription();
                    autoBuild = description.isAutoBuilding();
                    description.setAutoBuilding(false);
                    workspace.setDescription(description);
                    try {
                        if (!JavaPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false)) {
                            Object var6_7 = null;
                            break block8;
                        }
                        this.fFilesSaved = true;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        description.setAutoBuilding(autoBuild);
                        workspace.setDescription(description);
                        throw throwable;
                    }
                }
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
                return false;
            }
            Object var6_9 = null;
            description.setAutoBuilding(autoBuild);
            workspace.setDescription(description);
            return true;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, RefactoringMessages.RefactoringStarter_saving, RefactoringMessages.RefactoringStarter_unexpected_exception);
            return false;
        }
    }

    public void triggerBuild() {
        if (this.fFilesSaved && ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(JavaPlugin.getActiveWorkbenchWindow(), 10).run();
        }
    }

    private boolean saveAllDirtyEditors(Shell shell) {
        if (RefactoringSavePreferences.getSaveAllEditors()) {
            return true;
        }
        ListDialog dialog = new ListDialog(shell){

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                Button check = new Button(result, 32);
                check.setText(RefactoringMessages.RefactoringStarter_always_save);
                check.setSelection(RefactoringSavePreferences.getSaveAllEditors());
                check.addSelectionListener((SelectionListener)new SelectionAdapter(this, check){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Button val$check;
                    {
                        this.this$1 = var1_1;
                        this.val$check = button;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        RefactoringSavePreferences.setSaveAllEditors(this.val$check.getSelection());
                    }
                });
                1.applyDialogFont((Control)result);
                return result;
            }
        };
        dialog.setTitle(RefactoringMessages.RefactoringStarter_save_all_resources);
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(this.createDialogLabelProvider());
        dialog.setMessage(RefactoringMessages.RefactoringStarter_must_save);
        dialog.setContentProvider(new ListContentProvider());
        dialog.setInput(Arrays.asList(JavaPlugin.getDirtyEditors()));
        return dialog.open() == 0;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }
}

