/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class MoveMembersWizard
extends RefactoringWizard {
    public MoveMembersWizard(MoveRefactoring ref) {
        super((Refactoring)ref, 4);
        this.setDefaultPageTitle(RefactoringMessages.MoveMembersWizard_page_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveMembersInputPage());
    }

    private static class MoveMembersInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "MoveMembersInputPage";
        private static final long LABEL_FLAGS = JavaElementLabels.ALL_DEFAULT;
        private Combo fDestinationField;
        private static final int MRU_COUNT = 10;
        private static List fgMruDestinations = new ArrayList(10);
        static /* synthetic */ Class class$0;

        public MoveMembersInputPage() {
            super(PAGE_NAME);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                String message = Messages.format(RefactoringMessages.MoveMembersInputPage_descriptionKey, new String[]{new Integer(this.getMoveProcessor().getMembersToMove().length).toString(), JavaModelUtil.getFullyQualifiedName(this.getMoveProcessor().getDeclaringType())});
                this.setDescription(message);
            }
            super.setVisible(visible);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            composite.setLayout((Layout)gl);
            this.addLabel(composite);
            this.addDestinationControls(composite);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.move_members_wizard_page_context");
        }

        private void addLabel(Composite parent) {
            Label label = new Label(parent, 0);
            IMember[] members = this.getMoveProcessor().getMembersToMove();
            if (members.length == 1) {
                label.setText(Messages.format(RefactoringMessages.MoveMembersInputPage_destination_single, JavaElementLabels.getElementLabel((IJavaElement)members[0], LABEL_FLAGS)));
            } else {
                label.setText(Messages.format(RefactoringMessages.MoveMembersInputPage_destination_multi, String.valueOf(members.length)));
            }
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }

        private void addDestinationControls(Composite composite) {
            this.fDestinationField = new Combo(composite, 2052);
            this.fDestinationField.setFocus();
            this.fDestinationField.setLayoutData((Object)new GridData(768));
            this.fDestinationField.setItems(fgMruDestinations.toArray(new String[fgMruDestinations.size()]));
            this.fDestinationField.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MoveMembersInputPage this$1;
                {
                    this.this$1 = moveMembersInputPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.handleDestinationChanged();
                }

                private void handleDestinationChanged() {
                    IStatus status = JavaConventions.validateJavaTypeName((String)MoveMembersInputPage.access$0(this.this$1).getText());
                    if (status.getSeverity() == 4) {
                        this.error(status.getMessage());
                    } else {
                        try {
                            IStatus validationStatus;
                            IType declaring = MoveMembersInputPage.access$1(this.this$1).getDeclaringType();
                            IType resolvedType = declaring.getJavaProject().findType(MoveMembersInputPage.access$0(this.this$1).getText());
                            if (resolvedType == null) {
                                resolvedType = declaring.getJavaProject().findType(declaring.getPackageFragment().getElementName(), MoveMembersInputPage.access$0(this.this$1).getText());
                            }
                            if ((validationStatus = MoveMembersInputPage.access$2(resolvedType, MoveMembersInputPage.access$0(this.this$1).getText())).isOK()) {
                                this.this$1.setErrorMessage(null);
                                this.this$1.setPageComplete(true);
                            } else {
                                this.error(validationStatus.getMessage());
                            }
                        }
                        catch (JavaModelException ex) {
                            JavaPlugin.log(ex);
                            this.error(RefactoringMessages.MoveMembersInputPage_invalid_name);
                        }
                    }
                }

                private void error(String message) {
                    this.this$1.setErrorMessage(message);
                    this.this$1.setPageComplete(false);
                }
            });
            if (fgMruDestinations.size() > 0) {
                this.fDestinationField.select(0);
            } else {
                this.setPageComplete(false);
            }
            JavaTypeCompletionProcessor processor = new JavaTypeCompletionProcessor(false, false);
            IPackageFragment context = (IPackageFragment)this.getMoveProcessor().getDeclaringType().getAncestor(4);
            processor.setPackageFragment(context);
            ControlContentAssistHelper.createComboContentAssistant(this.fDestinationField, processor);
            Button button = new Button(composite, 8);
            button.setText(RefactoringMessages.MoveMembersInputPage_browse);
            button.setLayoutData((Object)new GridData());
            SWTUtil.setButtonDimensionHint(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ MoveMembersInputPage this$1;
                {
                    this.this$1 = moveMembersInputPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    MoveMembersInputPage.access$3(this.this$1);
                }
            });
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        private void initializeRefactoring() {
            try {
                String destination = this.fDestinationField.getText();
                if (!fgMruDestinations.remove(destination) && fgMruDestinations.size() >= 10) {
                    fgMruDestinations.remove(fgMruDestinations.size() - 1);
                }
                fgMruDestinations.add(0, destination);
                this.getMoveProcessor().setDestinationTypeFullyQualifiedName(destination);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.MoveMembersInputPage_move_Member, RefactoringMessages.MoveMembersInputPage_exception);
            }
        }

        private IJavaSearchScope createWorkspaceSourceScope() {
            IJavaElement[] project = new IJavaElement[]{this.getMoveProcessor().getDeclaringType().getJavaProject()};
            return SearchEngine.createJavaSearchScope((IJavaElement[])project, (int)9);
        }

        private void openTypeSelectionDialog() {
            int elementKinds = 0;
            IJavaSearchScope scope = this.createWorkspaceSourceScope();
            TypeSelectionDialog2 dialog = new TypeSelectionDialog2(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, elementKinds);
            dialog.setTitle(RefactoringMessages.MoveMembersInputPage_choose_Type);
            dialog.setMessage(RefactoringMessages.MoveMembersInputPage_dialogMessage);
            dialog.setValidator(new ISelectionStatusValidator(this, scope){
                final /* synthetic */ MoveMembersInputPage this$1;
                private final /* synthetic */ IJavaSearchScope val$scope;
                {
                    this.this$1 = moveMembersInputPage;
                    this.val$scope = iJavaSearchScope;
                }

                public IStatus validate(Object[] selection) {
                    Assert.isTrue(selection.length <= 1);
                    if (selection.length == 0) {
                        return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.MoveMembersInputPage_Invalid_selection, null);
                    }
                    Object element = selection[0];
                    if (!(element instanceof TypeInfo)) {
                        return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.MoveMembersInputPage_Invalid_selection, null);
                    }
                    try {
                        TypeInfo info = (TypeInfo)element;
                        return MoveMembersInputPage.access$2(info.resolveType(this.val$scope), info.getTypeName());
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                        return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.MoveMembersInputPage_internal_error, null);
                    }
                }
            });
            dialog.setFilter(this.createInitialFilter());
            if (dialog.open() == 1) {
                return;
            }
            IType firstResult = (IType)dialog.getFirstResult();
            this.fDestinationField.setText(JavaModelUtil.getFullyQualifiedName(firstResult));
        }

        private String createInitialFilter() {
            if (!this.fDestinationField.getText().trim().equals("")) {
                return this.fDestinationField.getText();
            }
            return this.getMoveProcessor().getDeclaringType().getElementName();
        }

        private static IStatus validateDestinationType(IType type, String typeName) {
            if (type == null || !type.exists()) {
                return new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(RefactoringMessages.MoveMembersInputPage_not_found, typeName), null);
            }
            if (type.isBinary()) {
                return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.MoveMembersInputPage_no_binary, null);
            }
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }

        private MoveStaticMembersProcessor getMoveProcessor() {
            Refactoring refactoring = this.getRefactoring();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (MoveStaticMembersProcessor)((Object)refactoring.getAdapter((Class)clazz));
        }

        static /* synthetic */ Combo access$0(MoveMembersInputPage moveMembersInputPage) {
            return moveMembersInputPage.fDestinationField;
        }

        static /* synthetic */ MoveStaticMembersProcessor access$1(MoveMembersInputPage moveMembersInputPage) {
            return moveMembersInputPage.getMoveProcessor();
        }

        static /* synthetic */ IStatus access$2(IType iType, String string) {
            return MoveMembersInputPage.validateDestinationType(iType, string);
        }

        static /* synthetic */ void access$3(MoveMembersInputPage moveMembersInputPage) {
            moveMembersInputPage.openTypeSelectionDialog();
        }
    }
}

