/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.JavaFormatter;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.widgets.Shell;

public class JavaContext
extends CompilationUnitContext {
    private CompilationUnitCompletion fCompletion;

    public JavaContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    private int getIndentation() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            String lineContent = document.get(region.getOffset(), region.getLength());
            ICompilationUnit compilationUnit = this.getCompilationUnit();
            IJavaProject project = compilationUnit == null ? null : compilationUnit.getJavaProject();
            return Strings.computeIndentUnits(lineContent, project);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            throw new TemplateException(JavaTemplateMessages.Context_error_cannot_evaluate);
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(String type, String name, int[] offsets) {
                return new MultiVariable(type, name, offsets);
            }
        };
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        boolean useCodeFormatter = prefs.getBoolean("org.eclipse.jdt.ui.template.format");
        IJavaProject project = this.getCompilationUnit() != null ? this.getCompilationUnit().getJavaProject() : null;
        JavaFormatter formatter = new JavaFormatter(TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()), this.getIndentation(), useCodeFormatter, project);
        formatter.format(buffer, (TemplateContext)this);
        return buffer;
    }

    public boolean canEvaluate(Template template) {
        if (this.fForceEvaluation) {
            return true;
        }
        String key = this.getKey();
        return template.matches(key, this.getContextType().getId()) && key.length() != 0 && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    public int getStart() {
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return super.getStart();
        }
    }

    public int getEnd() {
        if (this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public char getCharacterBeforeStart() {
        int start = this.getStart();
        try {
            return start == 0 ? (char)' ' : this.getDocument().getChar(start - 1);
        }
        catch (BadLocationException badLocationException) {
            return ' ';
        }
    }

    private static void handleException(Shell shell, Exception e) {
        String title = JavaTemplateMessages.JavaContext_error_title;
        if (e instanceof CoreException) {
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, null);
        } else if (e instanceof InvocationTargetException) {
            ExceptionHandler.handle((InvocationTargetException)e, shell, title, null);
        } else {
            JavaPlugin.log(e);
            MessageDialog.openError((Shell)shell, (String)title, (String)e.getMessage());
        }
    }

    private CompilationUnitCompletion getCompletion() {
        ICompilationUnit compilationUnit = this.getCompilationUnit();
        if (this.fCompletion == null) {
            this.fCompletion = new CompilationUnitCompletion(compilationUnit);
            if (compilationUnit != null) {
                try {
                    compilationUnit.codeComplete(this.getStart(), (CompletionRequestor)this.fCompletion);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return this.fCompletion;
    }

    public String[] getArrays() {
        CompilationUnitCompletion completion = this.getCompletion();
        CompilationUnitCompletion.LocalVariable[] localArrays = completion.findLocalArrays();
        String[] ret = new String[localArrays.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = localArrays[i].getName();
            ++i;
        }
        return ret;
    }

    public String[][] getArrayTypes() {
        CompilationUnitCompletion completion = this.getCompletion();
        CompilationUnitCompletion.LocalVariable[] localArrays = completion.findLocalArrays();
        String[][] ret = new String[localArrays.length][];
        int i = 0;
        while (i < localArrays.length) {
            ret[i] = localArrays[i].getMemberTypeNames();
            ++i;
        }
        return ret;
    }

    public String[][] getArrayElements() {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return new String[0][];
        }
        CompilationUnitCompletion completion = this.getCompletion();
        CompilationUnitCompletion.LocalVariable[] localArrays = completion.findLocalArrays();
        return this.suggestElementNames(localArrays, true);
    }

    public String getIndex() {
        CompilationUnitCompletion completion = this.getCompletion();
        String[] proposals = new String[]{"i", "j", "k"};
        int i = 0;
        while (i != proposals.length) {
            String proposal = proposals[i];
            if (!completion.existsLocalName(proposal)) {
                return proposal;
            }
            ++i;
        }
        return null;
    }

    public String[] getCollections() {
        CompilationUnitCompletion completion = this.getCompletion();
        CompilationUnitCompletion.LocalVariable[] localCollections = completion.findLocalCollections();
        String[] ret = new String[localCollections.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = localCollections[i].getName();
            ++i;
        }
        return ret;
    }

    public String[] getIterables() {
        CompilationUnitCompletion completion = this.getCompletion();
        CompilationUnitCompletion.LocalVariable[] localCollections = completion.findLocalIterables();
        String[] ret = new String[localCollections.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = localCollections[i].getName();
            ++i;
        }
        return ret;
    }

    public String[][] getIterableTypes() {
        CompilationUnitCompletion completion = this.getCompletion();
        CompilationUnitCompletion.LocalVariable[] iterables = completion.findLocalIterables();
        String[][] ret = new String[iterables.length][];
        int i = 0;
        while (i < iterables.length) {
            ret[i] = iterables[i].getMemberTypeNames();
            ++i;
        }
        return ret;
    }

    public String[][] getIterableElements() {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return new String[0][];
        }
        CompilationUnitCompletion completion = this.getCompletion();
        CompilationUnitCompletion.LocalVariable[] iterables = completion.findLocalIterables();
        return this.suggestElementNames(iterables, false);
    }

    private String[][] suggestElementNames(CompilationUnitCompletion.LocalVariable[] iterables, boolean excludeIndex) throws IllegalArgumentException {
        String[] excludes = this.computeExcludes(excludeIndex);
        String[][] ret = new String[iterables.length][];
        int i = 0;
        while (i < iterables.length) {
            ret[i] = this.suggestVariableName(iterables[i], excludes);
            ++i;
        }
        return ret;
    }

    private String[] computeExcludes(boolean excludeIndex) {
        String index;
        String[] excludes = this.getCompletion().getLocalVariableNames();
        if (excludeIndex && (index = this.getIndex()) != null) {
            String[] allExcludes = new String[excludes.length + 1];
            System.arraycopy(excludes, 0, allExcludes, 0, excludes.length);
            allExcludes[excludes.length] = index;
            excludes = allExcludes;
        }
        return excludes;
    }

    private String[] suggestVariableName(CompilationUnitCompletion.LocalVariable iterable, String[] excludes) throws IllegalArgumentException {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String memberTypeSig = iterable.getMemberTypeSignature();
        int memberDimensions = Signature.getArrayCount((String)memberTypeSig);
        String elementTypeSig = Signature.getElementType((String)memberTypeSig);
        String erasure = Signature.getTypeErasure((String)elementTypeSig);
        String fullName = Signature.toString((String)erasure);
        String memberPackage = Signature.getQualifier((String)fullName);
        String memberTypeName = Signature.getSimpleName((String)fullName);
        String[] proposals = NamingConventions.suggestLocalVariableNames((IJavaProject)project, (String)memberPackage, (String)memberTypeName, (int)memberDimensions, (String[])excludes);
        return proposals;
    }

    public String getIterator() {
        CompilationUnitCompletion completion = this.getCompletion();
        String[] proposals = new String[]{"iter"};
        int i = 0;
        while (i != proposals.length) {
            String proposal = proposals[i];
            if (!completion.existsLocalName(proposal)) {
                return proposal;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addIteratorImport() {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return;
        }
        try {
            Position position = new Position(this.getCompletionOffset(), this.getCompletionLength());
            IDocument document = this.getDocument();
            String category = "__template_position_importer" + System.currentTimeMillis();
            DefaultPositionUpdater updater = new DefaultPositionUpdater(category);
            document.addPositionCategory(category);
            document.addPositionUpdater((IPositionUpdater)updater);
            document.addPosition(position);
            try {
                try {
                    CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cu.getJavaProject());
                    ImportsStructure structure = new ImportsStructure(cu, settings.importOrder, settings.importThreshold, true);
                    structure.addImport("java.util.Iterator");
                    structure.create(false, null);
                    this.setCompletionOffset(position.getOffset());
                    this.setCompletionLength(position.getLength());
                }
                catch (CoreException e) {
                    JavaContext.handleException(null, (Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                document.removePosition(position);
                document.removePositionUpdater((IPositionUpdater)updater);
                document.removePositionCategory(category);
                throw throwable;
            }
            {
                Object var8_13 = null;
                document.removePosition(position);
                document.removePositionUpdater((IPositionUpdater)updater);
                document.removePositionCategory(category);
                return;
            }
        }
        catch (BadLocationException e) {
            JavaContext.handleException(null, (Exception)((Object)e));
            return;
        }
        catch (BadPositionCategoryException e) {
            JavaContext.handleException(null, (Exception)((Object)e));
        }
    }

    public static String evaluateTemplate(Template template, ICompilationUnit compilationUnit, int position) throws CoreException, BadLocationException, TemplateException {
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, JavaTemplateMessages.JavaContext_error_message, null));
        }
        Document document = new Document();
        if (compilationUnit != null && compilationUnit.exists()) {
            document.set(compilationUnit.getSource());
        }
        JavaContext context = new JavaContext(contextType, (IDocument)document, position, 0, compilationUnit);
        context.setForceEvaluation(true);
        TemplateBuffer buffer = context.evaluate(template);
        if (buffer == null) {
            return null;
        }
        return buffer.getString();
    }
}

