/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StubUtility {
    private static final String[] EMPTY = new String[0];
    private static final List BASE_TYPES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");

    public static String genStub(ICompilationUnit cu, String destTypeName, IMethod method, IType definingType, GenStubSettings settings, IImportsStructure imports) throws CoreException {
        int flags;
        String methName = method.getElementName();
        String[] paramNames = StubUtility.suggestArgumentNames(method.getJavaProject(), method.getParameterNames());
        String returnType = method.isConstructor() ? null : method.getReturnType();
        String lineDelimiter = String.valueOf('\n');
        StringBuffer buf = new StringBuffer();
        if (settings.createComments && cu != null) {
            IMethod overridden = null;
            if (settings.methodOverwrites && returnType != null) {
                overridden = JavaModelUtil.findMethod(methName, method.getParameterTypes(), false, definingType.getMethods());
            }
            String[] typeParameterNames = StubUtility.getTypeParameterNames(method.getTypeParameters());
            String comment = StubUtility.getMethodComment(cu, destTypeName, methName, paramNames, method.getExceptionTypes(), returnType, typeParameterNames, overridden, lineDelimiter);
            if (comment != null) {
                buf.append(comment);
            } else {
                buf.append("/**").append(lineDelimiter);
                buf.append(" *").append(lineDelimiter);
                buf.append(" */").append(lineDelimiter);
            }
            buf.append(lineDelimiter);
        }
        String bodyContent = null;
        if (!settings.noBody) {
            String bodyStatement = StubUtility.getDefaultMethodBodyStatement(methName, paramNames, returnType, settings.callSuper);
            bodyContent = StubUtility.getMethodBodyContent(returnType == null, method.getJavaProject(), destTypeName, methName, bodyStatement, lineDelimiter);
            if (bodyContent == null) {
                bodyContent = "";
            }
        }
        if ((flags = settings.methodModifiers) == -1) {
            flags = method.getFlags();
        }
        StubUtility.genMethodDeclaration(destTypeName, method, flags, bodyContent, imports, buf);
        return buf.toString();
    }

    private static void genMethodDeclaration(String destTypeName, IMethod method, int flags, String bodyContent, IImportsStructure imports, StringBuffer buf) throws CoreException {
        IType parentType = method.getDeclaringType();
        String methodName = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        String[] paramNames = StubUtility.suggestArgumentNames(parentType.getJavaProject(), method.getParameterNames());
        String[] excTypes = method.getExceptionTypes();
        boolean isConstructor = method.isConstructor();
        String retTypeSig = isConstructor ? null : method.getReturnType();
        int lastParam = paramTypes.length - 1;
        if (Flags.isPublic((int)flags) || parentType.isInterface() && bodyContent != null) {
            buf.append("public ");
        } else if (Flags.isProtected((int)flags)) {
            buf.append("protected ");
        } else if (Flags.isPrivate((int)flags)) {
            buf.append("private ");
        }
        if (Flags.isSynchronized((int)flags)) {
            buf.append("synchronized ");
        }
        if (Flags.isVolatile((int)flags)) {
            buf.append("volatile ");
        }
        if (Flags.isStrictfp((int)flags)) {
            buf.append("strictfp ");
        }
        if (Flags.isStatic((int)flags)) {
            buf.append("static ");
        }
        if (isConstructor) {
            buf.append(destTypeName);
        } else {
            String retTypeFrm = !StubUtility.isPrimitiveType(retTypeSig) ? StubUtility.resolveAndAdd(retTypeSig, parentType, imports) : Signature.toString((String)retTypeSig);
            buf.append(retTypeFrm);
            buf.append(' ');
            buf.append(methodName);
        }
        buf.append('(');
        int i = 0;
        while (i <= lastParam) {
            String paramTypeSig = paramTypes[i];
            String paramTypeFrm = !StubUtility.isPrimitiveType(paramTypeSig) ? StubUtility.resolveAndAdd(paramTypeSig, parentType, imports) : Signature.toString((String)paramTypeSig);
            buf.append(paramTypeFrm);
            buf.append(' ');
            buf.append(paramNames[i]);
            if (i < lastParam) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(')');
        int lastExc = excTypes.length - 1;
        if (lastExc >= 0) {
            buf.append(" throws ");
            int i2 = 0;
            while (i2 <= lastExc) {
                String excTypeSig = excTypes[i2];
                String excTypeFrm = StubUtility.resolveAndAdd(excTypeSig, parentType, imports);
                buf.append(excTypeFrm);
                if (i2 < lastExc) {
                    buf.append(", ");
                }
                ++i2;
            }
        }
        if (bodyContent == null) {
            buf.append(";\n\n");
        } else {
            buf.append(" {\n\t");
            if (bodyContent.length() > 0) {
                buf.append(bodyContent);
                buf.append('\n');
            }
            buf.append("}\n");
        }
    }

    public static String getDefaultMethodBodyStatement(String methodName, String[] paramNames, String retTypeSig, boolean callSuper) {
        StringBuffer buf = new StringBuffer();
        if (callSuper) {
            if (retTypeSig != null) {
                if (!"V".equals(retTypeSig)) {
                    buf.append("return ");
                }
                buf.append("super.");
                buf.append(methodName);
            } else {
                buf.append("super");
            }
            buf.append('(');
            int i = 0;
            while (i < paramNames.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(paramNames[i]);
                ++i;
            }
            buf.append(");");
        } else if (retTypeSig != null && !retTypeSig.equals("V")) {
            if (!StubUtility.isPrimitiveType(retTypeSig) || Signature.getArrayCount((String)retTypeSig) > 0) {
                buf.append("return null;");
            } else if (retTypeSig.equals("Z")) {
                buf.append("return false;");
            } else {
                buf.append("return 0;");
            }
        }
        return buf.toString();
    }

    public static String getMethodBodyContent(boolean isConstructor, IJavaProject project, String destTypeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateName = isConstructor ? "org.eclipse.jdt.ui.text.codetemplates.constructorbody" : "org.eclipse.jdt.ui.text.codetemplates.methodbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return bodyStatement;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("body_statement", bodyStatement);
        String str = StubUtility.evaluateTemplate(context, template, new String[]{"body_statement"});
        if (str == null && !Strings.containsOnlyWhitespaces(bodyStatement)) {
            return bodyStatement;
        }
        return str;
    }

    public static String getGetterMethodBodyContent(IJavaProject project, String destTypeName, String methodName, String fieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.getterbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterMethodBodyContent(IJavaProject project, String destTypeName, String methodName, String fieldName, String paramName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.setterbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCatchBodyContent(ICompilationUnit cu, String exceptionType, String variableName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.catchblock", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setVariable("exception_type", exceptionType);
        context.setVariable("exception_var", variableName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCompilationUnitContent(ICompilationUnit cu, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String packDecl = pack.isDefaultPackage() ? "" : "package " + pack.getElementName() + ';';
        Template template = StubUtility.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.newtype", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        IJavaProject project = cu.getJavaProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("package_declaration", packDecl);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        context.setVariable("type_declaration", typeContent);
        context.setVariable("type_name", Signature.getQualifier((String)cu.getElementName()));
        String[] fullLine = new String[]{"package_declaration", "filecomment", "typecomment"};
        return StubUtility.evaluateTemplate(context, template, fullLine);
    }

    public static String getFileComment(ICompilationUnit cu, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.filecomment", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        IJavaProject project = cu.getJavaProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("type_name", Signature.getQualifier((String)cu.getElementName()));
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getTypeComment(ICompilationUnit cu, String typeQualifiedName, String[] typeParameterNames, String lineDelim) throws CoreException {
        TemplateBuffer buffer;
        Template template = StubUtility.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.typecomment", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelim);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", Signature.getQualifier((String)typeQualifiedName));
        context.setVariable("type_name", Signature.getSimpleName((String)typeQualifiedName));
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document document = new Document(str);
        int[] tagOffsets = position.getOffsets();
        int i = tagOffsets.length - 1;
        while (i >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, tagOffsets[i], position.getLength(), EMPTY, EMPTY, null, typeParameterNames, false, lineDelim);
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
            --i;
        }
        return document.get();
    }

    private static String[] getParameterTypesQualifiedNames(IMethodBinding binding) {
        ITypeBinding[] typeBindings = binding.getParameterTypes();
        String[] result = new String[typeBindings.length];
        int i = 0;
        while (i < result.length) {
            result[i] = typeBindings[i].isTypeVariable() ? typeBindings[i].getName() : typeBindings[i].getTypeDeclaration().getQualifiedName();
            ++i;
        }
        return result;
    }

    private static String getSeeTag(String declaringClassQualifiedName, String methodName, String[] parameterTypesQualifiedNames) {
        StringBuffer buf = new StringBuffer();
        buf.append("@see ");
        buf.append(declaringClassQualifiedName);
        buf.append('#');
        buf.append(methodName);
        buf.append('(');
        int i = 0;
        while (i < parameterTypesQualifiedNames.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(parameterTypesQualifiedNames[i]);
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    private static String getSeeTag(IMethod overridden) throws JavaModelException {
        IType declaringType = overridden.getDeclaringType();
        StringBuffer buf = new StringBuffer();
        buf.append("@see ");
        buf.append(declaringType.getFullyQualifiedName('.'));
        buf.append('#');
        buf.append(overridden.getElementName());
        buf.append('(');
        String[] paramTypes = overridden.getParameterTypes();
        int i = 0;
        while (i < paramTypes.length) {
            if (i > 0) {
                buf.append(", ");
            }
            String curr = Signature.getTypeErasure((String)paramTypes[i]);
            buf.append(JavaModelUtil.getResolvedTypeName(curr, declaringType));
            int arrayCount = Signature.getArrayCount((String)curr);
            while (arrayCount > 0) {
                buf.append("[]");
                --arrayCount;
            }
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public static String[] getTypeParameterNames(ITypeParameter[] typeParameters) {
        String[] typeParametersNames = new String[typeParameters.length];
        int i = 0;
        while (i < typeParameters.length) {
            typeParametersNames[i] = typeParameters[i].getElementName();
            ++i;
        }
        return typeParametersNames;
    }

    public static String getMethodComment(IMethod method, IMethod overridden, String lineDelimiter) throws CoreException {
        String retType = method.isConstructor() ? null : method.getReturnType();
        String[] paramNames = method.getParameterNames();
        String[] typeParameterNames = StubUtility.getTypeParameterNames(method.getTypeParameters());
        return StubUtility.getMethodComment(method.getCompilationUnit(), method.getDeclaringType().getElementName(), method.getElementName(), paramNames, method.getExceptionTypes(), retType, typeParameterNames, overridden, lineDelimiter);
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, String[] typeParameterNames, IMethod overridden, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.methodcomment";
        if (retTypeSig == null) {
            templateName = "org.eclipse.jdt.ui.text.codetemplates.constructorcomment";
        } else if (overridden != null) {
            templateName = "org.eclipse.jdt.ui.text.codetemplates.overridecomment";
        }
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        if (retTypeSig != null) {
            context.setVariable("return_type", Signature.toString((String)retTypeSig));
        }
        if (overridden != null) {
            context.setVariable("see_to_overridden", StubUtility.getSeeTag(overridden));
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document document = new Document(str);
        String[] exceptionNames = new String[excTypeSig.length];
        int i = 0;
        while (i < excTypeSig.length) {
            exceptionNames[i] = Signature.toString((String)excTypeSig[i]);
            ++i;
        }
        String returnType = retTypeSig != null ? Signature.toString((String)retTypeSig) : null;
        int[] tagOffsets = position.getOffsets();
        int i2 = tagOffsets.length - 1;
        while (i2 >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, tagOffsets[i2], position.getLength(), paramNames, exceptionNames, returnType, typeParameterNames, false, lineDelimiter);
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
            --i2;
        }
        return document.get();
    }

    private static String fixEmptyVariables(TemplateBuffer buffer, String[] variables) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(buffer.getString());
        int nLines = doc.getNumberOfLines();
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> removedLines = new HashSet<Integer>();
        int i = 0;
        while (i < variables.length) {
            TemplateVariable position = StubUtility.findVariable(buffer, variables[i]);
            if (position != null && position.getLength() <= 0) {
                int[] offsets = position.getOffsets();
                int k = 0;
                while (k < offsets.length) {
                    int line = doc.getLineOfOffset(offsets[k]);
                    IRegion lineInfo = doc.getLineInformation(line);
                    int offset = lineInfo.getOffset();
                    String str = doc.get(offset, lineInfo.getLength());
                    if (Strings.containsOnlyWhitespaces(str) && nLines > line + 1 && removedLines.add(new Integer(line))) {
                        int nextStart = doc.getLineOffset(line + 1);
                        edit.addChild((TextEdit)new DeleteEdit(offset, nextStart - offset));
                    }
                    ++k;
                }
            }
            ++i;
        }
        edit.apply((IDocument)doc, 0);
        return doc.get();
    }

    public static String getFieldComment(ICompilationUnit cu, String typeName, String fieldName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.fieldcomment", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("field_type", typeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterComment(ICompilationUnit cu, String typeName, String methodName, String fieldName, String fieldType, String paramName, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.settercomment";
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getGetterComment(ICompilationUnit cu, String typeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.gettercomment";
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String evaluateTemplate(CodeTemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    public static String evaluateTemplate(CodeTemplateContext context, Template template, String[] fullLineVariables) throws CoreException {
        try {
            TemplateBuffer buffer = context.evaluate(template);
            if (buffer == null) {
                return null;
            }
            String str = StubUtility.fixEmptyVariables(buffer, fullLineVariables);
            if (Strings.containsOnlyWhitespaces(str)) {
                return null;
            }
            return str;
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, MethodDeclaration decl, IMethodBinding overridden, String lineDelimiter) throws CoreException {
        if (overridden != null) {
            overridden = overridden.getMethodDeclaration();
            String declaringClassQualifiedName = overridden.getDeclaringClass().getQualifiedName();
            String[] parameterTypesQualifiedNames = StubUtility.getParameterTypesQualifiedNames(overridden);
            return StubUtility.getMethodComment(cu, typeName, decl, true, overridden.isDeprecated(), declaringClassQualifiedName, parameterTypesQualifiedNames, lineDelimiter);
        }
        return StubUtility.getMethodComment(cu, typeName, decl, false, false, null, null, lineDelimiter);
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, MethodDeclaration decl, boolean isOverridden, boolean isDeprecated, String declaringClassQualifiedName, String[] parameterTypesQualifiedNames, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.methodcomment";
        if (decl.isConstructor()) {
            templateName = "org.eclipse.jdt.ui.text.codetemplates.constructorcomment";
        } else if (isOverridden) {
            templateName = "org.eclipse.jdt.ui.text.codetemplates.overridecomment";
        }
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", decl.getName().getIdentifier());
        if (!decl.isConstructor()) {
            Type returnType = decl.getAST().apiLevel() == 2 ? decl.getReturnType() : decl.getReturnType2();
            context.setVariable("return_type", ASTNodes.asString((ASTNode)returnType));
        }
        if (isOverridden) {
            String methodName = decl.getName().getIdentifier();
            context.setVariable("see_to_overridden", StubUtility.getSeeTag(declaringClassQualifiedName, methodName, parameterTypesQualifiedNames));
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document textBuffer = new Document(str);
        List typeParams = decl.typeParameters();
        String[] typeParamNames = new String[typeParams.size()];
        int i = 0;
        while (i < typeParamNames.length) {
            TypeParameter elem = (TypeParameter)typeParams.get(i);
            typeParamNames[i] = elem.getName().getIdentifier();
            ++i;
        }
        List params = decl.parameters();
        String[] paramNames = new String[params.size()];
        int i2 = 0;
        while (i2 < paramNames.length) {
            SingleVariableDeclaration elem = (SingleVariableDeclaration)params.get(i2);
            paramNames[i2] = elem.getName().getIdentifier();
            ++i2;
        }
        List exceptions = decl.thrownExceptions();
        String[] exceptionNames = new String[exceptions.size()];
        int i3 = 0;
        while (i3 < exceptionNames.length) {
            exceptionNames[i3] = ASTNodes.getSimpleNameIdentifier((Name)exceptions.get(i3));
            ++i3;
        }
        String returnType = null;
        if (!decl.isConstructor()) {
            returnType = ASTNodes.asString((ASTNode)(decl.getAST().apiLevel() == 2 ? decl.getReturnType() : decl.getReturnType2()));
        }
        int[] tagOffsets = position.getOffsets();
        int i4 = tagOffsets.length - 1;
        while (i4 >= 0) {
            try {
                StubUtility.insertTag((IDocument)textBuffer, tagOffsets[i4], position.getLength(), paramNames, exceptionNames, returnType, typeParamNames, isDeprecated, lineDelimiter);
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
            --i4;
        }
        return textBuffer.get();
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void insertTag(IDocument textBuffer, int offset, int length, String[] paramNames, String[] exceptionNames, String returnType, String[] typeParameterNames, boolean isDeprecated, String lineDelimiter) throws BadLocationException {
        int prevLine;
        IRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.get(region.getOffset(), offset - region.getOffset());
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < typeParameterNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param <").append(typeParameterNames[i]).append('>');
            ++i;
        }
        i = 0;
        while (i < paramNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param ").append(paramNames[i]);
            ++i;
        }
        if (returnType != null && !returnType.equals("void")) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@return");
        }
        if (exceptionNames != null) {
            i = 0;
            while (i < exceptionNames.length) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter).append(lineStart);
                }
                buf.append("@throws ").append(exceptionNames[i]);
                ++i;
            }
        }
        if (isDeprecated) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@deprecated");
        }
        if (buf.length() == 0 && StubUtility.isAllCommentWhitespace(lineStart) && (prevLine = textBuffer.getLineOfOffset(offset) - 1) > 0) {
            IRegion prevRegion = textBuffer.getLineInformation(prevLine);
            int prevLineEnd = prevRegion.getOffset() + prevRegion.getLength();
            textBuffer.replace(prevLineEnd, offset + length - prevLineEnd, "");
            return;
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static boolean isAllCommentWhitespace(String lineStart) {
        int i = 0;
        while (i < lineStart.length()) {
            char ch = lineStart.charAt(i);
            if (!Character.isWhitespace(ch) && ch != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isPrimitiveType(String typeName) {
        char first = Signature.getElementType((String)typeName).charAt(0);
        return first != 'L' && first != 'Q' && first != 'T';
    }

    private static String resolveAndAdd(String refTypeSig, IType declaringType, IImportsStructure imports) throws JavaModelException {
        int genericStart = refTypeSig.indexOf(60);
        if (genericStart != -1) {
            StringBuffer buf = new StringBuffer();
            String erasure = StubUtility.resolveAndAdd(Signature.getTypeErasure((String)refTypeSig), declaringType, imports);
            buf.append(erasure);
            buf.append('<');
            String[] typeArguments = Signature.getTypeArguments((String)refTypeSig);
            if (typeArguments.length > 0) {
                int i = 0;
                while (i < typeArguments.length) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(StubUtility.resolveAndAdd(typeArguments[i], declaringType, imports));
                    ++i;
                }
            }
            buf.append('>');
            return buf.toString();
        }
        if (refTypeSig.length() > 0) {
            switch (refTypeSig.charAt(0)) {
                case '[': {
                    int arrayCount = Signature.getArrayCount((String)refTypeSig);
                    StringBuffer buf = new StringBuffer();
                    buf.append(StubUtility.resolveAndAdd(Signature.getElementType((String)refTypeSig), declaringType, imports));
                    int i = 0;
                    while (i < arrayCount) {
                        buf.append("[]");
                        ++i;
                    }
                    return buf.toString();
                }
                case 'L': 
                case 'Q': {
                    String resolvedTypeName = JavaModelUtil.getResolvedTypeName(refTypeSig, declaringType);
                    if (resolvedTypeName == null) break;
                    if (imports == null) {
                        return resolvedTypeName;
                    }
                    return imports.addImport(resolvedTypeName);
                }
                case '+': {
                    return "? extends " + StubUtility.resolveAndAdd(refTypeSig.substring(1), declaringType, imports);
                }
                case '-': {
                    return "? super " + StubUtility.resolveAndAdd(refTypeSig.substring(1), declaringType, imports);
                }
            }
        }
        return Signature.toString((String)refTypeSig);
    }

    private static IMethod findMethod(IMethod method, List allMethods) throws JavaModelException {
        String name = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        boolean isConstructor = method.isConstructor();
        int i = allMethods.size() - 1;
        while (i >= 0) {
            IMethod curr = (IMethod)allMethods.get(i);
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, curr)) {
                return curr;
            }
            --i;
        }
        return null;
    }

    public static IMethod[] getOverridableConstructors(IType type) throws CoreException {
        IType objectType;
        IMethod curr;
        ArrayList<IMethod> constructorMethods = new ArrayList<IMethod>();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType supertype = hierarchy.getSuperclass(type);
        if (supertype == null) {
            return new IMethod[0];
        }
        IMethod[] superMethods = supertype.getMethods();
        boolean constuctorFound = false;
        String typeName = type.getElementName();
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < superMethods.length) {
            curr = superMethods[i];
            if (curr.isConstructor()) {
                constuctorFound = true;
                if (JavaModelUtil.isVisibleInHierarchy((IMember)curr, type.getPackageFragment()) && JavaModelUtil.findMethod(typeName, curr.getParameterTypes(), true, methods) == null) {
                    constructorMethods.add(curr);
                }
            }
            ++i;
        }
        if (!constuctorFound && JavaModelUtil.findMethod(typeName, (curr = (objectType = type.getJavaProject().findType("java.lang.Object")).getMethod("Object", EMPTY)).getParameterTypes(), true, methods) == null) {
            constructorMethods.add(curr);
        }
        return constructorMethods.toArray(new IMethod[constructorMethods.size()]);
    }

    public static IMethod[] getOverridableMethods(IType type, ITypeHierarchy hierarchy, boolean isSubType) throws JavaModelException {
        ArrayList<IMethod> allMethods = new ArrayList<IMethod>();
        IMethod[] typeMethods = type.getMethods();
        int i = 0;
        while (i < typeMethods.length) {
            IMethod curr = typeMethods[i];
            if (!(curr.isConstructor() || Flags.isStatic((int)curr.getFlags()) || Flags.isPrivate((int)curr.getFlags()))) {
                allMethods.add(curr);
            }
            ++i;
        }
        IType[] superTypes = hierarchy.getAllSuperclasses(type);
        int i2 = 0;
        while (i2 < superTypes.length) {
            IMethod[] methods = superTypes[i2].getMethods();
            int k = 0;
            while (k < methods.length) {
                IMethod curr = methods[k];
                if (!(curr.isConstructor() || Flags.isStatic((int)curr.getFlags()) || Flags.isPrivate((int)curr.getFlags()) || StubUtility.findMethod(curr, allMethods) != null)) {
                    allMethods.add(curr);
                }
                ++k;
            }
            ++i2;
        }
        IType[] superInterfaces = hierarchy.getAllSuperInterfaces(type);
        int i3 = 0;
        while (i3 < superInterfaces.length) {
            IMethod[] methods = superInterfaces[i3].getMethods();
            int k = 0;
            while (k < methods.length) {
                IMethod impl;
                IMethod curr = methods[k];
                if (!(Flags.isStatic((int)curr.getFlags()) || (impl = StubUtility.findMethod(curr, allMethods)) != null && JavaModelUtil.isVisibleInHierarchy((IMember)impl, type.getPackageFragment()) && !StubUtility.prefereInterfaceMethod(hierarchy, curr, impl))) {
                    if (impl != null) {
                        allMethods.remove(impl);
                    }
                    allMethods.add(curr);
                }
                ++k;
            }
            ++i3;
        }
        if (!isSubType) {
            allMethods.removeAll(Arrays.asList(typeMethods));
        }
        i3 = allMethods.size() - 1;
        while (i3 >= 0) {
            IMethod curr = (IMethod)allMethods.get(i3);
            if (Flags.isFinal((int)curr.getFlags())) {
                allMethods.remove(i3);
            }
            --i3;
        }
        return allMethods.toArray(new IMethod[allMethods.size()]);
    }

    private static boolean prefereInterfaceMethod(ITypeHierarchy hierarchy, IMethod interfaceMethod, IMethod curr) throws JavaModelException {
        if (Flags.isFinal((int)curr.getFlags())) {
            return false;
        }
        IType interfaceType = interfaceMethod.getDeclaringType();
        IType[] interfaces = hierarchy.getAllSuperInterfaces(curr.getDeclaringType());
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i] == interfaceType) {
                return false;
            }
            ++i;
        }
        return curr.getExceptionTypes().length > interfaceMethod.getExceptionTypes().length;
    }

    public static String getLineDelimiterUsed(IJavaProject project) {
        return StubUtility.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(IJavaProject javaProject) {
        String lineDelimiter;
        IProject project = null;
        if (javaProject != null) {
            project = javaProject.getProject();
        }
        if ((lineDelimiter = StubUtility.getLineDelimiterPreference(project)) != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterPreference(IProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    public static String getLineDelimiterUsed(IJavaElement elem) {
        ICompilationUnit cu = null;
        if (elem != null) {
            cu = (ICompilationUnit)elem.getAncestor(5);
        }
        if (cu != null && cu.exists()) {
            try {
                IBuffer buf = cu.getBuffer();
                int length = buf.getLength();
                int i = 0;
                while (i < length) {
                    char ch = buf.getChar(i);
                    if (ch == '\r') {
                        if (i + 1 < length && buf.getChar(i + 1) == '\n') {
                            return "\r\n";
                        }
                        return "\r";
                    }
                    if (ch == '\n') {
                        return "\n";
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
            return StubUtility.getProjectLineDelimiter(cu.getJavaProject());
        }
        return StubUtility.getProjectLineDelimiter(null);
    }

    public static int getIndentUsed(IJavaElement elem) throws JavaModelException {
        ICompilationUnit cu;
        if (elem instanceof ISourceReference && (cu = (ICompilationUnit)elem.getAncestor(5)) != null) {
            int offset;
            IBuffer buf = cu.getBuffer();
            int i = offset = ((ISourceReference)elem).getSourceRange().getOffset();
            while (i > 0 && !Strings.isLineDelimiterChar(buf.getChar(i - 1))) {
                --i;
            }
            return Strings.computeIndentUnits(buf.getText(i, offset - i), elem.getJavaProject());
        }
        return 0;
    }

    public static IJavaElement findNextSibling(IJavaElement member) throws JavaModelException {
        IJavaElement parent = member.getParent();
        if (parent instanceof IParent) {
            IJavaElement[] elements = ((IParent)parent).getChildren();
            int i = elements.length - 2;
            while (i >= 0) {
                if (member.equals(elements[i])) {
                    return elements[i + 1];
                }
                --i;
            }
        }
        return null;
    }

    public static String getTodoTaskTag(IJavaProject project) {
        String markers = null;
        markers = project == null ? JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.taskTags") : project.getOption("org.eclipse.jdt.core.compiler.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return null;
    }

    public static String[] getArgumentNameSuggestions(IJavaProject project, String baseName, int dimensions, String[] excluded) {
        String name = StubUtility.workaround38111(baseName);
        String[] res = NamingConventions.suggestArgumentNames((IJavaProject)project, (String)"", (String)name, (int)dimensions, (String[])excluded);
        return StubUtility.sortByLength(res);
    }

    public static String[] getFieldNameSuggestions(IJavaProject project, String baseName, int dimensions, int modifiers, String[] excluded) {
        String[] res;
        String name = StubUtility.workaround38111(baseName);
        if (modifiers == 24) {
            List<String> excludedList = Arrays.asList(excluded);
            String[] camelCase = NamingConventions.suggestLocalVariableNames((IJavaProject)project, (String)"", (String)name, (int)dimensions, (String[])new String[0]);
            ArrayList<String> result = new ArrayList<String>(camelCase.length);
            int i = 0;
            while (i < camelCase.length) {
                String upper = StubUtility.getUpperFromCamelCase(camelCase[i]);
                if (!excludedList.contains(upper)) {
                    result.add(upper);
                }
                ++i;
            }
            res = result.toArray(new String[result.size()]);
        } else {
            res = NamingConventions.suggestFieldNames((IJavaProject)project, (String)"", (String)name, (int)dimensions, (int)modifiers, (String[])excluded);
        }
        return StubUtility.sortByLength(res);
    }

    private static String getUpperFromCamelCase(String string) {
        StringBuffer result = new StringBuffer();
        boolean lastWasLowerCase = false;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (lastWasLowerCase) {
                    result.append('_');
                }
                result.append(ch);
            } else {
                result.append(Character.toUpperCase(ch));
            }
            lastWasLowerCase = Character.isLowerCase(ch);
            ++i;
        }
        return result.toString();
    }

    public static String[] getLocalNameSuggestions(IJavaProject project, String baseName, int dimensions, String[] excluded) {
        String name = StubUtility.workaround38111(baseName);
        String[] res = NamingConventions.suggestLocalVariableNames((IJavaProject)project, (String)"", (String)name, (int)dimensions, (String[])excluded);
        return StubUtility.sortByLength(res);
    }

    private static String[] sortByLength(String[] proposals) {
        Arrays.sort(proposals, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o2).length() - ((String)o1).length();
            }
        });
        return proposals;
    }

    private static String workaround38111(String baseName) {
        if (BASE_TYPES.contains(baseName)) {
            return baseName;
        }
        return String.valueOf(Character.toUpperCase(baseName.charAt(0))) + baseName.substring(1);
    }

    public static String suggestArgumentName(IJavaProject project, String baseName, String[] excluded) {
        String[] argnames = StubUtility.getArgumentNameSuggestions(project, baseName, 0, excluded);
        if (argnames.length > 0) {
            return argnames[0];
        }
        return baseName;
    }

    public static String[] suggestArgumentNames(IJavaProject project, String[] paramNames) {
        String suffixes;
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.argumentPrefixes", true);
        if (prefixes == null) {
            prefixes = "";
        }
        if ((suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.argumentSuffixes", true)) == null) {
            suffixes = "";
        }
        if (prefixes.length() + suffixes.length() == 0) {
            return paramNames;
        }
        String[] newNames = new String[paramNames.length];
        int i = 0;
        while (i < paramNames.length) {
            String curr = paramNames[i];
            newNames[i] = !StubUtility.hasPrefixOrSuffix(prefixes, suffixes, curr) ? StubUtility.suggestArgumentName(project, paramNames[i], null) : curr;
            ++i;
        }
        return newNames;
    }

    public static boolean hasFieldName(IJavaProject project, String name) {
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.fieldPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.fieldSuffixes", true);
        String staticPrefixes = project.getOption("org.eclipse.jdt.core.codeComplete.staticFieldPrefixes", true);
        String staticSuffixes = project.getOption("org.eclipse.jdt.core.codeComplete.staticFieldSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name) || StubUtility.hasPrefixOrSuffix(staticPrefixes, staticSuffixes, name);
    }

    public static boolean hasParameterName(IJavaProject project, String name) {
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.argumentPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.argumentSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    public static boolean hasLocalVariableName(IJavaProject project, String name) {
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.localPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.localSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    public static boolean hasConstantName(String name) {
        return Character.isUpperCase(name.charAt(0));
    }

    private static boolean hasPrefixOrSuffix(String prefixes, String suffixes, String name) {
        String curr;
        StringTokenizer tok = new StringTokenizer(prefixes, ",");
        while (tok.hasMoreTokens()) {
            curr = tok.nextToken();
            if (!name.startsWith(curr)) continue;
            return true;
        }
        tok = new StringTokenizer(suffixes, ",");
        while (tok.hasMoreTokens()) {
            curr = tok.nextToken();
            if (!name.endsWith(curr)) continue;
            return true;
        }
        return false;
    }

    public static boolean useThisForFieldAccess(IJavaProject project) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.jdt.ui.keywordthis", project));
    }

    public static boolean useIsForBooleanGetters(IJavaProject project) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.jdt.ui.gettersetter.use.is", project));
    }

    public static String getExceptionVariableName(IJavaProject project) {
        return PreferenceConstants.getPreference("org.eclipse.jdt.ui.exception.name", project);
    }

    public static boolean doAddComments(IJavaProject project) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.jdt.ui.javadoc", project));
    }

    public static void setCodeTemplate(String templateId, String pattern, IJavaProject project) {
        TemplateStore codeTemplateStore = JavaPlugin.getDefault().getCodeTemplateStore();
        TemplatePersistenceData data = codeTemplateStore.getTemplateData(templateId);
        Template orig = data.getTemplate();
        Template copy = new Template(orig.getName(), orig.getDescription(), orig.getContextTypeId(), pattern, true);
        data.setTemplate(copy);
    }

    private static Template getCodeTemplate(String id, IJavaProject project) {
        if (project == null) {
            return JavaPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(project.getProject());
        try {
            projectStore.load();
        }
        catch (IOException e) {
            JavaPlugin.log(e);
        }
        return projectStore.findTemplateById(id);
    }

    public static class GenStubSettings
    extends CodeGenerationSettings {
        public boolean callSuper;
        public boolean methodOverwrites;
        public boolean noBody;
        public int methodModifiers;

        public GenStubSettings(CodeGenerationSettings settings) {
            settings.setSettings(this);
            this.methodModifiers = -1;
        }
    }
}

