/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part;

import java.util.ArrayList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.part.StandardWorkbenchServices;

public class CompatibilityPartSite
implements IWorkbenchPartSite,
IViewSite,
IEditorSite {
    private ArrayList menuExtenders;
    private IWorkbenchPart part;
    private ISelectionProvider selectionProvider;
    private IActionBars actionBars;
    private IEditorActionBarContributor actionBarContributor;
    private StandardWorkbenchServices services;
    private ISelectionChangedListener selectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            CompatibilityPartSite.this.services.getSelectionHandler().setSelection(event.getSelection());
        }
    };

    public CompatibilityPartSite(StandardWorkbenchServices services, IWorkbenchPart part, IEditorActionBarContributor actionBarContributor, IActionBars actionBars) {
        this.services = services;
        this.part = part;
        this.actionBarContributor = actionBarContributor;
        this.actionBars = actionBars;
    }

    public String getId() {
        return this.services.getDescriptor().getId();
    }

    public String getPluginId() {
        return this.services.getPluginBundle().getSymbolicName();
    }

    public String getRegisteredName() {
        return this.services.getDescriptor().getLabel();
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selProvider) {
        this.registerContextMenu(this.getId(), menuManager, selProvider);
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(menuID, menuMgr, selProvider, true, this.part, this.menuExtenders);
    }

    public IKeyBindingService getKeyBindingService() {
        return this.services.getKeyBindingService();
    }

    public IWorkbenchPage getPage() {
        return this.services.getPage();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Shell getShell() {
        return this.getWorkbenchWindow().getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.getPage().getWorkbenchWindow();
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(this.selectionChangeListener);
        }
        this.selectionProvider = provider;
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.selectionChangeListener);
            this.services.getSelectionHandler().setSelection(provider.getSelection());
        } else {
            provider.setSelection(null);
        }
    }

    public Object getAdapter(Class adapter) {
        return this.services.getAdapter(adapter);
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public IEditorActionBarContributor getActionBarContributor() {
        return this.actionBarContributor;
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    public String getSecondaryId() {
        return this.services.getSecondaryId().getSecondaryId();
    }

    public final void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(menuId, menuManager, selectionProvider, includeEditorInput, this.part, this.menuExtenders);
    }

    public final void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
        this.registerContextMenu(this.getId(), menuManager, selectionProvider, includeEditorInput);
    }
}

