/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.util;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.internal.components.framework.ComponentHandle;
import org.eclipse.ui.internal.components.framework.IServiceProvider;
import org.eclipse.ui.internal.components.framework.NonDisposingHandle;
import org.eclipse.ui.internal.components.framework.ServiceFactory;

public class InstanceToServiceFactoryAdapter
extends ServiceFactory {
    private Object originalObject;
    private ComponentHandle handleForOriginalObject;

    public InstanceToServiceFactoryAdapter(Object originalObject) {
        this.handleForOriginalObject = new NonDisposingHandle(originalObject);
        this.originalObject = originalObject;
    }

    public ComponentHandle createHandle(Object componentKey, IServiceProvider container) {
        if (componentKey instanceof Class) {
            Object adapter;
            Class c = (Class)componentKey;
            if (c.isInstance(this.originalObject)) {
                return this.handleForOriginalObject;
            }
            if (this.originalObject instanceof IAdaptable && (adapter = ((IAdaptable)this.originalObject).getAdapter(c)) != null) {
                return new NonDisposingHandle(adapter);
            }
        }
        return null;
    }

    public boolean hasService(Object componentKey) {
        if (componentKey instanceof Class) {
            Object adapter;
            Class c = (Class)componentKey;
            if (c.isInstance(this.originalObject)) {
                return true;
            }
            if (this.originalObject instanceof IAdaptable && (adapter = ((IAdaptable)this.originalObject).getAdapter(c)) != null) {
                return true;
            }
        }
        return false;
    }

    public Collection getMissingDependencies() {
        return Collections.EMPTY_SET;
    }
}

