/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.framework;

import java.lang.ref.WeakReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.components.ComponentMessages;
import org.eclipse.ui.internal.components.ComponentUtil;
import org.eclipse.ui.internal.components.framework.ClassIdentifier;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.ComponentFactory;
import org.eclipse.ui.internal.components.framework.ComponentHandle;
import org.eclipse.ui.internal.components.framework.IServiceProvider;
import org.eclipse.ui.internal.components.framework.NonDisposingHandle;

public class SingletonFactory
extends ComponentFactory
implements IExecutableExtension {
    private WeakReference singletonInstance;
    private ClassIdentifier classId = null;

    public SingletonFactory() {
    }

    public SingletonFactory(ClassIdentifier classId) {
        this.classId = classId;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.classId = ComponentUtil.getClassFromInitializationData(config, data);
    }

    public ComponentHandle createHandle(IServiceProvider availableServices) throws ComponentException {
        if (this.singletonInstance != null) {
            Object result = this.singletonInstance.get();
            if (result != null) {
                return new NonDisposingHandle(result);
            }
            this.singletonInstance = null;
        }
        Class clazz = ComponentUtil.loadClass(this.classId);
        try {
            Object ref = clazz.newInstance();
            this.singletonInstance = new WeakReference(ref);
            return new NonDisposingHandle(ref);
        }
        catch (InstantiationException e) {
            throw new ComponentException(clazz, NLS.bind((String)ComponentMessages.Components_instantiationException, (Object)clazz.getName()), e);
        }
        catch (Exception e) {
            throw new ComponentException(clazz, (Throwable)e);
        }
    }
}

