/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.internal.resources.mapping.ResourceMapping;
import org.eclipse.core.internal.resources.mapping.ResourceMappingContext;
import org.eclipse.core.internal.resources.mapping.ResourceTraversal;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.dialogs.IResourceMappingResourceFilter;
import org.eclipse.team.internal.ui.dialogs.MappingSelectionDialog;
import org.eclipse.team.internal.ui.dialogs.ResourceMappingResourceDisplayArea;

public abstract class UncommittedChangesDialog
extends MappingSelectionDialog {
    private final ResourceMapping[] allMappings;

    public static FastSyncInfoFilter getResourceFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12});
    }

    public UncommittedChangesDialog(Shell parentShell, String dialogTitle, ResourceMapping[] mappings, IProgressMonitor monitor) {
        super(parentShell, dialogTitle, UncommittedChangesDialog.getMatchingMappings(mappings, (Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), UncommittedChangesDialog.getResourceFilter(), monitor), (IResourceMappingResourceFilter)new UncommittedFilter());
        this.allMappings = mappings;
    }

    protected String getResourceListMessage(ResourceMapping mapping) {
        if (mapping == null) {
            return CVSUIMessages.UncommittedChangesDialog_2;
        }
        String label = ResourceMappingResourceDisplayArea.getLabel((ResourceMapping)mapping);
        if (mapping.getModelObject() instanceof IFile) {
            return NLS.bind((String)CVSUIMessages.UncommittedChangesDialog_4, (Object[])new String[]{label});
        }
        return NLS.bind((String)CVSUIMessages.UncommittedChangesDialog_3, (Object[])new String[]{label});
    }

    public ResourceMapping[] promptToSelectMappings() {
        ResourceMapping[] matchingMappings = this.getMappings();
        if (matchingMappings.length > 0) {
            int code = this.open();
            if (code == 0) {
                HashSet<ResourceMapping> result = new HashSet<ResourceMapping>();
                result.addAll(Arrays.asList(this.allMappings));
                result.removeAll(Arrays.asList(matchingMappings));
                result.addAll(Arrays.asList(this.getCheckedMappings()));
                return result.toArray(new ResourceMapping[result.size()]);
            }
            return new ResourceMapping[0];
        }
        return this.allMappings;
    }

    private static ResourceMapping[] getMatchingMappings(ResourceMapping[] mappings, Subscriber subscriber, FastSyncInfoFilter resourceFilter, IProgressMonitor monitor) {
        HashSet<ResourceMapping> result = new HashSet<ResourceMapping>();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            if (UncommittedChangesDialog.matchesFilter(mapping, subscriber, resourceFilter, monitor)) {
                result.add(mapping);
            }
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    private static boolean matchesFilter(ResourceMapping mapping, final Subscriber subscriber, final FastSyncInfoFilter resourceFilter, IProgressMonitor monitor) {
        try {
            mapping.accept(ResourceMappingContext.LOCAL_CONTEXT, new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    SyncInfo info = subscriber.getSyncInfo(resource);
                    if (info != null && resourceFilter.select(info)) {
                        throw new CoreException(Status.OK_STATUS);
                    }
                    return true;
                }
            }, monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().isOK()) {
                return true;
            }
            CVSUIPlugin.log(e);
        }
        return false;
    }

    public ResourceMapping[] getAllMappings() {
        return this.allMappings;
    }

    protected boolean includeCancelButton() {
        if (super.includeCancelButton()) {
            return this.getAllMappings().length > 1;
        }
        return false;
    }

    public static final class UncommittedFilter
    implements IResourceMappingResourceFilter {
        public boolean select(IResource resource, ResourceMapping mapping, ResourceTraversal traversal) throws CoreException {
            SyncInfo info = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().getSyncInfo(resource);
            return info != null && UncommittedChangesDialog.getResourceFilter().select(info);
        }
    }
}

