/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.IModelChangeProviderExtension;
import org.eclipse.pde.internal.core.IModelChangedListenerFilter;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.xml.sax.SAXException;

public abstract class AbstractModel
extends PlatformObject
implements IModel,
IModelChangeProviderExtension,
Serializable {
    private transient List listeners = Collections.synchronizedList(new ArrayList());
    private boolean loaded;
    protected transient NLResourceHelper nlHelper;
    protected boolean disposed;
    private long timeStamp;

    public void addModelChangedListener(IModelChangedListener listener) {
        this.listeners.add(listener);
    }

    public void transferListenersTo(IModelChangeProviderExtension target, IModelChangedListenerFilter filter) {
        ArrayList<IModelChangedListener> removed = new ArrayList<IModelChangedListener>();
        int i = 0;
        while (i < this.listeners.size()) {
            IModelChangedListener listener = (IModelChangedListener)this.listeners.get(i);
            if (filter == null || filter.accept(listener)) {
                target.addModelChangedListener(listener);
                removed.add(listener);
            }
            ++i;
        }
        this.listeners.removeAll(removed);
    }

    protected NLResourceHelper createNLResourceHelper() {
        return null;
    }

    public NLResourceHelper getNLResourceHelper() {
        if (this.nlHelper == null) {
            this.nlHelper = this.createNLResourceHelper();
        }
        return this.nlHelper;
    }

    public void resetNLResourceHelper() {
        this.nlHelper = null;
    }

    public void dispose() {
        if (this.nlHelper != null) {
            this.nlHelper.dispose();
            this.nlHelper = null;
        }
        this.disposed = true;
    }

    public void fireModelChanged(IModelChangedEvent event) {
        IModelChangedListener[] list = this.listeners.toArray(new IModelChangedListener[this.listeners.size()]);
        int i = 0;
        while (i < list.length) {
            IModelChangedListener listener = list[i];
            listener.modelChanged(event);
            ++i;
        }
    }

    public void fireModelObjectChanged(Object object, String property, Object oldValue, Object newValue) {
        this.fireModelChanged(new ModelChangedEvent(this, object, property, oldValue, newValue));
    }

    public String getResourceString(String key) {
        if (this.nlHelper == null) {
            this.nlHelper = this.createNLResourceHelper();
        }
        if (this.nlHelper == null) {
            return key;
        }
        if (key == null) {
            return "";
        }
        return this.nlHelper.getResourceString(key);
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    protected boolean isInSync(File localFile) {
        return localFile.exists() && localFile.lastModified() == this.getTimeStamp();
    }

    public boolean isValid() {
        return !this.isDisposed() && this.isLoaded();
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    protected abstract void updateTimeStamp();

    protected void updateTimeStamp(File localFile) {
        if (localFile.exists()) {
            this.timeStamp = localFile.lastModified();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void throwParseErrorsException(Throwable e) throws CoreException {
        Status status = new Status(4, PDECore.getPluginId(), 0, PDECoreMessages.Errors_modelError, e);
        throw new CoreException((IStatus)status);
    }

    protected SAXParser getSaxParser() throws ParserConfigurationException, SAXException, FactoryConfigurationError {
        return SAXParserFactory.newInstance().newSAXParser();
    }

    public boolean isReconcilingModel() {
        return false;
    }
}

