/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.AbstractStructureVisitor;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.util.Assert;

class AddStructureVisitor
extends AbstractStructureVisitor {
    public AddStructureVisitor(Session session, Command.LocalOption[] localOptions) {
        super(session, localOptions, false, true);
    }

    public void visitFile(ICVSFile mFile) throws CVSException {
        this.sendFolder(mFile.getParent());
        this.session.sendIsModified(mFile, true, this.monitor);
    }

    public void visitFolder(ICVSFolder mFolder) throws CVSException {
        Assert.isNotNull(mFolder);
        this.sendFolder(mFolder.getParent());
        String localPath = mFolder.getRelativePath(this.session.getLocalRoot());
        String remotePath = mFolder.getRemoteLocation(this.session.getLocalRoot());
        this.session.sendDirectory(localPath, remotePath);
        this.recordLastSent(mFolder);
    }
}

