/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.AbstractViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class BinaryCompareViewer
extends AbstractViewer {
    private static final String BUNDLE_NAME = "org.eclipse.compare.internal.BinaryCompareViewerResources";
    private static final int EOF = -1;
    private Label fControl;
    private ICompareInput fInput;
    private ResourceBundle fBundle;
    private boolean fLeftIsLocal;

    public BinaryCompareViewer(Composite parent, CompareConfiguration cc) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.compare.binary_compare_view_context");
        this.fBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        this.fControl = new Label(parent, 64);
        this.fControl.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Utilities.getString(this.fBundle, "title"));
        this.fLeftIsLocal = Utilities.getBoolean(cc, "LEFT_IS_LOCAL", false);
    }

    public Control getControl() {
        return this.fControl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInput(Object input) {
        block15: {
            if (this.fControl == null || !(input instanceof ICompareInput)) break block15;
            this.fInput = (ICompareInput)input;
            InputStream left = null;
            InputStream right = null;
            String message = null;
            try {
                block14: {
                    int pos;
                    block13: {
                        try {
                            left = this.getStream(this.fInput.getLeft());
                            right = this.getStream(this.fInput.getRight());
                            if (left != null && right != null) {
                                pos = 0;
                                break block13;
                            }
                            if (left == null && right == null) {
                                message = Utilities.getString(this.fBundle, "deleteConflictMessage");
                                break block14;
                            }
                            if (left == null) {
                                message = this.fLeftIsLocal ? Utilities.getString(this.fBundle, "deletedMessage") : Utilities.getString(this.fBundle, "addedMessage");
                                break block14;
                            }
                            if (right != null) break block14;
                            if (this.fLeftIsLocal) {
                                message = Utilities.getString(this.fBundle, "addedMessage");
                                break block14;
                            }
                            message = Utilities.getString(this.fBundle, "deletedMessage");
                        }
                        catch (CoreException coreException) {
                            message = Utilities.getString(this.fBundle, "errorMessage");
                        }
                        catch (IOException iOException) {
                            message = Utilities.getString(this.fBundle, "errorMessage");
                        }
                        break block14;
                    }
                    while (true) {
                        int r;
                        int l;
                        if ((l = left.read()) != (r = right.read())) {
                            String format = Utilities.getString(this.fBundle, "diffMessageFormat");
                            message = MessageFormat.format(format, Integer.toString(pos));
                            break;
                        }
                        if (l == -1) break;
                        ++pos;
                    }
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                Utilities.close(left);
                Utilities.close(right);
                throw throwable;
            }
            Utilities.close(left);
            Utilities.close(right);
            if (message != null) {
                this.fControl.setText(message);
            }
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    private InputStream getStream(ITypedElement input) throws CoreException {
        if (input instanceof IStreamContentAccessor) {
            return ((IStreamContentAccessor)((Object)input)).getContents();
        }
        return null;
    }
}

