/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jst.j2ee.internal.common.operations.BinaryConstructor;
import org.eclipse.jst.j2ee.internal.common.operations.BinaryMethod;
import org.eclipse.jst.j2ee.internal.common.operations.Constructor;
import org.eclipse.jst.j2ee.internal.common.operations.ImportsCollection;
import org.eclipse.jst.j2ee.internal.common.operations.Method;
import org.eclipse.jst.j2ee.internal.common.operations.SourceConstructor;
import org.eclipse.jst.j2ee.internal.common.operations.SourceMethod;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJavaEEArtifactTemplateModel {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_QUALIFIED_SUPERCLASS_NAME = 1;
    public static final int FLAG_ALL = -1;
    protected int flags;
    protected IDataModel dataModel;

    public CreateJavaEEArtifactTemplateModel(IDataModel dataModel) {
        this.dataModel = dataModel;
        this.flags = 1;
    }

    public void addFlags(int bitmask) {
        this.flags |= bitmask;
    }

    public void removeFlags(int bitmask) {
        this.flags &= ~bitmask;
    }

    public boolean areFlagsSet(int bitmask) {
        return (this.flags & bitmask) != 0;
    }

    public Collection<String> getImports() {
        List<String> interfaces;
        ImportsCollection collection = new ImportsCollection(this);
        String className = this.getClassName();
        String superclassName = this.getQualifiedSuperclassName();
        if (superclassName != null && superclassName.length() > 0 && !this.areFlagsSet(1) && !this.equalSimpleNames(className, superclassName)) {
            collection.add(superclassName);
        }
        if ((interfaces = this.getQualifiedInterfaces()) != null) {
            for (String iface : interfaces) {
                if (this.equalSimpleNames(this.getClassName(), iface)) continue;
                collection.add(iface);
            }
        }
        List<Constructor> constructors = this.getConstructors();
        for (Constructor constructor : constructors) {
            List<String> types = constructor.getNonPrimitiveParameterTypes();
            for (String type : types) {
                collection.add(type);
            }
        }
        Collection<Method> methods = this.getUnimplementedMethods();
        for (Method method : methods) {
            collection.addAll(method.getParameterImports());
            collection.addAll(method.getReturnTypeImports());
        }
        return collection;
    }

    public String getClassName() {
        return this.getProperty("NewJavaClassDataModel.CLASS_NAME").trim();
    }

    public String getJavaPackageName() {
        return this.getProperty("NewJavaClassDataModel.JAVA_PACKAGE").trim();
    }

    public String getQualifiedJavaClassName() {
        return String.valueOf(this.getJavaPackageName()) + "." + this.getClassName();
    }

    public String getSuperclassName() {
        String qualified = this.getQualifiedSuperclassName();
        if (this.areFlagsSet(1) || this.equalSimpleNames(this.getClassName(), qualified)) {
            return qualified;
        }
        return Signature.getSimpleName((String)qualified);
    }

    public String getQualifiedSuperclassName() {
        return this.getProperty("NewJavaClassDataModel.SUPERCLASS").trim();
    }

    public List<String> getInterfaces() {
        List<String> qualifiedInterfaces = this.getQualifiedInterfaces();
        ArrayList<String> interfaces = new ArrayList<String>(qualifiedInterfaces.size());
        for (String qualified : qualifiedInterfaces) {
            if (this.equalSimpleNames(this.getClassName(), qualified)) {
                interfaces.add(qualified);
                continue;
            }
            interfaces.add(Signature.getSimpleName((String)qualified));
        }
        return interfaces;
    }

    public List<String> getQualifiedInterfaces() {
        List interfaces = (List)this.dataModel.getProperty("NewJavaClassDataModel.INTERFACES");
        return interfaces == null ? new ArrayList() : interfaces;
    }

    public boolean isPublic() {
        return this.dataModel.getBooleanProperty("NewJavaClassDataModel.MODIFIER_PUBLIC");
    }

    public boolean isFinal() {
        return this.dataModel.getBooleanProperty("NewJavaClassDataModel.MODIFIER_FINAL");
    }

    public boolean isAbstract() {
        return this.dataModel.getBooleanProperty("NewJavaClassDataModel.MODIFIER_ABSTRACT");
    }

    public boolean shouldGenSuperclassConstructors() {
        return this.dataModel.getBooleanProperty("NewJavaClassDataModel.CONSTRUCTOR");
    }

    public boolean shouldImplementAbstractMethods() {
        return this.dataModel.getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS");
    }

    public boolean hasEmptySuperclassConstructor() {
        List<Constructor> constructors = this.getConstructors();
        for (Constructor constructor : constructors) {
            if (!constructor.isParameterless()) continue;
            return true;
        }
        return false;
    }

    public List<Constructor> getConstructors() {
        IProject p;
        IJavaProject javaProject;
        ArrayList<Constructor> constrs = new ArrayList<Constructor>();
        String superclass = this.dataModel.getStringProperty("NewJavaClassDataModel.SUPERCLASS");
        if (superclass != null && superclass.length() > 0 && (javaProject = JavaCore.create((IProject)(p = (IProject)this.dataModel.getProperty("NewJavaClassDataModel.PROJECT")))) != null) {
            try {
                IType type = javaProject.findType(superclass);
                if (type != null) {
                    if (type.isBinary()) {
                        IMethod[] methods;
                        IMethod[] iMethodArray = methods = type.getMethods();
                        int n = methods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethod method = iMethodArray[n2];
                            if (method.isConstructor()) {
                                constrs.add(new BinaryConstructor(method));
                            }
                            ++n2;
                        }
                    } else {
                        ICompilationUnit compilationUnit = type.getCompilationUnit();
                        TypeDeclaration declarationFromType = this.getTypeDeclarationFromType(superclass, compilationUnit);
                        if (declarationFromType != null) {
                            MethodDeclaration[] methods;
                            MethodDeclaration[] methodDeclarationArray = methods = declarationFromType.getMethods();
                            int n = methods.length;
                            int n3 = 0;
                            while (n3 < n) {
                                MethodDeclaration method = methodDeclarationArray[n3];
                                if (method.isConstructor()) {
                                    constrs.add(new SourceConstructor(method));
                                }
                                ++n3;
                            }
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                J2EEPlugin.logError((CoreException)((Object)e));
            }
        }
        return constrs;
    }

    public Collection<Method> getUnimplementedMethods() {
        HashSet<Method> unimplementedMethods = new HashSet<Method>();
        if (this.shouldImplementAbstractMethods()) {
            IJavaProject javaProject = this.getJavaProject();
            List<String> interfaces = this.getQualifiedInterfaces();
            for (String iface : interfaces) {
                try {
                    IType type = javaProject.findType(iface);
                    if (type == null) continue;
                    this.getUnimplementedMethod0(type, unimplementedMethods);
                }
                catch (JavaModelException e) {
                    J2EEPlugin.logError((CoreException)((Object)e));
                }
            }
        }
        return unimplementedMethods;
    }

    private void getUnimplementedMethod0(IType type, Collection<Method> unimplementedMethods) throws JavaModelException {
        IJavaProject javaProject = this.getJavaProject();
        if (type.isBinary()) {
            String[] superInterfaces;
            IMethod[] methods;
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                unimplementedMethods.add(new BinaryMethod(method));
                ++n2;
            }
            String[] stringArray = superInterfaces = type.getSuperInterfaceNames();
            int n3 = superInterfaces.length;
            n = 0;
            while (n < n3) {
                String superInterface = stringArray[n];
                IType superInterfaceType = javaProject.findType(superInterface);
                if (superInterfaceType != null) {
                    this.getUnimplementedMethod0(superInterfaceType, unimplementedMethods);
                }
                ++n;
            }
        } else {
            IType superInterfaceType;
            ICompilationUnit compilationUnit = type.getCompilationUnit();
            TypeDeclaration declarationFromType = this.getTypeDeclarationFromType(type.getFullyQualifiedName(), compilationUnit);
            if (declarationFromType != null) {
                IType methods;
                superInterfaceType = methods = declarationFromType.getMethods();
                int n = ((MethodDeclaration[])superInterfaceType).length;
                int n4 = 0;
                while (n4 < n) {
                    MethodDeclaration method = superInterfaceType[n4];
                    unimplementedMethods.add(new SourceMethod(method));
                    ++n4;
                }
            }
            List superInterfaces = declarationFromType.superInterfaceTypes();
            for (Type superInterface : superInterfaces) {
                ITypeBinding binding = superInterface.resolveBinding();
                superInterfaceType = javaProject.findType(binding.getQualifiedName());
                if (superInterfaceType == null) continue;
                this.getUnimplementedMethod0(superInterfaceType, unimplementedMethods);
            }
        }
    }

    protected String getProperty(String propertyName) {
        return this.dataModel.getStringProperty(propertyName);
    }

    protected boolean equalSimpleNames(String name1, String name2) {
        String simpleName1 = Signature.getSimpleName((String)name1);
        String simpleName2 = Signature.getSimpleName((String)name2);
        return simpleName1.equals(simpleName2);
    }

    protected IJavaProject getJavaProject() {
        IProject p = (IProject)this.dataModel.getProperty("NewJavaClassDataModel.PROJECT");
        return JavaCore.create((IProject)p);
    }

    private TypeDeclaration getTypeDeclarationFromType(String typeName, ICompilationUnit unit) {
        CompilationUnit cu = (CompilationUnit)this.parse(unit);
        for (Object obj : cu.types()) {
            String declarationName;
            TypeDeclaration declaration;
            ITypeBinding tb;
            if (!(obj instanceof TypeDeclaration) || (tb = (declaration = (TypeDeclaration)obj).resolveBinding()) == null || !typeName.equals(declarationName = tb.getQualifiedName())) continue;
            return declaration;
        }
        return null;
    }

    private ASTNode parse(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(8);
        parser.setSource(unit);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        return parser.createAST(null);
    }
}

