/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class TableOfContentsBlock
extends Block {
    static final Pattern startPattern = Pattern.compile("\\s*\\{toc(?::([^\\}]+))?\\}\\s*");
    private int blockLineNumber = 0;
    private String style = "none";
    private int maxLevel = Integer.MAX_VALUE;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        if (this.blockLineNumber++ > 0) {
            this.setClosed(true);
            return 0;
        }
        if (!this.getMarkupLanguage().isFilterGenerativeContents()) {
            String options = this.matcher.group(1);
            if (options != null) {
                String[] optionPairs;
                String[] stringArray = optionPairs = options.split("\\s*\\|\\s*");
                int n = optionPairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String optionPair = stringArray[n2];
                    String[] keyValue = optionPair.split("\\s*=\\s*");
                    if (keyValue.length == 2) {
                        String key = keyValue[0].trim();
                        String value = keyValue[1].trim();
                        if (key.equals("style")) {
                            this.setStyle(value);
                        } else if (key.equals("maxLevel")) {
                            try {
                                this.maxLevel = Integer.parseInt(value);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                    ++n2;
                }
            }
            OutlineParser outlineParser = new OutlineParser((MarkupLanguage)new TextileLanguage());
            OutlineItem rootItem = outlineParser.parse(this.state.getMarkupContent());
            this.emitToc(rootItem);
        }
        return -1;
    }

    private void emitToc(OutlineItem item) {
        if (item.getChildren().isEmpty()) {
            return;
        }
        if (item.getLevel() + 1 > this.maxLevel) {
            return;
        }
        Attributes nullAttributes = new Attributes();
        this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, new Attributes(null, null, "list-style: " + this.style + ";", null));
        for (OutlineItem child : item.getChildren()) {
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, nullAttributes);
            this.builder.link(String.valueOf('#') + child.getId(), child.getLabel());
            this.emitToc(child);
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0 && !this.getMarkupLanguage().isFilterGenerativeContents()) {
            this.matcher = startPattern.matcher(line);
            this.blockLineNumber = 0;
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }
}

