/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeParameter;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalFunctionBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class MethodScope
extends BlockScope {
    public ReferenceContext referenceContext;
    public boolean isStatic;
    public boolean isConstructorCall = false;
    public FieldBinding initializedField;
    public int lastVisibleFieldID = -1;
    public int analysisIndex;
    public boolean isPropagatingInnerClassEmulation;
    public int lastIndex = 0;
    public long[] definiteInits = new long[4];
    public long[][] extraDefiniteInits = new long[4][];
    public boolean insideTypeAnnotation = false;
    public SyntheticArgumentBinding[] extraSyntheticArguments;
    public static final char[] ARGUMENTS_NAME = new char[]{'a', 'r', 'g', 'u', 'm', 'e', 'n', 't', 's'};
    LocalVariableBinding argumentsBinding;

    public MethodScope(Scope parent, ReferenceContext context, boolean isStatic) {
        super(2, parent);
        this.locals = new LocalVariableBinding[5];
        this.referenceContext = context;
        this.isStatic = isStatic;
        this.startIndex = 0;
        this.argumentsBinding = new LocalVariableBinding(ARGUMENTS_NAME, (TypeBinding)TypeBinding.UNKNOWN, 0, true);
        this.argumentsBinding.declaringScope = this;
    }

    private void checkAndSetModifiersForConstructor(MethodBinding methodBinding) {
        int flags;
        int modifiers = methodBinding.modifiers;
        ReferenceBinding declaringClass = methodBinding.declaringClass;
        if ((modifiers & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForMethod(declaringClass, (AbstractMethodDeclaration)this.referenceContext);
        }
        if ((methodBinding.modifiers & 0x4000000) > 0 && (flags = declaringClass.modifiers & 0x4005) != 0) {
            if ((flags & 0x4000) != 0) {
                modifiers &= 0xFFFFFFF8;
                modifiers |= 2;
            } else {
                modifiers &= 0xFFFFFFF8;
                modifiers |= flags;
            }
        }
        int realModifiers = modifiers & 0xFFFF;
        if (declaringClass.isEnum() && !((ConstructorDeclaration)this.referenceContext).isDefaultConstructor) {
            if ((((AbstractMethodDeclaration)this.referenceContext).modifiers & 0x800) != 0) {
                this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
            }
            modifiers |= 2;
        } else if ((realModifiers & 0xFFFFF7F0) != 0) {
            this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
            modifiers &= 0xFFFF080F;
        } else if ((((AbstractMethodDeclaration)this.referenceContext).modifiers & 0x800) != 0) {
            this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
        }
        int accessorBits = realModifiers & 7;
        if ((accessorBits & accessorBits - 1) != 0) {
            this.problemReporter().illegalVisibilityModifierCombinationForMethod(declaringClass, (AbstractMethodDeclaration)this.referenceContext);
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers &= 0xFFFFFFFB;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers &= 0xFFFFFFFD;
                }
            } else if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers &= 0xFFFFFFFD;
            }
        }
        methodBinding.modifiers = modifiers;
    }

    private void checkAndSetModifiersForMethod(MethodBinding methodBinding) {
        int accessorBits;
        int realModifiers;
        int modifiers = methodBinding.modifiers;
        ReferenceBinding declaringClass = methodBinding.declaringClass;
        if ((modifiers & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForMethod(declaringClass, (AbstractMethodDeclaration)this.referenceContext);
        }
        if (((realModifiers = modifiers & 0xFFFF) & 0xFFFFF2C0) != 0) {
            this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
            modifiers &= 0xFFFF0D3F;
        }
        if (((accessorBits = realModifiers & 7) & accessorBits - 1) != 0) {
            this.problemReporter().illegalVisibilityModifierCombinationForMethod(declaringClass, (AbstractMethodDeclaration)this.referenceContext);
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers &= 0xFFFFFFFB;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers &= 0xFFFFFFFD;
                }
            } else if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers &= 0xFFFFFFFD;
            }
        }
        if ((modifiers & 0x400) != 0) {
            int incompatibleWithAbstract = 2362;
            if ((modifiers & incompatibleWithAbstract) != 0) {
                this.problemReporter().illegalAbstractModifierCombinationForMethod(declaringClass, (AbstractMethodDeclaration)this.referenceContext);
            }
            if (!methodBinding.declaringClass.isAbstract()) {
                this.problemReporter().abstractMethodInAbstractClass((SourceTypeBinding)declaringClass, (AbstractMethodDeclaration)this.referenceContext);
            }
        }
        if ((modifiers & 0x100) != 0 && (modifiers & 0x800) != 0) {
            this.problemReporter().nativeMethodsCannotBeStrictfp(declaringClass, (AbstractMethodDeclaration)this.referenceContext);
        }
        methodBinding.modifiers = modifiers;
    }

    MethodBinding createMethod(InferredMethod inferredMethod, SourceTypeBinding declaringClass) {
        boolean isConstructor = inferredMethod.isConstructor;
        if (isConstructor && declaringClass != inferredMethod.inType.binding) {
            isConstructor = false;
        }
        MethodBinding binding = this.createMethod((AbstractMethodDeclaration)((Object)inferredMethod.getFunctionDeclaration()), inferredMethod.name, declaringClass, isConstructor, false);
        if (inferredMethod.isConstructor || declaringClass != inferredMethod.inType.binding) {
            binding.allocationType = inferredMethod.inType.binding;
        }
        return binding;
    }

    public MethodBinding createMethod(AbstractMethodDeclaration method, char[] name, SourceTypeBinding declaringClass, boolean isConstructor, boolean isLocal) {
        TypeParameter[] typeParameters;
        int argLength;
        MethodBinding methodBinding = null;
        this.referenceContext = method;
        method.scope = this;
        int modifiers = method.modifiers | 0x2000000;
        if ((method.modifiers & 6) == 0) {
            modifiers |= 1;
        }
        if (method.inferredMethod != null && method.inferredMethod.isStatic) {
            modifiers |= 8;
        }
        if (method.isConstructor() || isConstructor) {
            if (method.isDefaultConstructor() || isConstructor) {
                modifiers |= 0x4000000;
            }
            methodBinding = new MethodBinding(modifiers, null, null, declaringClass);
            this.checkAndSetModifiersForConstructor(methodBinding);
        } else {
            TypeBinding returnType;
            TypeBinding typeBinding = returnType = method.inferredType != null ? method.inferredType.resolveType(this, method) : TypeBinding.UNKNOWN;
            if (method.inferredType == null && method.inferredMethod != null && method.inferredMethod.isConstructor && method.inferredMethod.inType != null) {
                returnType = method.inferredMethod.inType.resolveType(this, method);
            }
            if (returnType == null) {
                returnType = TypeBinding.UNKNOWN;
            }
            methodBinding = isLocal && method.selector != null ? new LocalFunctionBinding(modifiers, name, returnType, null, null, declaringClass) : new MethodBinding(modifiers, name, returnType, null, null, declaringClass);
            if (method.inferredMethod != null) {
                methodBinding.tagBits |= 0x80000000000000L;
                if ((method.bits & 0x4000) != 0) {
                    methodBinding.tagBits |= 0x40000000000000L;
                }
            }
            methodBinding.createFunctionTypeBinding(this);
            if (method.inferredMethod != null && method.inferredMethod.isConstructor) {
                methodBinding.tagBits |= 0x20000000000000L;
            }
            this.checkAndSetModifiersForMethod(methodBinding);
        }
        this.isStatic = methodBinding.isStatic();
        Argument[] argTypes = method.arguments;
        int n = argLength = argTypes == null ? 0 : argTypes.length;
        if (argLength > 0 && this.compilerOptions().sourceLevel >= 0x310000L) {
            if (argTypes[--argLength].isVarArgs()) {
                methodBinding.modifiers |= 0x80;
            }
            while (--argLength >= 0) {
                if (!argTypes[argLength].isVarArgs()) continue;
                this.problemReporter().illegalVararg(argTypes[argLength], method);
            }
        }
        if ((typeParameters = method.typeParameters()) == null || this.compilerOptions().sourceLevel < 0x310000L) {
            methodBinding.typeVariables = Binding.NO_TYPE_VARIABLES;
        } else {
            methodBinding.typeVariables = this.createTypeVariables(typeParameters, methodBinding);
            methodBinding.modifiers |= 0x40000000;
        }
        return methodBinding;
    }

    public FieldBinding findField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite, boolean needResolve) {
        FieldBinding field = super.findField(receiverType, fieldName, invocationSite, needResolve);
        if (field == null) {
            return null;
        }
        if (!field.isValidBinding()) {
            return field;
        }
        if (field.isStatic()) {
            return field;
        }
        if (!this.isConstructorCall || receiverType != this.enclosingSourceType()) {
            return field;
        }
        if (invocationSite instanceof SingleNameReference) {
            return new ProblemFieldBinding(field, field.declaringClass, fieldName, 6);
        }
        if (invocationSite instanceof QualifiedNameReference) {
            QualifiedNameReference name = (QualifiedNameReference)invocationSite;
            if (name.binding == null) {
                return new ProblemFieldBinding(field, field.declaringClass, fieldName, 6);
            }
        }
        return field;
    }

    public boolean isInsideConstructor() {
        return this.referenceContext instanceof ConstructorDeclaration;
    }

    public boolean isInsideInitializer() {
        return this.referenceContext instanceof TypeDeclaration;
    }

    public boolean isInsideInitializerOrConstructor() {
        return this.referenceContext instanceof TypeDeclaration || this.referenceContext instanceof ConstructorDeclaration;
    }

    public ProblemReporter problemReporter() {
        MethodScope outerMethodScope = this.outerMostMethodScope();
        if (outerMethodScope == this) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return outerMethodScope.problemReporter();
    }

    public final int recordInitializationStates(FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return -1;
        }
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.unconditionalInitsWithoutSideEffect();
        long[] extraInits = unconditionalFlowInfo.extra == null ? null : unconditionalFlowInfo.extra[0];
        long inits = unconditionalFlowInfo.definiteInits;
        int i = this.lastIndex;
        block0: while (--i >= 0) {
            if (this.definiteInits[i] != inits) continue;
            long[] otherInits = this.extraDefiniteInits[i];
            if (extraInits != null && otherInits != null) {
                if (extraInits.length != otherInits.length) continue;
                int j = 0;
                int max = extraInits.length;
                while (j < max) {
                    if (extraInits[j] != otherInits[j]) continue block0;
                    ++j;
                }
                return i;
            }
            if (extraInits != null || otherInits != null) continue;
            return i;
        }
        if (this.definiteInits.length == this.lastIndex) {
            this.definiteInits = new long[this.lastIndex + 20];
            System.arraycopy(this.definiteInits, 0, this.definiteInits, 0, this.lastIndex);
            long[][] lArrayArray = new long[this.lastIndex + 20][];
            this.extraDefiniteInits = lArrayArray;
            System.arraycopy(this.extraDefiniteInits, 0, lArrayArray, 0, this.lastIndex);
        }
        this.definiteInits[this.lastIndex] = inits;
        if (extraInits != null) {
            this.extraDefiniteInits[this.lastIndex] = new long[extraInits.length];
            System.arraycopy(extraInits, 0, this.extraDefiniteInits[this.lastIndex], 0, extraInits.length);
        }
        return this.lastIndex++;
    }

    public AbstractMethodDeclaration referenceMethod() {
        if (this.referenceContext instanceof AbstractMethodDeclaration) {
            return (AbstractMethodDeclaration)this.referenceContext;
        }
        return null;
    }

    public TypeDeclaration referenceType() {
        if (this.parent instanceof ClassScope) {
            return ((ClassScope)this.parent).referenceContext;
        }
        return null;
    }

    String basicToString(int tab) {
        String newLine = "\n";
        int i = tab;
        while (--i >= 0) {
            newLine = String.valueOf(newLine) + "\t";
        }
        String s = String.valueOf(newLine) + "--- Method Scope ---";
        newLine = String.valueOf(newLine) + "\t";
        s = String.valueOf(s) + newLine + "locals:";
        int i2 = 0;
        while (i2 < this.localIndex) {
            s = String.valueOf(s) + newLine + "\t" + this.locals[i2].toString();
            ++i2;
        }
        s = String.valueOf(s) + newLine + "startIndex = " + this.startIndex;
        s = String.valueOf(s) + newLine + "isConstructorCall = " + this.isConstructorCall;
        s = String.valueOf(s) + newLine + "initializedField = " + this.initializedField;
        s = String.valueOf(s) + newLine + "lastVisibleFieldID = " + this.lastVisibleFieldID;
        s = String.valueOf(s) + newLine + "referenceContext = " + this.referenceContext;
        return s;
    }

    public LocalVariableBinding findVariable(char[] variableName) {
        LocalVariableBinding binding = super.findVariable(variableName);
        if (binding == null && CharOperation.equals(variableName, ARGUMENTS_NAME)) {
            binding = this.argumentsBinding;
        }
        return binding;
    }
}

