/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.api.ui.compile;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.useractions.UserActionsResources;
import org.eclipse.rse.internal.useractions.api.ui.compile.SystemWorkWithCompileCommandsAction;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCascadeByProfileAction;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.actions.SystemBaseSubMenuAction;
import org.eclipse.swt.widgets.Shell;

public class SystemCascadingCompileAction
extends SystemBaseSubMenuAction
implements IMenuListener {
    private boolean isPrompt;

    public SystemCascadingCompileAction(Shell shell, boolean isPrompt) {
        super(isPrompt ? UserActionsResources.ACTION_COMPILE_PROMPT_LABEL : UserActionsResources.ACTION_COMPILE_NOPROMPT_LABEL, isPrompt ? UserActionsResources.ACTION_COMPILE_PROMPT_TOOLTIP : UserActionsResources.ACTION_COMPILE_NOPROMPT_TOOLTIP, null, shell);
        this.isPrompt = isPrompt;
        this.allowOnMultipleSelection(false);
        this.setMenuID("menu.compile");
        this.setCreateMenuEachTime(false);
        this.setPopulateMenuEachTime(true);
        if (isPrompt) {
            this.setHelp("org.eclipse.rse.ui.ccpa0000");
        } else {
            this.setHelp("org.eclipse.rse.ui.ccna0000");
        }
    }

    public IMenuManager populateSubMenu(IMenuManager ourSubMenu) {
        ourSubMenu.addMenuListener((IMenuListener)this);
        ourSubMenu.setRemoveAllWhenShown(true);
        ourSubMenu.add((IAction)new SystemBaseAction("dummy", null));
        return ourSubMenu;
    }

    public void menuAboutToShow(IMenuManager ourSubMenu) {
        Object firstSelection = this.getFirstSelection();
        if (firstSelection == null) {
            System.out.println("Hmm, selection is null! ");
            ourSubMenu.add((IAction)new SystemBaseAction("Programming error. Selection is null! ", null));
            return;
        }
        if (SystemPreferencesManager.getCascadeUserActions()) {
            ISystemProfile[] activeProfiles = RSECorePlugin.getTheSystemRegistry().getActiveSystemProfiles();
            int idx = 0;
            while (idx < activeProfiles.length) {
                SystemCompileCascadeByProfileAction profileAction = new SystemCompileCascadeByProfileAction(this.getShell(), firstSelection, activeProfiles[idx], this.isPrompt);
                ourSubMenu.add((IContributionItem)profileAction.getSubMenu());
                ++idx;
            }
        } else {
            ISystemProfile[] activeProfiles = RSECorePlugin.getTheSystemRegistry().getActiveSystemProfiles();
            int idx = 0;
            while (idx < activeProfiles.length) {
                SystemCompileCascadeByProfileAction.populateMenuWithCompileActions(ourSubMenu, this.getShell(), activeProfiles[idx], firstSelection, this.isPrompt);
                ++idx;
            }
        }
        ourSubMenu.add((IContributionItem)new Separator());
        ourSubMenu.add((IAction)new SystemWorkWithCompileCommandsAction(this.getShell(), true));
    }
}

