/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskHyperlinkPresenter
extends DefaultHyperlinkPresenter {
    private IRegion activeRegion;
    private ITask currentTaskHyperlink;
    private ITextViewer textViewer;
    private IHyperlinkPresenter multiplePresenter;

    public TaskHyperlinkPresenter(IPreferenceStore store) {
        super(store);
        this.initMultipleHyperlinkSupport(IPreferenceStore.class, store);
    }

    public TaskHyperlinkPresenter(RGB color) {
        super(color);
        this.initMultipleHyperlinkSupport(RGB.class, color);
    }

    public boolean canShowMultipleHyperlinks() {
        return this.multiplePresenter != null;
    }

    private <T> void initMultipleHyperlinkSupport(Class<T> argClass, T arg) {
        try {
            Class<?> clazz = Class.forName("org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter");
            Constructor<?> constructor = clazz.getDeclaredConstructor(argClass);
            this.multiplePresenter = (IHyperlinkPresenter)constructor.newInstance(arg);
        }
        catch (Throwable throwable) {}
    }

    public void install(ITextViewer textViewer) {
        this.textViewer = textViewer;
        super.install(textViewer);
        if (this.multiplePresenter != null) {
            this.multiplePresenter.install(textViewer);
        }
    }

    public void uninstall() {
        this.hideHyperlinks();
        this.textViewer = null;
        super.uninstall();
        if (this.multiplePresenter != null) {
            this.multiplePresenter.uninstall();
        }
    }

    public void applyTextPresentation(TextPresentation textPresentation) {
        super.applyTextPresentation(textPresentation);
        if (this.activeRegion != null && this.currentTaskHyperlink != null && this.currentTaskHyperlink.isCompleted()) {
            Iterator styleRangeIterator = textPresentation.getAllStyleRangeIterator();
            while (styleRangeIterator.hasNext()) {
                StyleRange styleRange = (StyleRange)styleRangeIterator.next();
                if (this.activeRegion.getOffset() != styleRange.start || this.activeRegion.getLength() != styleRange.length) continue;
                styleRange.strikeout = true;
                break;
            }
        }
    }

    public void showHyperlinks(IHyperlink[] hyperlinks) {
        if (hyperlinks.length > 1 && this.multiplePresenter != null) {
            this.multiplePresenter.showHyperlinks(hyperlinks);
        } else {
            this.activeRegion = null;
            if (hyperlinks.length > 0 && hyperlinks[0] instanceof TaskHyperlink) {
                String repositoryUrl;
                TaskHyperlink hyperlink = (TaskHyperlink)hyperlinks[0];
                TaskList taskList = TasksUiPlugin.getTaskList();
                ITask task = taskList.getTask(repositoryUrl = hyperlink.getRepository().getRepositoryUrl(), hyperlink.getTaskId());
                if (task == null) {
                    task = taskList.getTaskByKey(repositoryUrl, hyperlink.getTaskId());
                }
                if (task != null && task != this.currentTaskHyperlink) {
                    this.currentTaskHyperlink = task;
                    this.activeRegion = hyperlink.getHyperlinkRegion();
                    if (this.textViewer != null && this.textViewer.getTextWidget() != null && !this.textViewer.getTextWidget().isDisposed()) {
                        if (task.getTaskKey() == null) {
                            this.textViewer.getTextWidget().setToolTipText(task.getSummary());
                        } else {
                            this.textViewer.getTextWidget().setToolTipText(String.valueOf(task.getTaskKey()) + ": " + task.getSummary());
                        }
                    }
                }
            }
            super.showHyperlinks(hyperlinks);
        }
    }

    public void hideHyperlinks() {
        if (this.currentTaskHyperlink != null) {
            if (this.textViewer != null && this.textViewer.getTextWidget() != null && !this.textViewer.getTextWidget().isDisposed()) {
                this.textViewer.getTextWidget().setToolTipText(null);
            }
            this.currentTaskHyperlink = null;
        }
        if (this.multiplePresenter != null) {
            this.multiplePresenter.hideHyperlinks();
        }
        super.hideHyperlinks();
    }
}

