/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.commons.core.ZipFileUtil;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataExportOperation
implements IRunnableWithProgress {
    private static final String EXPORT_JOB_LABEL = Messages.TaskDataExportOperation_exporting_task_data;
    private static final Pattern excludeHidden = Pattern.compile("^\\.");
    private static final Pattern excludeBackup = Pattern.compile("backup\\z");
    private final String destinationDirectory;
    private final String destinationFilename;

    public TaskDataExportOperation(String destinationDirectory, String destinationFilename) {
        this.destinationFilename = destinationFilename;
        this.destinationDirectory = destinationDirectory;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        HashSet<File> filesToExport = new HashSet<File>();
        this.selectFiles(filesToExport);
        if (filesToExport.size() > 0 && Platform.isRunning()) {
            try {
                try {
                    monitor.beginTask(EXPORT_JOB_LABEL, filesToExport.size() + 1);
                    Job.getJobManager().beginRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    File destZipFile = new File(String.valueOf(this.destinationDirectory) + File.separator + this.destinationFilename);
                    if (destZipFile.exists()) {
                        destZipFile.delete();
                    }
                    ZipFileUtil.createZipFile((File)destZipFile, new ArrayList<File>(filesToExport), (String)TasksUiPlugin.getDefault().getDataDirectory(), (IProgressMonitor)monitor);
                }
                catch (Exception e) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not perform export", (Throwable)e));
                    Job.getJobManager().endRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE);
                    monitor.done();
                }
            }
            finally {
                Job.getJobManager().endRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE);
                monitor.done();
            }
        }
    }

    protected void selectFiles(Set<File> filesToExport) {
        HashSet<Pattern> exclusionPatterns = new HashSet<Pattern>();
        exclusionPatterns.add(excludeHidden);
        exclusionPatterns.add(excludeBackup);
        String dataRoot = TasksUiPlugin.getDefault().getDataDirectory();
        File dataFolder = new File(dataRoot);
        File[] fileArray = dataFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            boolean exclude = false;
            for (Pattern pattern : exclusionPatterns) {
                if (!pattern.matcher(file.getName()).find()) continue;
                exclude = true;
                break;
            }
            if (!exclude) {
                filesToExport.add(file);
            }
            ++n2;
        }
    }

    protected File getSourceFolder() {
        return new File(TasksUiPlugin.getDefault().getDataDirectory());
    }
}

