/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.progress.IProgressService;

public class NewSubTaskAction
extends BaseSelectionListenerAction
implements IViewActionDelegate,
IExecutableExtension {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.new.subtask";
    private AbstractTask selectedTask;

    public NewSubTaskAction() {
        super(Messages.NewSubTaskAction_Subtask);
        this.setToolTipText(Messages.NewSubTaskAction_Create_a_new_subtask);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_NEW_SUB);
    }

    public void run() {
        if (this.selectedTask == null) {
            return;
        }
        if (this.selectedTask instanceof LocalTask) {
            TaskList taskList = TasksUiPlugin.getTaskList();
            LocalTask newTask = new LocalTask("" + taskList.getNextLocalTaskId(), LocalRepositoryConnector.DEFAULT_SUMMARY);
            newTask.setPriority(ITask.PriorityLevel.P3.toString());
            TasksUiPlugin.getTaskActivityManager().scheduleNewTask((AbstractTask)newTask);
            taskList.addTask((ITask)newTask, (AbstractTaskContainer)this.selectedTask);
            TasksUiUtil.openTask((ITask)newTask);
            return;
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.selectedTask.getConnectorKind());
        TaskData taskData = this.createTaskData(connector);
        if (taskData != null) {
            try {
                TasksUiInternal.createAndOpenNewTask(taskData);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to open new sub task", (Throwable)e));
                TasksUiInternal.displayStatus(Messages.NewSubTaskAction_Unable_to_create_subtask, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", String.valueOf(Messages.NewSubTaskAction_Failed_to_create_new_sub_task_) + e.getMessage()));
            }
        }
    }

    private TaskData createTaskData(AbstractRepositoryConnector connector) {
        final AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        if (taskDataHandler == null) {
            return null;
        }
        String repositoryUrl = this.selectedTask.getRepositoryUrl();
        TaskData parentTaskData = null;
        try {
            parentTaskData = TasksUi.getTaskDataManager().getTaskData((ITask)this.selectedTask);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not retrieve task data for task:" + this.selectedTask.getUrl(), (Throwable)e));
        }
        if (parentTaskData == null) {
            TasksUiInternal.displayStatus(Messages.NewSubTaskAction_Unable_to_create_subtask, (IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", String.valueOf(Messages.NewSubTaskAction_Could_not_retrieve_task_data_for_task_) + this.selectedTask.getUrl()));
            return null;
        }
        final TaskRepository taskRepository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl);
        if (!taskDataHandler.canInitializeSubTaskData(taskRepository, (ITask)this.selectedTask)) {
            return null;
        }
        final TaskData selectedTaskData = parentTaskData;
        TaskAttributeMapper attributeMapper = taskDataHandler.getAttributeMapper(taskRepository);
        final TaskData taskData = new TaskData(attributeMapper, taskRepository.getConnectorKind(), taskRepository.getRepositoryUrl(), "");
        final boolean[] result = new boolean[1];
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = taskDataHandler.initializeSubTaskData(taskRepository, taskData, selectedTaskData, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                TasksUiInternal.displayStatus(Messages.NewSubTaskAction_Unable_to_create_subtask, ((CoreException)e.getCause()).getStatus());
            } else {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", String.valueOf(Messages.NewSubTaskAction_Could_not_initialize_sub_task_data_for_task_) + this.selectedTask.getUrl(), (Throwable)e));
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if (result[0]) {
            return taskData;
        }
        TasksUiInternal.displayStatus(Messages.NewSubTaskAction_Unable_to_create_subtask, (IStatus)new Status(1, "org.eclipse.mylyn.tasks.ui", Messages.NewSubTaskAction_The_connector_does_not_support_creating_subtasks_for_this_task));
        return null;
    }

    public void run(IAction action) {
        this.run();
    }

    public void init(IViewPart view) {
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selectedTask = null;
        if (selection.size() == 1) {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject instanceof LocalTask) {
                this.selectedTask = (AbstractTask)selectedObject;
            } else if (selectedObject instanceof ITask) {
                this.selectedTask = (AbstractTask)selectedObject;
                AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.selectedTask.getConnectorKind());
                AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
                if (taskDataHandler == null || !taskDataHandler.canInitializeSubTaskData(null, (ITask)this.selectedTask)) {
                    this.selectedTask = null;
                }
            }
        }
        return this.selectedTask != null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        } else {
            this.setEnabled(false);
        }
        action.setEnabled(this.isEnabled());
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

