/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskAction
extends Action {
    protected List<IRepositoryElement> selectedElements;

    public void run() {
        for (IRepositoryElement element : this.selectedElements) {
            if (element instanceof ITask) {
                AbstractTask repositoryTask = (AbstractTask)element;
                this.performActionOnTask((ITask)repositoryTask);
                continue;
            }
            if (element instanceof IRepositoryQuery) {
                RepositoryQuery repositoryQuery = (RepositoryQuery)element;
                for (ITask queryHit : repositoryQuery.getChildren()) {
                    this.performActionOnTask(queryHit);
                }
                continue;
            }
            if (!(element instanceof ITaskContainer)) continue;
            ITaskContainer container = (ITaskContainer)element;
            for (ITask task : container.getChildren()) {
                if (task == null) continue;
                ITask repositoryTask = task;
                this.performActionOnTask(repositoryTask);
            }
        }
    }

    protected abstract void performActionOnTask(ITask var1);

    protected boolean containsArchiveContainer(List<AbstractTaskContainer> selectedElements) {
        return false;
    }
}

