/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.UnmarshalXPathEngine;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRecord
extends XMLRecord {
    private Node dom;
    private XMLField lastUpdatedField;

    public DOMRecord() {
    }

    public DOMRecord(String rootElementName) {
        this(rootElementName, (NamespaceResolver)null);
    }

    public DOMRecord(String rootElementName, NamespaceResolver namespaceResolver) {
        this();
        String rootElementNamespaceURI = this.resolveNamespace(namespaceResolver, rootElementName);
        this.setDOM(this.createNewDocument(rootElementName, rootElementNamespaceURI));
    }

    public DOMRecord(String rootElementName, String rootElementNamespaceURI) {
        this();
        this.setDOM(this.createNewDocument(rootElementName, rootElementNamespaceURI));
    }

    public DOMRecord(String localRootElementName, Node parent) {
        this(localRootElementName, null, parent);
    }

    public DOMRecord(String localRootElementName, NamespaceResolver namespaceResolver, Node parent) {
        this();
        Document document = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        String localRootElementNamespaceURI = this.resolveNamespace(namespaceResolver, localRootElementName);
        Element child = document.createElementNS(localRootElementNamespaceURI, localRootElementName);
        parent.appendChild(child);
        this.setDOM(child);
    }

    public DOMRecord(Element element) {
        this();
        this.setDOM(element);
    }

    public DOMRecord(Node node) {
        this();
        this.setDOM(node);
    }

    public DOMRecord(Document document) {
        this();
        this.setDOM(document.getDocumentElement());
    }

    public String getLocalName() {
        String localName = this.getDOM().getLocalName();
        if (null != localName) {
            return localName;
        }
        return this.getDOM().getNodeName();
    }

    public String getNamespaceURI() {
        return this.getDOM().getNamespaceURI();
    }

    public void add(DatabaseField key, Object value) {
        Object nodeValue = this.convertToNodeValue(value);
        XPathEngine.getInstance().create(this.convertToXMLField(key), this.dom, nodeValue, this.session);
    }

    private Object convertToNodeValue(Object value) {
        if (value instanceof Vector) {
            Vector values = (Vector)value;
            Vector<Object> nodeValues = new Vector<Object>(values.size());
            for (int index = 0; index < values.size(); ++index) {
                Object nestedValue = values.get(index);
                nodeValues.add(this.convertToNodeValue(nestedValue));
            }
            return nodeValues;
        }
        if (value instanceof DOMRecord) {
            return ((DOMRecord)value).getDOM();
        }
        return value;
    }

    public void clear() {
        if (this.getDOM() instanceof Element) {
            String domName = ((Element)this.getDOM()).getTagName();
            this.dom = this.createNewDocument(domName, null);
        }
    }

    public Object clone() {
        DOMRecord clone = (DOMRecord)super.clone();
        if (clone != null) {
            clone.setDOM((Element)this.dom.cloneNode(true));
        }
        return clone;
    }

    public Node createNewDocument(String defaultRootElementName) {
        return this.createNewDocument(defaultRootElementName, null);
    }

    public Node createNewDocument(String defaultRootElementName, String namespaceURI) {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        Document document = xmlPlatform.createDocument();
        if (defaultRootElementName != null) {
            Element rootNode = document.createElementNS(namespaceURI, defaultRootElementName);
            document.appendChild(rootNode);
            return document.getDocumentElement();
        }
        DocumentFragment fragment = document.createDocumentFragment();
        return fragment;
    }

    public Document getDocument() {
        return this.getDOM().getOwnerDocument();
    }

    public boolean containsKey(DatabaseField key) {
        XMLField xmlField = this.convertToXMLField(key);
        NodeList nodeList = UnmarshalXPathEngine.getInstance().selectNodes(this.dom, xmlField, (XMLNamespaceResolver)xmlField.getNamespaceResolver());
        return nodeList.getLength() > 0;
    }

    public boolean contains(Object value) {
        return this.values().contains(value);
    }

    public Object get(DatabaseField key) {
        Object value = this.getIndicatingNoEntry(key);
        if (value == noEntry) {
            return null;
        }
        return value;
    }

    public Object getIndicatingNoEntry(DatabaseField key) {
        return this.getIndicatingNoEntry(key, false);
    }

    public Object getIndicatingNoEntry(DatabaseField key, boolean shouldReturnNode) {
        XMLField field = this.convertToXMLField(key);
        if (field.isSelfField()) {
            return this;
        }
        Object result = UnmarshalXPathEngine.getInstance().selectSingleNode(this.dom, field, (XMLNamespaceResolver)field.getNamespaceResolver());
        if (result == noEntry) {
            if (shouldReturnNode) {
                return null;
            }
            return noEntry;
        }
        Node node = (Node)result;
        if (shouldReturnNode) {
            return node;
        }
        if (null == node) {
            return null;
        }
        if (1 != node.getNodeType()) {
            if (node.getNodeType() == 2) {
                this.getValueFromAttribute((Attr)node, field);
            }
            return this.getValueFromElement((Element)node.getParentNode(), node, field);
        }
        return this.buildNestedRow((Element)node);
    }

    public Object getValues(String key) {
        Object value = this.getValuesIndicatingNoEntry(new XMLField(key));
        if (value == AbstractRecord.noEntry) {
            return null;
        }
        return value;
    }

    public Object getValues(DatabaseField key) {
        Object value = this.getValuesIndicatingNoEntry(key);
        if (value == AbstractRecord.noEntry) {
            return null;
        }
        return value;
    }

    public Object getValuesIndicatingNoEntry(DatabaseField key) {
        return this.getValuesIndicatingNoEntry(key, false);
    }

    public Object getValuesIndicatingNoEntry(DatabaseField key, boolean shouldReturnNodes) {
        XMLField field = this.convertToXMLField(key);
        NodeList nodeList = UnmarshalXPathEngine.getInstance().selectNodes(this.dom, field, (XMLNamespaceResolver)field.getNamespaceResolver());
        if (null == nodeList) {
            return null;
        }
        int resultSize = nodeList.getLength();
        Vector<Object> result = new Vector<Object>(resultSize);
        if (resultSize == 0) {
            return result;
        }
        if (shouldReturnNodes) {
            for (int i = 0; i < resultSize; ++i) {
                result.add(nodeList.item(i));
            }
            return result;
        }
        Node firstNode = nodeList.item(0);
        if (firstNode == null || firstNode.getNodeType() != 1) {
            if (field.usesSingleNode() && resultSize == 1) {
                Node next = nodeList.item(0);
                if (next == null) {
                    result.add(null);
                } else {
                    Vector<Object> list = new Vector<Object>();
                    String sourceObject = next.getNodeValue();
                    StringTokenizer tokenizer = new StringTokenizer(sourceObject, " ");
                    while (tokenizer.hasMoreElements()) {
                        String token = tokenizer.nextToken();
                        Object nextItem = this.convertValue((Element)next.getParentNode(), field, token);
                        list.add(nextItem);
                    }
                    return list;
                }
            }
            for (int x = 0; x < resultSize; ++x) {
                Node next = nodeList.item(x);
                if (next == null) {
                    result.add(null);
                    continue;
                }
                result.add(this.getValueFromElement((Element)next.getParentNode(), next, field));
            }
        } else {
            for (int x = 0; x < resultSize; ++x) {
                result.add(this.buildNestedRow((Element)nodeList.item(x)));
            }
        }
        return result;
    }

    private Object getValueFromAttribute(Attr node, XMLField key) {
        return key.convertValueBasedOnSchemaType(node.getNodeValue(), (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager());
    }

    private Object getValueFromElement(Element node, Node textChild, XMLField key) {
        String value = textChild.getNodeValue();
        return this.convertValue(node, key, value);
    }

    private Object convertValue(Element node, XMLField key, Object value) {
        String schemaType;
        XMLConversionManager xmlCnvMgr = (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager();
        if (key.isTypedTextField() && node != null && null != (schemaType = node.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) && !schemaType.equals("")) {
            QName qname = null;
            int index = schemaType.indexOf(58);
            if (index == -1) {
                qname = new QName(schemaType);
                Class convertClass = key.getJavaClass(qname);
                return xmlCnvMgr.convertObject(value, convertClass);
            }
            String prefix = schemaType.substring(0, index);
            String localPart = schemaType.substring(index + 1);
            XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            String url = xmlPlatform.resolveNamespacePrefix(node, prefix);
            qname = new QName(url, localPart);
            Class convertClass = key.getJavaClass(qname);
            return xmlCnvMgr.convertObject(value, convertClass, qname);
        }
        return key.convertValueBasedOnSchemaType(value, xmlCnvMgr);
    }

    public XMLRecord buildNestedRow(Element element) {
        DOMRecord record = new DOMRecord(element);
        record.setUnmarshaller(this.getUnmarshaller());
        record.setOwningObject(this.getCurrentObject());
        record.setDocPresPolicy(this.getDocPresPolicy());
        return record;
    }

    public Node getDOM() {
        return this.dom;
    }

    public Object put(DatabaseField key, Object value) {
        XMLField field = this.convertToXMLField(key);
        Object nodeValue = this.convertToNodeValue(value);
        NodeList replaced = null;
        boolean isEmptyCollection = false;
        if (nodeValue instanceof Collection) {
            isEmptyCollection = ((Collection)nodeValue).size() == 0;
            replaced = XPathEngine.getInstance().replaceCollection(this.convertToXMLField(key), this.dom, (Collection)nodeValue, this.session);
        } else {
            replaced = XPathEngine.getInstance().replaceValue(this.convertToXMLField(key), this.dom, nodeValue, this.session);
        }
        if (replaced.getLength() == 0) {
            XPathEngine.getInstance().create(this.convertToXMLField(key), this.dom, nodeValue, this.lastUpdatedField, this.getDocPresPolicy(), this.session);
        } else if (replaced.item(0) == this.getDOM()) {
            this.setDOM(this.getDocument().getDocumentElement());
        }
        if (!(field.getXPathFragment().isAttribute() || field.getXPathFragment().nameIsText() || value == null || isEmptyCollection)) {
            this.lastUpdatedField = field;
        }
        return replaced;
    }

    public Object remove(DatabaseField key) {
        return XPathEngine.getInstance().remove(this.convertToXMLField(key), this.dom, true);
    }

    public void replaceAt(Object value, int index) {
        throw XMLMarshalException.operationNotSupported("replaceAt(Object value, int index)");
    }

    public Set entrySet() {
        int size = this.size();
        HashMap tempMap = new HashMap(size);
        Vector fields = this.getFields();
        Vector values = this.getValues();
        for (int i = 0; i < size; ++i) {
            tempMap.put(fields.elementAt(i), values.elementAt(i));
        }
        return tempMap.entrySet();
    }

    protected void setFields(Vector fields) throws XMLMarshalException {
        throw XMLMarshalException.operationNotSupported("setField(Vector fields)");
    }

    public Vector getFields() {
        int length = this.getDOM().getChildNodes().getLength();
        Node nextNode = null;
        if (length > 0) {
            nextNode = this.getDOM().getChildNodes().item(0);
        }
        Vector<DatabaseField> fields = new Vector<DatabaseField>(length);
        while (nextNode != null) {
            fields.add(new DatabaseField(nextNode.getNodeName()));
            nextNode = nextNode.getNextSibling();
        }
        return fields;
    }

    public Vector getValues() {
        int length = this.getDOM().getChildNodes().getLength();
        Node nextNode = null;
        if (length > 0) {
            nextNode = this.getDOM().getFirstChild();
        }
        Vector<Node> values = new Vector<Node>(length);
        while (nextNode != null) {
            values.add(nextNode);
            nextNode = nextNode.getNextSibling();
        }
        return values;
    }

    protected void setValues(Vector values) throws XMLMarshalException {
        throw XMLMarshalException.operationNotSupported("setValues(Vector values)");
    }

    public void setDOM(Node element) {
        this.dom = element;
        this.getNamespaceResolver().setDOM(element);
    }

    public void setDOM(Element element) {
        this.dom = element;
        this.getNamespaceResolver().setDOM(element);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("(");
        this.transformToWriter(writer);
        writer.write(")");
        return writer.toString();
    }

    public Set keySet() {
        int length = this.getDOM().getChildNodes().getLength();
        HashSet<String> keys = new HashSet<String>(length);
        for (int index = 0; index < length; ++index) {
            keys.add(this.getDOM().getChildNodes().item(index).getNodeName());
        }
        return keys;
    }

    public Collection values() {
        int length = this.getDOM().getChildNodes().getLength();
        Vector<Node> values = new Vector<Node>(length);
        for (int index = 0; index < length; ++index) {
            values.add(this.getDOM().getChildNodes().item(index));
        }
        return values;
    }

    public int size() {
        return this.getDOM().getAttributes().getLength() + this.getDOM().getChildNodes().getLength();
    }

    public void transformFromXML(String xml) {
        StringReader reader = new StringReader(xml);
        this.transformFromXML(reader);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String localName) {
        if (localName == null) {
            return null;
        }
        int colonIndex = localName.indexOf(58);
        if (colonIndex < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.getDefaultNamespaceURI();
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(localName);
        }
        String prefix = localName.substring(0, colonIndex);
        String uri = namespaceResolver.resolveNamespacePrefix(prefix);
        if (uri == null) {
            throw XMLMarshalException.namespaceNotFound(prefix);
        }
        return uri;
    }

    public void transformFromXML(Reader reader) {
        XMLParser parser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
        Document document = parser.parse(reader);
        this.setDOM(document.getDocumentElement());
    }

    public String transformToXML() {
        StringWriter writer = new StringWriter();
        this.transformToWriter(writer);
        return writer.toString();
    }

    public void transformToWriter(Writer writer) {
        XMLTransformer xmlTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        xmlTransformer.transform(this.getDOM(), writer);
    }

    public String resolveNamespacePrefix(String prefix) {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        return xmlPlatform.resolveNamespacePrefix(this.getDOM(), prefix);
    }
}

