/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class AbstractCompositeDirectCollectionMapping
extends DatabaseMapping
implements ContainerMapping {
    protected DatabaseField field;
    protected String elementDataTypeName = "";
    protected Converter valueConverter;
    private ContainerPolicy containerPolicy = ContainerPolicy.buildDefaultPolicy();

    public Converter getValueConverter() {
        return this.valueConverter;
    }

    public boolean hasValueConverter() {
        return this.getValueConverter() != null;
    }

    public void setValueConverter(Converter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public Object buildAddedElementFromChangeSet(Object changeSet, MergeManager mergeManager) {
        return this.buildElementFromChangeSet(changeSet, mergeManager);
    }

    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        this.buildClone(clone, backup, unitOfWork);
    }

    public Object buildChangeSet(Object element, ObjectChangeSet owner, AbstractSession session) {
        return element;
    }

    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        this.setAttributeValueInObject(clone, this.buildClonePart(attributeValue, unitOfWork));
    }

    public void buildCloneFromRow(AbstractRecord row, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object cloneAttributeValue = this.valueFromRow(row, joinManager, sourceQuery, executionSession);
        this.setAttributeValueInObject(clone, cloneAttributeValue);
    }

    protected Object buildClonePart(Object attributeValue, UnitOfWorkImpl unitOfWork) {
        if (attributeValue == null) {
            return this.getContainerPolicy().containerInstance();
        }
        if (this.getValueConverter() == null || !this.getValueConverter().isMutable()) {
            return this.getContainerPolicy().cloneFor(attributeValue);
        }
        Object cloneContainer = this.getContainerPolicy().containerInstance();
        Object iterator = this.getContainerPolicy().iteratorFor(attributeValue);
        while (this.getContainerPolicy().hasNext(iterator)) {
            Object originalValue = this.getContainerPolicy().next(iterator, unitOfWork);
            Object cloneValue = this.getValueConverter().convertDataValueToObjectValue(this.getValueConverter().convertObjectValueToDataValue(originalValue, unitOfWork), unitOfWork);
            this.getContainerPolicy().addInto(cloneValue, cloneContainer, unitOfWork);
        }
        return cloneContainer;
    }

    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        attributeValue = attributeValue == null ? this.getContainerPolicy().containerInstance() : this.getContainerPolicy().cloneFor(attributeValue);
        this.setAttributeValueInObject(copy, attributeValue);
    }

    protected Object buildElementFromChangeSet(Object changeSet, MergeManager mergeManager) {
        return changeSet;
    }

    public Object buildElementFromElement(Object object, MergeManager mergeManager) {
        return object;
    }

    public Object buildRemovedElementFromChangeSet(Object changeSet, MergeManager mergeManager) {
        return this.buildElementFromChangeSet(changeSet, mergeManager);
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    protected Vector collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        fields.addElement(this.getField());
        return fields;
    }

    public boolean compareElements(Object element1, Object element2, AbstractSession session) {
        return element1.equals(element2);
    }

    public boolean compareElementsForChange(Object element1, Object element2, AbstractSession session) {
        return this.compareElements(element1, element2, session);
    }

    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backup);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            ContainerPolicy cp = this.getContainerPolicy();
            Object backupCollection = null;
            Object cloneCollection = null;
            cloneCollection = this.getRealCollectionAttributeValueFromObject(clone, session);
            backupCollection = this.getRealCollectionAttributeValueFromObject(backup, session);
            if (cp.sizeFor(backupCollection) != cp.sizeFor(cloneCollection)) {
                return this.convertToChangeRecord(cloneCollection, owner, session);
            }
            Object cloneIterator = cp.iteratorFor(cloneCollection);
            Object backUpIterator = cp.iteratorFor(backupCollection);
            boolean change = false;
            while (cp.hasNext(cloneIterator)) {
                Object cloneObject = cp.next(cloneIterator, session);
                if (cloneObject == null) {
                    change = true;
                    break;
                }
                Object backUpObject = null;
                if (!cp.hasNext(backUpIterator)) {
                    change = true;
                    break;
                }
                backUpObject = cp.next(backUpIterator, session);
                if (cloneObject.getClass().equals(backUpObject.getClass())) {
                    if (cloneObject.equals(backUpObject)) continue;
                    change = true;
                    break;
                }
                change = true;
                break;
            }
            if (change || cp.hasNext(backUpIterator)) {
                return this.convertToChangeRecord(cloneCollection, owner, session);
            }
            return null;
        }
        return this.convertToChangeRecord(this.getRealCollectionAttributeValueFromObject(clone, session), owner, session);
    }

    protected ChangeRecord convertToChangeRecord(Object cloneCollection, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object container = cp.containerInstance();
        Object iter = cp.iteratorFor(cloneCollection);
        while (cp.hasNext(iter)) {
            cp.addInto(cp.next(iter, session), container, session);
        }
        DirectToFieldChangeRecord changeRecord = new DirectToFieldChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setNewValue(container);
        return changeRecord;
    }

    public boolean compareObjects(Object object1, Object object2, AbstractSession session) {
        Object firstCollection = this.getRealCollectionAttributeValueFromObject(object1, session);
        Object secondCollection = this.getRealCollectionAttributeValueFromObject(object2, session);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(firstCollection) != containerPolicy.sizeFor(secondCollection)) {
            return false;
        }
        if (containerPolicy.sizeFor(firstCollection) == 0) {
            return true;
        }
        Object iterFirst = containerPolicy.iteratorFor(firstCollection);
        Object iterSecond = containerPolicy.iteratorFor(secondCollection);
        while (containerPolicy.hasNext(iterFirst)) {
            Object secondAggregateObject;
            Object firstAggregateObject = containerPolicy.next(iterFirst, session);
            if (firstAggregateObject.equals(secondAggregateObject = containerPolicy.next(iterSecond, session))) continue;
            return false;
        }
        return true;
    }

    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
    }

    public Class getAttributeElementClass() {
        if (!(this.getValueConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getValueConverter()).getObjectClass();
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public boolean isAbstractCompositeDirectCollectionMapping() {
        return true;
    }

    public Class getFieldElementClass() {
        if (!(this.getValueConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getValueConverter()).getDataClass();
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        Object value = this.getRealAttributeValueFromObject(object, session);
        if (value == null) {
            value = this.getContainerPolicy().containerInstance(1);
        }
        return value;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        this.setField(this.getDescriptor().buildField(this.getField()));
        this.setFields(this.collectFields());
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, session);
        }
    }

    public void iterate(DescriptorIterator iterator) {
        if (iterator.shouldIterateOnPrimitives()) {
            Object attributeValue = this.getAttributeValueFromObject(iterator.getVisitedParent());
            if (attributeValue == null) {
                return;
            }
            ContainerPolicy cp = this.getContainerPolicy();
            Object iter = cp.iteratorFor(attributeValue);
            while (cp.hasNext(iter)) {
                iterator.iteratePrimitiveForMapping(cp.next(iter, iterator.getSession()), this);
            }
        }
    }

    public boolean mapKeyHasChanged(Object element, AbstractSession session) {
        return false;
    }

    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        if (changeRecord == null) {
            Object targetValue = this.getRealAttributeValueFromObject(source, mergeManager.getSession());
            ContainerPolicy cp = this.getContainerPolicy();
            Object container = cp.containerInstance();
            Object iter = cp.iteratorFor(targetValue);
            while (cp.hasNext(iter)) {
                cp.addInto(cp.next(iter, mergeManager.getSession()), container, mergeManager.getSession());
            }
            this.setAttributeValueInObject(target, container);
        } else {
            this.setAttributeValueInObject(target, ((DirectToFieldChangeRecord)changeRecord).getNewValue());
        }
    }

    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        Object attributeValue = this.getAttributeValueFromObject(source);
        ContainerPolicy cp = this.getContainerPolicy();
        Object container = cp.containerInstance();
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            cp.addInto(cp.next(iter, mergeManager.getSession()), container, mergeManager.getSession());
        }
        this.setAttributeValueInObject(target, container);
    }

    public void setAttributeElementClass(Class attributeElementClass) {
        TypeConversionConverter converter;
        if (this.getValueConverter() instanceof TypeConversionConverter) {
            converter = (TypeConversionConverter)this.getValueConverter();
        } else {
            converter = new TypeConversionConverter();
            this.setValueConverter(converter);
        }
        converter.setObjectClass(attributeElementClass);
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public void setField(DatabaseField field) {
        this.field = field;
    }

    public void setFieldElementClass(Class fieldElementClass) {
        TypeConversionConverter converter;
        if (this.getValueConverter() instanceof TypeConversionConverter) {
            converter = (TypeConversionConverter)this.getValueConverter();
        } else {
            converter = new TypeConversionConverter();
            this.setValueConverter(converter);
        }
        converter.setDataClass(fieldElementClass);
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        DirectToFieldChangeRecord collectionChangeRecord = (DirectToFieldChangeRecord)changeSet.getAttributesToChanges().get(this.getAttributeName());
        if (collectionChangeRecord == null) {
            Object cloneObject = ((UnitOfWorkChangeSet)changeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(changeSet);
            Object cloneCollection = this.getRealAttributeValueFromObject(cloneObject, session);
            collectionChangeRecord = (DirectToFieldChangeRecord)this.convertToChangeRecord(cloneCollection, changeSet, session);
            changeSet.addChange(collectionChangeRecord);
        } else {
            this.getContainerPolicy().addInto(changeSetToAdd, collectionChangeRecord.getNewValue(), session);
        }
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        DirectToFieldChangeRecord collectionChangeRecord = (DirectToFieldChangeRecord)changeSet.getAttributesToChanges().get(this.getAttributeName());
        if (collectionChangeRecord == null) {
            Object cloneObject = ((UnitOfWorkChangeSet)changeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(changeSet);
            Object cloneCollection = this.getRealAttributeValueFromObject(cloneObject, session);
            collectionChangeRecord = (DirectToFieldChangeRecord)this.convertToChangeRecord(cloneCollection, changeSet, session);
            changeSet.addChange(collectionChangeRecord);
        } else {
            this.getContainerPolicy().removeFrom(changeSetToRemove, collectionChangeRecord.getNewValue(), session);
        }
    }

    public void useCollectionClass(Class concreteClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteClass));
    }

    public void useMapClass(Class concreteClass, String methodName) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".useMapClass(Class, String)");
    }

    public void setUsesSingleNode(boolean usesSingleNode) {
        if (this.getField() instanceof XMLField) {
            ((XMLField)this.getField()).setUsesSingleNode(usesSingleNode);
        }
    }

    public boolean usesSingleNode() {
        if (this.getField() instanceof XMLField) {
            return ((XMLField)this.getField()).usesSingleNode();
        }
        return false;
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ContainerPolicy cp = this.getContainerPolicy();
        Object fieldValue = row.getValues(this.getField());
        if (fieldValue == null) {
            return cp.containerInstance();
        }
        Vector fieldValues = this.getDescriptor().buildDirectValuesFromFieldValue(fieldValue);
        if (fieldValues == null) {
            return cp.containerInstance();
        }
        Object result = cp.containerInstance(fieldValues.size());
        Enumeration stream = fieldValues.elements();
        while (stream.hasMoreElements()) {
            Object element = stream.nextElement();
            if (this.getValueConverter() != null) {
                element = this.getValueConverter().convertDataValueToObjectValue(element, executionSession);
            }
            cp.addInto(element, result, sourceQuery.getSession());
        }
        return result;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> elements = new Vector<Object>(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Object element = cp.next(iter, session);
            if (this.getValueConverter() != null) {
                element = this.getValueConverter().convertObjectValueToDataValue(element, session);
            }
            if (element == null) continue;
            elements.addElement(element);
        }
        Object fieldValue = null;
        if (!elements.isEmpty()) {
            fieldValue = this.getDescriptor().buildFieldValueFromDirectValues(elements, this.elementDataTypeName, session);
        }
        row.put(this.getField(), fieldValue);
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeQuery, AbstractRecord row) throws DescriptorException {
        AbstractSession session = writeQuery.getSession();
        if (session.isUnitOfWork() && this.compareObjects(writeQuery.getObject(), writeQuery.getBackupClone(), session)) {
            return;
        }
        this.writeFromObjectIntoRow(writeQuery.getObject(), row, session);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session) {
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, row, session);
    }

    public void writeInsertFieldsIntoRow(AbstractRecord row, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        row.put(this.getField(), (Object)null);
    }

    public Class getFieldClassification(DatabaseField fieldToClassify) {
        return this.getAttributeElementClass();
    }
}

