/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.sequencing.DatabaseSessionConnectionHandler;
import org.eclipse.persistence.internal.sequencing.PreallocationHandler;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sequencing.SequencingConnectionHandler;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sequencing.SequencingServer;
import org.eclipse.persistence.internal.sequencing.ServerSessionConnectionHandler;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.SequencingControl;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SequencingManager
implements SequencingHome,
SequencingServer,
SequencingControl {
    private DatabaseSessionImpl ownerSession;
    private SequencingConnectionHandler connectionHandler;
    private PreallocationHandler preallocationHandler;
    private int whenShouldAcquireValueForAll;
    private Vector connectedSequences;
    boolean atLeastOneSequenceShouldUseTransaction;
    boolean atLeastOneSequenceShouldUsePreallocation;
    private static final int NOPREALLOCATION = 0;
    private static final int PREALLOCATION_NOTRANSACTION = 1;
    private static final int PREALLOCATION_TRANSACTION_NOACCESSOR = 2;
    private static final int PREALLOCATION_TRANSACTION_ACCESSOR = 3;
    private static final int NUMBER_OF_STATES = 4;
    private State[] states;
    private Map<String, ConcurrencyManager> locks;
    private SequencingCallbackFactory callbackFactory;
    private SequencingServer server;
    private Sequencing seq;
    private boolean shouldUseSeparateConnection;
    private Login login;
    private int minPoolSize;
    private int maxPoolSize;

    public SequencingManager(DatabaseSessionImpl ownerSession) {
        this.ownerSession = ownerSession;
    }

    protected DatabaseSessionImpl getOwnerSession() {
        return this.ownerSession;
    }

    protected void createConnectionHandler() {
        boolean isServerSession = this.getOwnerSession().isServerSession();
        if (this.getLogin() == null) {
            Login login = isServerSession ? ((ServerSession)this.getOwnerSession()).getReadConnectionPool().getLogin() : this.getOwnerSession().getDatasourceLogin();
            this.setLogin((Login)login.clone());
        }
        if (this.getLogin() != null && this.getLogin().shouldUseExternalTransactionController()) {
            throw ValidationException.invalidSequencingLogin();
        }
        if (isServerSession) {
            ConnectionPool pool = null;
            if (this.getLogin().shouldUseExternalConnectionPooling()) {
                pool = new ExternalConnectionPool("sequencing", this.getLogin(), (ServerSession)this.getOwnerSession());
            } else {
                if (this.getMinPoolSize() == 0 && this.getMaxPoolSize() == 0) {
                    this.setMinPoolSize(2);
                    this.setMaxPoolSize(2);
                }
                pool = new ConnectionPool("sequencing", this.getLogin(), this.getMinPoolSize(), this.getMaxPoolSize(), (ServerSession)this.getOwnerSession());
            }
            this.setConnectionHandler(new ServerSessionConnectionHandler(pool));
        } else {
            this.setConnectionHandler(new DatabaseSessionConnectionHandler(this.getOwnerSession(), this.getLogin()));
        }
    }

    @Override
    public SequencingControl getSequencingControl() {
        return this;
    }

    protected void setSequencing(Sequencing sequencing) {
        this.seq = sequencing;
    }

    @Override
    public Sequencing getSequencing() {
        return this.seq;
    }

    protected void setSequencingServer(SequencingServer server) {
        this.server = server;
    }

    @Override
    public SequencingServer getSequencingServer() {
        return this.server;
    }

    protected void setSequencingCallbackFactory(SequencingCallbackFactory callbackFactory) {
        this.callbackFactory = callbackFactory;
    }

    @Override
    public boolean isSequencingCallbackRequired() {
        return this.callbackFactory != null;
    }

    @Override
    public boolean shouldUseSeparateConnection() {
        return this.shouldUseSeparateConnection;
    }

    @Override
    public void setShouldUseSeparateConnection(boolean shouldUseSeparateConnection) {
        this.shouldUseSeparateConnection = shouldUseSeparateConnection;
    }

    @Override
    public boolean isConnectedUsingSeparateConnection() {
        return this.isConnected() && this.getConnectionHandler() != null;
    }

    @Override
    public Login getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(Login login) {
        this.login = login;
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    @Override
    public void setMinPoolSize(int size) {
        this.minPoolSize = size;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaxPoolSize(int size) {
        this.maxPoolSize = size;
    }

    @Override
    public boolean isConnected() {
        return this.states != null;
    }

    protected SequencingConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected void setConnectionHandler(SequencingConnectionHandler handler) {
        this.connectionHandler = handler;
    }

    @Override
    public ConnectionPool getConnectionPool() {
        ConnectionPool pool = null;
        if (this.getConnectionHandler() != null && this.getConnectionHandler() instanceof ServerSessionConnectionHandler) {
            pool = ((ServerSessionConnectionHandler)this.getConnectionHandler()).getPool();
        }
        return pool;
    }

    @Override
    public Object getNextValue(Class cls) {
        return this.getNextValue(this.getOwnerSession(), cls);
    }

    @Override
    public void initializePreallocated() {
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().initializePreallocated();
        }
    }

    @Override
    public void initializePreallocated(String seqName) {
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().initializePreallocated(seqName);
        }
    }

    protected void setLocks(Map locks) {
        this.locks = locks;
    }

    protected Map<String, ConcurrencyManager> getLocks() {
        return this.locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireLock(String sequenceName) {
        ConcurrencyManager manager = this.getLocks().get(sequenceName);
        if (manager == null) {
            Map<String, ConcurrencyManager> map = this.getLocks();
            synchronized (map) {
                manager = this.getLocks().get(sequenceName);
                if (manager == null) {
                    manager = new ConcurrencyManager();
                    this.getLocks().put(sequenceName, manager);
                }
            }
        }
        manager.acquire();
    }

    protected void releaseLock(String seqName) {
        ConcurrencyManager manager = this.getLocks().get(seqName);
        manager.release();
    }

    protected Sequence getSequence(Class cls) {
        String seqName = this.getOwnerSession().getDescriptor(cls).getSequenceNumberName();
        return this.getSequence(seqName);
    }

    protected void logDebugPreallocation(String seqName, Object firstSequenceValue, Vector sequences) {
        if (this.getOwnerSession().shouldLog(1, "sequencing")) {
            Object[] args = new Object[]{seqName, new Integer(sequences.size() + 1), firstSequenceValue, sequences.lastElement()};
            this.getOwnerSession().log(1, "sequencing", "sequencing_preallocation", args);
        }
    }

    protected void logDebugLocalPreallocation(AbstractSession writeSession, String seqName, Vector sequences, Accessor accessor) {
        if (writeSession.shouldLog(1, "sequencing")) {
            Object[] args = new Object[]{seqName, new Integer(sequences.size()), sequences.firstElement(), sequences.lastElement()};
            writeSession.log(1, "sequencing", "sequencing_localPreallocation", args, accessor);
        }
    }

    @Override
    public void resetSequencing() {
        if (this.isConnected()) {
            this.onDisconnect();
            this.onConnect();
        }
    }

    @Override
    public void onConnect() {
        if (this.isConnected()) {
            return;
        }
        if (!this.getOwnerSession().getProject().usesSequencing()) {
            return;
        }
        this.onConnectAllSequences();
        boolean onExceptionDisconnectPreallocationHandler = false;
        boolean onExceptionDisconnectConnectionHandler = false;
        try {
            if (!this.shouldUseSeparateConnection()) {
                this.setConnectionHandler(null);
            } else if (this.atLeastOneSequenceShouldUseTransaction) {
                if (this.getConnectionHandler() == null) {
                    this.createConnectionHandler();
                }
                if (this.getConnectionHandler() != null) {
                    this.getConnectionHandler().onConnect();
                    onExceptionDisconnectConnectionHandler = true;
                }
            }
            if (this.atLeastOneSequenceShouldUsePreallocation) {
                if (this.getPreallocationHandler() == null) {
                    this.createPreallocationHandler();
                }
                this.getPreallocationHandler().onConnect();
                onExceptionDisconnectPreallocationHandler = true;
            }
            this.initializeStates();
        }
        catch (RuntimeException ex) {
            this.onDisconnectAllSequences();
            if (this.getConnectionHandler() != null) {
                if (onExceptionDisconnectConnectionHandler) {
                    this.getConnectionHandler().onDisconnect();
                }
                this.setConnectionHandler(null);
            }
            if (this.getPreallocationHandler() != null) {
                if (onExceptionDisconnectPreallocationHandler) {
                    this.getPreallocationHandler().onDisconnect();
                }
                this.clearPreallocationHandler();
            }
            throw ex;
        }
        if (this.atLeastOneSequenceShouldUsePreallocation) {
            this.setLocks(new ConcurrentHashMap(20));
        }
        this.createSequencingCallbackFactory();
        if (this.getOwnerSession().hasExternalTransactionController()) {
            this.getOwnerSession().getExternalTransactionController().initializeSequencingListeners();
        }
        if (this.getOwnerSession().isServerSession()) {
            this.setSequencingServer(this);
        }
        this.setSequencing(this);
        this.logDebugSequencingConnected();
    }

    @Override
    public void onDisconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.setSequencing(null);
        this.setSequencingServer(null);
        this.setSequencingCallbackFactory(null);
        if (this.getOwnerSession().hasExternalTransactionController()) {
            this.getOwnerSession().getExternalTransactionController().clearSequencingListeners();
        }
        this.setLocks(null);
        this.clearStates();
        if (this.getConnectionHandler() != null) {
            this.getConnectionHandler().onDisconnect();
            this.setConnectionHandler(null);
        }
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().onDisconnect();
            this.clearPreallocationHandler();
        }
        this.onDisconnectAllSequences();
        this.getOwnerSession().log(1, "sequencing", "sequencing_disconnected");
    }

    protected PreallocationHandler getPreallocationHandler() {
        return this.preallocationHandler;
    }

    protected void createPreallocationHandler() {
        this.preallocationHandler = new PreallocationHandler();
    }

    protected void clearPreallocationHandler() {
        this.preallocationHandler = null;
    }

    protected void onConnectAllSequences() {
        this.connectedSequences = new Vector();
        boolean shouldUseTransaction = false;
        boolean shouldUsePreallocation = false;
        boolean shouldAcquireValueAfterInsert = false;
        Iterator descriptors = this.getOwnerSession().getDescriptors().values().iterator();
        while (descriptors.hasNext()) {
            ClassDescriptor newDescriptor;
            ClassDescriptor descriptor;
            ClassDescriptor parentDescriptor = descriptor = (ClassDescriptor)descriptors.next();
            while (!parentDescriptor.usesSequenceNumbers() && parentDescriptor.isChildDescriptor() && (newDescriptor = this.getOwnerSession().getDescriptor(parentDescriptor.getInheritancePolicy().getParentClass())) != null && newDescriptor != parentDescriptor) {
                parentDescriptor = newDescriptor;
            }
            if (!parentDescriptor.usesSequenceNumbers()) continue;
            String seqName = parentDescriptor.getSequenceNumberName();
            Sequence sequence = this.getSequence(seqName);
            if (sequence == null) {
                sequence = new DefaultSequence(seqName);
                this.getOwnerSession().getDatasourcePlatform().addSequence(sequence);
            }
            descriptor.setSequence(sequence);
            if (this.connectedSequences.contains(sequence)) continue;
            try {
                if (sequence instanceof DefaultSequence && !this.connectedSequences.contains(this.getDefaultSequence())) {
                    this.getDefaultSequence().onConnect(this.getOwnerSession().getDatasourcePlatform());
                    this.connectedSequences.add(0, this.getDefaultSequence());
                    shouldUseTransaction |= this.getDefaultSequence().shouldUseTransaction();
                    shouldUsePreallocation |= this.getDefaultSequence().shouldUsePreallocation();
                    shouldAcquireValueAfterInsert |= this.getDefaultSequence().shouldAcquireValueAfterInsert();
                }
                sequence.onConnect(this.getOwnerSession().getDatasourcePlatform());
                this.connectedSequences.addElement(sequence);
                shouldUseTransaction |= sequence.shouldUseTransaction();
                shouldUsePreallocation |= sequence.shouldUsePreallocation();
                shouldAcquireValueAfterInsert |= sequence.shouldAcquireValueAfterInsert();
            }
            catch (RuntimeException ex) {
                for (int i = this.connectedSequences.size() - 1; i >= 0; --i) {
                    try {
                        Sequence sequenceToDisconnect = (Sequence)this.connectedSequences.elementAt(i);
                        sequenceToDisconnect.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                        continue;
                    }
                    catch (RuntimeException ex2) {
                        // empty catch block
                    }
                }
                this.connectedSequences = null;
                throw ex;
            }
        }
        if (shouldAcquireValueAfterInsert && !shouldUsePreallocation) {
            this.whenShouldAcquireValueForAll = 1;
        } else if (!shouldAcquireValueAfterInsert && shouldUsePreallocation) {
            this.whenShouldAcquireValueForAll = -1;
        }
        this.atLeastOneSequenceShouldUseTransaction = shouldUseTransaction;
        this.atLeastOneSequenceShouldUsePreallocation = shouldUsePreallocation;
    }

    protected void onDisconnectAllSequences() {
        RuntimeException exception = null;
        for (int i = this.connectedSequences.size() - 1; i >= 0; --i) {
            try {
                Sequence sequenceToDisconnect = (Sequence)this.connectedSequences.elementAt(i);
                sequenceToDisconnect.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                continue;
            }
            catch (RuntimeException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        this.connectedSequences = null;
        this.whenShouldAcquireValueForAll = 0;
        this.atLeastOneSequenceShouldUseTransaction = false;
        this.atLeastOneSequenceShouldUsePreallocation = false;
        if (exception != null) {
            throw exception;
        }
    }

    protected void initializeStates() {
        this.states = new State[4];
        for (Sequence sequence : this.connectedSequences) {
            State state = this.getState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
            if (state != null) continue;
            this.createState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
        }
    }

    protected void clearStates() {
        this.states = null;
    }

    protected int getStateId(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        if (!shouldUsePreallocation) {
            return 0;
        }
        if (!shouldUseTransaction) {
            return 1;
        }
        if (this.getConnectionHandler() == null) {
            return 2;
        }
        return 3;
    }

    protected State getState(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        return this.states[this.getStateId(shouldUsePreallocation, shouldUseTransaction)];
    }

    protected void createState(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        if (!shouldUsePreallocation) {
            this.states[0] = new NoPreallocation_State();
        } else if (!shouldUseTransaction) {
            this.states[1] = new Preallocation_NoTransaction_State();
        } else if (this.getConnectionHandler() == null) {
            this.states[2] = new Preallocation_Transaction_NoAccessor_State();
        } else {
            this.states[3] = new Preallocation_Transaction_Accessor_State();
        }
    }

    protected void createSequencingCallbackFactory() {
        if (this.states[2] != null) {
            this.setSequencingCallbackFactory(this.states[2].getSequencingCallbackFactory());
        } else {
            this.setSequencingCallbackFactory(null);
        }
    }

    @Override
    public Object getNextValue(AbstractSession writeSession, Class cls) {
        Sequence sequence = this.getSequence(cls);
        State state = this.getState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
        return state.getNextValue(sequence, writeSession);
    }

    protected void logDebugSequencingConnected() {
        Vector[] sequenceVectors = new Vector[4];
        for (Sequence sequence : this.connectedSequences) {
            int stateId = this.getStateId(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
            Vector<Sequence> v = sequenceVectors[stateId];
            if (v == null) {
                sequenceVectors[stateId] = v = new Vector<Sequence>();
            }
            v.addElement(sequence);
        }
        for (int i = 0; i < 4; ++i) {
            Vector v = sequenceVectors[i];
            if (v == null) continue;
            this.getOwnerSession().log(1, "sequencing", "sequencing_connected", this.states[i]);
            for (int j = 0; j < v.size(); ++j) {
                Sequence sequence = (Sequence)v.elementAt(j);
                Object[] args = new Object[]{sequence.getName(), Integer.toString(sequence.getPreallocationSize()), Integer.toString(sequence.getInitialValue())};
                this.getOwnerSession().log(1, "sequencing", "sequence_without_state", args);
            }
        }
    }

    public int getPreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public int getInitialValue() {
        return this.getDefaultSequence().getInitialValue();
    }

    @Override
    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    protected Sequence getDefaultSequence() {
        return this.getOwnerSession().getDatasourcePlatform().getDefaultSequence();
    }

    protected Sequence getSequence(String seqName) {
        return this.getOwnerSession().getDatasourcePlatform().getSequence(seqName);
    }

    class NoPreallocation_State
    extends State {
        NoPreallocation_State() {
        }

        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            return sequence.getGeneratedValue(null, writeSession);
        }
    }

    class Preallocation_NoTransaction_State
    extends State {
        Preallocation_NoTransaction_State() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            String seqName = sequence.getName();
            Queue sequencesForName = SequencingManager.this.getPreallocationHandler().getPreallocated(seqName);
            Object sequenceValue = sequencesForName.poll();
            if (sequenceValue != null) {
                return sequenceValue;
            }
            SequencingManager.this.acquireLock(seqName);
            try {
                sequenceValue = sequencesForName.poll();
                if (sequenceValue != null) {
                    Object e = sequenceValue;
                    return e;
                }
                Vector sequences = sequence.getGeneratedVector(null, writeSession);
                sequenceValue = sequences.remove(0);
                if (!sequences.isEmpty()) {
                    SequencingManager.this.getPreallocationHandler().setPreallocated(seqName, sequences);
                    SequencingManager.this.logDebugPreallocation(seqName, sequenceValue, sequences);
                }
            }
            finally {
                SequencingManager.this.releaseLock(seqName);
            }
            return sequenceValue;
        }
    }

    class Preallocation_Transaction_Accessor_State
    extends State {
        Preallocation_Transaction_Accessor_State() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            String seqName = sequence.getName();
            Queue sequencesForName = SequencingManager.this.getPreallocationHandler().getPreallocated(seqName);
            Object sequenceValue = sequencesForName.poll();
            if (sequenceValue != null) {
                return sequenceValue;
            }
            SequencingManager.this.acquireLock(seqName);
            try {
                sequenceValue = sequencesForName.poll();
                if (sequenceValue != null) {
                    Object e = sequenceValue;
                    return e;
                }
                Accessor accessor = SequencingManager.this.getConnectionHandler().acquireAccessor();
                try {
                    accessor.beginTransaction(writeSession);
                    try {
                        Vector sequences = sequence.getGeneratedVector(accessor, writeSession);
                        accessor.commitTransaction(writeSession);
                        sequenceValue = sequences.remove(0);
                        if (!sequences.isEmpty()) {
                            SequencingManager.this.getPreallocationHandler().setPreallocated(seqName, sequences);
                            SequencingManager.this.logDebugPreallocation(seqName, sequenceValue, sequences);
                        }
                    }
                    catch (RuntimeException ex) {
                        try {
                            accessor.rollbackTransaction(writeSession);
                        }
                        catch (Exception rollbackException) {
                            // empty catch block
                        }
                        throw ex;
                    }
                }
                finally {
                    SequencingManager.this.getConnectionHandler().releaseAccessor(accessor);
                }
            }
            finally {
                SequencingManager.this.releaseLock(seqName);
            }
            return sequenceValue;
        }
    }

    class Preallocation_Transaction_NoAccessor_State
    extends State
    implements SequencingCallbackFactory {
        Preallocation_Transaction_NoAccessor_State() {
        }

        SequencingCallbackFactory getSequencingCallbackFactory() {
            return this;
        }

        public SequencingCallback createSequencingCallback() {
            return new SequencingCallbackImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void afterCommitInternal(Map localSequences, Accessor accessor) {
            for (Map.Entry entry : localSequences.entrySet()) {
                String seqName = (String)entry.getKey();
                Vector localSequenceForName = (Vector)entry.getValue();
                if (localSequenceForName.isEmpty()) continue;
                SequencingManager.this.acquireLock(seqName);
                try {
                    SequencingManager.this.getPreallocationHandler().setPreallocated(seqName, localSequenceForName);
                    localSequenceForName.clear();
                }
                finally {
                    SequencingManager.this.releaseLock(seqName);
                }
            }
            if (accessor != null) {
                SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionCommitted", null, accessor);
            } else {
                SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionCommitted", null);
            }
        }

        SequencingCallbackImpl getCallbackImpl(AbstractSession writeSession, Accessor accessor) {
            SequencingCallbackImpl seqCallbackImpl = writeSession.hasExternalTransactionController() ? (SequencingCallbackImpl)writeSession.getExternalTransactionController().getActiveSequencingCallback(SequencingManager.this.getOwnerSession(), this.getSequencingCallbackFactory()) : (SequencingCallbackImpl)accessor.getSequencingCallback(this.getSequencingCallbackFactory());
            return seqCallbackImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            Vector localSequencesForName;
            String seqName = sequence.getName();
            Queue sequencesForName = SequencingManager.this.getPreallocationHandler().getPreallocated(seqName);
            Object sequenceValue = sequencesForName.poll();
            if (sequenceValue != null) {
                return sequenceValue;
            }
            boolean keepLocked = false;
            SequencingManager.this.acquireLock(seqName);
            try {
                sequenceValue = sequencesForName.poll();
                if (sequenceValue != null) {
                    Object e = sequenceValue;
                    return e;
                }
                if (!SequencingManager.this.getOwnerSession().getDatasourceLogin().shouldUseExternalTransactionController() && sequence.getPreallocationSize() > 1 && !writeSession.isInTransaction()) {
                    writeSession.beginTransaction();
                    keepLocked = true;
                }
            }
            finally {
                if (!keepLocked) {
                    SequencingManager.this.releaseLock(seqName);
                }
            }
            if (!keepLocked) {
                writeSession.beginTransaction();
            }
            try {
                Accessor accessor = writeSession.getAccessor();
                SequencingCallbackImpl seqCallbackImpl = this.getCallbackImpl(writeSession, accessor);
                Map localSequences = seqCallbackImpl.getPreallocatedSequenceValues();
                localSequencesForName = (Vector)localSequences.get(seqName);
                if (localSequencesForName == null || localSequencesForName.isEmpty()) {
                    localSequencesForName = sequence.getGeneratedVector(null, writeSession);
                    localSequences.put(seqName, localSequencesForName);
                    SequencingManager.this.logDebugLocalPreallocation(writeSession, seqName, localSequencesForName, accessor);
                }
            }
            catch (RuntimeException ex) {
                if (keepLocked) {
                    SequencingManager.this.releaseLock(seqName);
                }
                try {
                    writeSession.rollbackTransaction();
                }
                catch (Exception rollbackException) {
                    // empty catch block
                }
                throw ex;
            }
            if (!keepLocked) {
                SequencingManager.this.acquireLock(seqName);
            }
            try {
                Object object;
                try {
                    writeSession.commitTransaction();
                }
                catch (DatabaseException ex) {
                    try {
                        writeSession.rollbackTransaction();
                    }
                    catch (Exception rollbackException) {
                        // empty catch block
                    }
                    throw ex;
                }
                if (!localSequencesForName.isEmpty()) {
                    object = sequenceValue = localSequencesForName.remove(0);
                    return object;
                }
                sequenceValue = sequencesForName.poll();
                if (sequenceValue != null) {
                    object = sequenceValue;
                    return object;
                }
                object = this.getNextValue(sequence, writeSession);
                return object;
            }
            finally {
                SequencingManager.this.releaseLock(seqName);
            }
        }

        public class SequencingCallbackImpl
        implements SequencingCallback {
            Map localSequences = new HashMap();

            public void afterCommit(Accessor accessor) {
                Preallocation_Transaction_NoAccessor_State.this.afterCommitInternal(this.localSequences, accessor);
            }

            public Map getPreallocatedSequenceValues() {
                return this.localSequences;
            }
        }
    }

    static abstract class State {
        State() {
        }

        abstract Object getNextValue(Sequence var1, AbstractSession var2);

        SequencingCallbackFactory getSequencingCallbackFactory() {
            return null;
        }

        public String toString() {
            String name = this.getClass().getName();
            return name.substring(name.lastIndexOf(36) + 1);
        }
    }
}

