/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationListIterator<E1, E2>
implements ListIterator<E2> {
    private final ListIterator<? extends E1> listIterator;
    private final Transformer<E1, ? extends E2> transformer;

    public TransformationListIterator(List<? extends E1> list) {
        this(list.listIterator());
    }

    public TransformationListIterator(ListIterator<? extends E1> listIterator) {
        this(listIterator, Transformer.Disabled.instance());
    }

    public TransformationListIterator(List<? extends E1> list, Transformer<E1, ? extends E2> transformer) {
        this(list.listIterator(), transformer);
    }

    public TransformationListIterator(ListIterator<? extends E1> listIterator, Transformer<E1, ? extends E2> transformer) {
        this.listIterator = listIterator;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        return this.listIterator.hasNext();
    }

    @Override
    public E2 next() {
        return this.transform(this.listIterator.next());
    }

    @Override
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    @Override
    public E2 previous() {
        return this.transform(this.listIterator.previous());
    }

    @Override
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    public void add(E2 o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E2 o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        this.listIterator.remove();
    }

    protected E2 transform(E1 next) {
        return this.transformer.transform(next);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.listIterator);
    }
}

