/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.compiler.IProblem;

class JsProblemRequestor
implements IProblemRequestor {
    private List fCollectedProblems;
    private boolean fIsActive = false;
    private boolean fIsRunning = false;

    JsProblemRequestor() {
    }

    public void acceptProblem(IProblem problem) {
        if (this.isActive()) {
            this.fCollectedProblems.add(problem);
        }
    }

    public void beginReporting() {
        this.fIsRunning = true;
        this.fCollectedProblems = new ArrayList();
    }

    public void endReporting() {
        this.fIsRunning = false;
    }

    public List getCollectedProblems() {
        return this.fCollectedProblems;
    }

    public boolean isActive() {
        return this.fIsActive && this.fCollectedProblems != null;
    }

    public boolean isRunning() {
        return this.fIsRunning;
    }

    public void setIsActive(boolean isActive) {
        if (this.fIsActive != isActive) {
            this.fIsActive = isActive;
            if (this.fIsActive) {
                this.startCollectingProblems();
            } else {
                this.stopCollectingProblems();
            }
        }
    }

    private void startCollectingProblems() {
        this.fCollectedProblems = new ArrayList();
    }

    private void stopCollectingProblems() {
    }
}

