/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.preference;

import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.common.ui.preferences.AbstractDBPreferenceFieldPage;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class SQLResultsViewPage
extends AbstractDBPreferenceFieldPage
implements IContextProvider {
    private Group _displayWindow;
    private Button _singleWindow;
    private Button _multiWindows;
    private Group _displayMode;
    private Button _textMode;
    private Button _gridMode;
    private Group _resultSetOptions;
    private Button _showHeadings;
    private Button _showRowNumber;
    private Button _showRowCountMessage;
    private Label _maxRowCountLabel;
    private Text _maxRowCount;
    private Label _maxDisplayRowCountLabel;
    private Text _maxDisplayRowCount;
    private Label _nullDisplayStrLabel;
    private Text _nullDisplayStr;
    private Group _otherOptionsGrp;
    private Button _splitMessages;
    private Label _limitTabs;
    private Text _limitTabsNum;
    private Label _limitTables;
    private Text _limitTablesNum;
    private Button _showLabels;
    private IPreferenceStore _store;
    private ModifyListener _modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            try {
                int max = Integer.parseInt(SQLResultsViewPage.this._maxRowCount.getText().trim());
                int maxDisplay = Integer.parseInt(SQLResultsViewPage.this._maxDisplayRowCount.getText().trim());
                int tabsNum = Integer.parseInt(SQLResultsViewPage.this._limitTabsNum.getText().trim());
                int tablesNum = Integer.parseInt(SQLResultsViewPage.this._limitTablesNum.getText().trim());
                if (max < 0) {
                    SQLResultsViewPage.this.setMessage(Messages.SQLResultsViewPage_resultsetoptions_lessthanzero, 3);
                    SQLResultsViewPage.this.setValid(false);
                    SQLResultsViewPage.this.updateApplyButton();
                } else if (maxDisplay < 0) {
                    SQLResultsViewPage.this.setMessage(Messages.SQLResultsViewPage_resultsetoptions_lessthanzero, 3);
                    SQLResultsViewPage.this.setValid(false);
                    SQLResultsViewPage.this.updateApplyButton();
                } else if (tabsNum < 0) {
                    SQLResultsViewPage.this.setMessage(Messages.SQLResultsViewPage_resultsetoptions_lessthanzero, 3);
                    SQLResultsViewPage.this.setValid(false);
                    SQLResultsViewPage.this.updateApplyButton();
                } else if (tablesNum < 0) {
                    SQLResultsViewPage.this.setMessage(Messages.SQLResultsViewPage_resultsetoptions_lessthanzero, 3);
                    SQLResultsViewPage.this.setValid(false);
                    SQLResultsViewPage.this.updateApplyButton();
                } else if (maxDisplay > 500) {
                    SQLResultsViewPage.this.setMessage(Messages.SQLResultsViewPage_too_many_rows, 2);
                    SQLResultsViewPage.this.setValid(true);
                    SQLResultsViewPage.this.updateApplyButton();
                } else if (tabsNum > 100) {
                    SQLResultsViewPage.this.setMessage(Messages.SQLResultsViewPage_too_many_tabs, 2);
                    SQLResultsViewPage.this.setValid(true);
                    SQLResultsViewPage.this.updateApplyButton();
                } else if (tablesNum > 100) {
                    SQLResultsViewPage.this.setMessage(Messages.SQLResultsViewPage_too_many_tables, 2);
                    SQLResultsViewPage.this.setValid(true);
                    SQLResultsViewPage.this.updateApplyButton();
                } else if (maxDisplay > max && max != 0) {
                    SQLResultsViewPage.this.setMessage(Messages.SQLResultsViewPage_resultsetoptions_displaybiggerthanmax, 2);
                    SQLResultsViewPage.this.setValid(true);
                    SQLResultsViewPage.this.updateApplyButton();
                } else {
                    SQLResultsViewPage.this.setMessage(null);
                    SQLResultsViewPage.this.setValid(true);
                    SQLResultsViewPage.this.updateApplyButton();
                }
            }
            catch (Exception exception) {
                SQLResultsViewPage.this.setMessage(Messages.SQLResultsViewPage_resultsetoptions_invalidnumberformat, 3);
                SQLResultsViewPage.this.setValid(false);
                SQLResultsViewPage.this.updateApplyButton();
            }
        }
    };
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName());

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ResultsViewUIPlugin.getDefault().getPreferenceStore());
        this._store = this.getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)parent, (String)HelpUtil.getContextId((String)"preference_page_sql_result_view", (String)ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName()));
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        Composite topComp = new Composite(comp, 0);
        topComp.setLayoutData((Object)new GridData(768));
        FillLayout filllayout = new FillLayout();
        filllayout.spacing = 7;
        topComp.setLayout((Layout)filllayout);
        this._displayWindow = new Group(topComp, 0);
        this._displayWindow.setText(Messages.SQLResultsViewPage_displaywindow);
        layout = new GridLayout();
        this._displayWindow.setLayout((Layout)layout);
        this._singleWindow = new Button((Composite)this._displayWindow, 16);
        this._singleWindow.setText(Messages.SQLResultsViewPage_displaywindow_singlewindow);
        this._singleWindow.setToolTipText(Messages.SQLResultsViewPage_singlewindow_tooltip);
        this._singleWindow.setLayoutData((Object)new GridData());
        this._singleWindow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SQLResultsViewPage.this._singleWindow.getSelection()) {
                    SQLResultsViewPage.this._showRowCountMessage.setEnabled(true);
                    SQLResultsViewPage.this._splitMessages.setEnabled(false);
                    SQLResultsViewPage.this._limitTabs.setEnabled(false);
                    SQLResultsViewPage.this._limitTabsNum.setEnabled(false);
                    if (SQLResultsViewPage.this._gridMode.getSelection()) {
                        SQLResultsViewPage.this._limitTables.setEnabled(true);
                        SQLResultsViewPage.this._limitTablesNum.setEnabled(true);
                    } else {
                        SQLResultsViewPage.this._limitTables.setEnabled(false);
                        SQLResultsViewPage.this._limitTablesNum.setEnabled(false);
                    }
                } else {
                    SQLResultsViewPage.this._showRowCountMessage.setEnabled(false);
                    SQLResultsViewPage.this._splitMessages.setEnabled(true);
                    SQLResultsViewPage.this._limitTabs.setEnabled(true);
                    SQLResultsViewPage.this._limitTabsNum.setEnabled(true);
                }
            }
        });
        this._multiWindows = new Button((Composite)this._displayWindow, 16);
        this._multiWindows.setText(Messages.SQLResultsViewPage_displaywindow_multiplewindows);
        this._multiWindows.setToolTipText(Messages.SQLResultsViewPage_multipletabs_tooltip);
        this._multiWindows.setLayoutData((Object)new GridData());
        this._multiWindows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SQLResultsViewPage.this._multiWindows.getSelection()) {
                    SQLResultsViewPage.this._showRowCountMessage.setEnabled(false);
                    SQLResultsViewPage.this._splitMessages.setEnabled(true);
                    SQLResultsViewPage.this._limitTabs.setEnabled(true);
                    SQLResultsViewPage.this._limitTabsNum.setEnabled(true);
                    SQLResultsViewPage.this._limitTables.setEnabled(false);
                    SQLResultsViewPage.this._limitTablesNum.setEnabled(false);
                } else {
                    SQLResultsViewPage.this._showRowCountMessage.setEnabled(true);
                    SQLResultsViewPage.this._splitMessages.setEnabled(false);
                    SQLResultsViewPage.this._limitTabs.setEnabled(false);
                    SQLResultsViewPage.this._limitTabsNum.setEnabled(false);
                    SQLResultsViewPage.this._limitTables.setEnabled(true);
                    SQLResultsViewPage.this._limitTablesNum.setEnabled(true);
                }
            }
        });
        this._displayMode = new Group(topComp, 0);
        this._displayMode.setText(Messages.SQLResultsViewPage_displaymode);
        layout = new GridLayout();
        this._displayMode.setLayout((Layout)layout);
        this._textMode = new Button((Composite)this._displayMode, 16);
        this._textMode.setText(Messages.SQLResultsViewPage_displaymode_text);
        this._textMode.setToolTipText(Messages.SQLResultsViewPage_textmode_tooltip);
        this._textMode.setLayoutData((Object)new GridData());
        this._textMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SQLResultsViewPage.this._textMode.getSelection()) {
                    SQLResultsViewPage.this._showHeadings.setEnabled(true);
                    SQLResultsViewPage.this._showRowNumber.setEnabled(false);
                    SQLResultsViewPage.this._singleWindow.notifyListeners(13, new Event());
                } else {
                    SQLResultsViewPage.this._showHeadings.setEnabled(false);
                    SQLResultsViewPage.this._showRowNumber.setEnabled(true);
                }
            }
        });
        this._gridMode = new Button((Composite)this._displayMode, 16);
        this._gridMode.setText(Messages.SQLResultsViewPage_displaymode_grid);
        this._gridMode.setToolTipText(Messages.SQLResultsViewPage_girdmode_tooltip);
        this._gridMode.setLayoutData((Object)new GridData());
        this._gridMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SQLResultsViewPage.this._gridMode.getSelection()) {
                    SQLResultsViewPage.this._showHeadings.setEnabled(false);
                    SQLResultsViewPage.this._showRowNumber.setEnabled(true);
                    SQLResultsViewPage.this._singleWindow.notifyListeners(13, new Event());
                } else {
                    SQLResultsViewPage.this._showHeadings.setEnabled(true);
                    SQLResultsViewPage.this._showRowNumber.setEnabled(false);
                }
            }
        });
        Composite midComp = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        midComp.setLayout((Layout)layout);
        midComp.setLayoutData((Object)new GridData(768));
        this._resultSetOptions = new Group(midComp, 0);
        this._resultSetOptions.setLayoutData((Object)new GridData(1808));
        this._resultSetOptions.setText(Messages.SQLResultsViewPage_resultsetoptions);
        this._resultSetOptions.setLayout((Layout)new GridLayout());
        Composite buttonComp = new Composite((Composite)this._resultSetOptions, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(768));
        this._showHeadings = new Button(buttonComp, 32);
        this._showHeadings.setLayoutData((Object)new GridData());
        this._showHeadings.setText(Messages.SQLResultsViewPage_resultsetoptions_showheadings);
        this._showLabels = new Button(buttonComp, 32);
        this._showLabels.setLayoutData((Object)new GridData());
        this._showLabels.setText(Messages.SQLResultsViewPage_show_label);
        this._showLabels.setToolTipText(Messages.SQLResultsViewPage_show_label_tooltip);
        this._showRowNumber = new Button(buttonComp, 32);
        this._showRowNumber.setLayoutData((Object)new GridData());
        this._showRowNumber.setText(Messages.SQLResultsViewPage_resultsetoptions_showrownumber);
        this._showRowCountMessage = new Button(buttonComp, 32);
        this._showRowCountMessage.setLayoutData((Object)new GridData());
        this._showRowCountMessage.setText(Messages.SQLResultsViewPage_resultsetoptions_showrowcount);
        Composite textComp = new Composite((Composite)this._resultSetOptions, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        textComp.setLayout((Layout)layout);
        textComp.setLayoutData((Object)new GridData(768));
        this._maxRowCountLabel = new Label(textComp, 0);
        this._maxRowCountLabel.setText(Messages.SQLResultsViewPage_resultsetoptions_maxrowcount);
        this._maxRowCountLabel.setToolTipText(Messages.SQLResultsViewPage_resultsetoptions_maxrowcount_tooltip);
        this._maxRowCountLabel.setLayoutData((Object)new GridData());
        this._maxRowCount = new Text(textComp, 2052);
        this._maxRowCount.setToolTipText(Messages.SQLResultsViewPage_resultsetoptions_maxrowcount_tooltip);
        this._maxRowCount.setLayoutData((Object)new GridData(768));
        this._maxDisplayRowCountLabel = new Label(textComp, 0);
        this._maxDisplayRowCountLabel.setText(Messages.SQLResultsViewPage_resultsetoptions_maxdisplayrowcount);
        this._maxDisplayRowCountLabel.setToolTipText(Messages.SQLResultsViewPage_maxdisplayrows_tooltip);
        this._maxDisplayRowCountLabel.setLayoutData((Object)new GridData());
        this._maxDisplayRowCount = new Text(textComp, 2052);
        this._maxDisplayRowCount.setLayoutData((Object)new GridData(768));
        this._nullDisplayStrLabel = new Label(textComp, 0);
        this._nullDisplayStrLabel.setText(Messages.SQLResultsViewPage_resultsetoptions_nulldisplaystr);
        this._nullDisplayStrLabel.setLayoutData((Object)new GridData());
        this._nullDisplayStr = new Text(textComp, 2052);
        this._nullDisplayStr.setTextLimit(10);
        this._nullDisplayStr.setLayoutData((Object)new GridData(768));
        Composite bottomComp = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        bottomComp.setLayout((Layout)layout);
        bottomComp.setLayoutData((Object)new GridData(768));
        this._otherOptionsGrp = new Group(bottomComp, 0);
        this._otherOptionsGrp.setText(Messages.SQLResultsViewPage_other_option);
        this._otherOptionsGrp.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.numColumns = 2;
        this._otherOptionsGrp.setLayout((Layout)layout);
        this._splitMessages = new Button((Composite)this._otherOptionsGrp, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this._splitMessages.setLayoutData((Object)gd);
        this._splitMessages.setText(Messages.SQLResultsViewPage_split_message);
        this._splitMessages.setToolTipText(Messages.SQLResultsViewPage_splitmessages_tooltip);
        this._limitTabs = new Label((Composite)this._otherOptionsGrp, 0);
        this._limitTabs.setText(Messages.SQLResultsViewPage_limit_tabs);
        this._limitTabs.setToolTipText(Messages.SQLResultsViewPage_limit_tabs_tooltip);
        this._limitTabsNum = new Text((Composite)this._otherOptionsGrp, 2048);
        this._limitTabsNum.setLayoutData((Object)new GridData(768));
        this._limitTables = new Label((Composite)this._otherOptionsGrp, 0);
        this._limitTables.setText(Messages.SQLResultsViewPage_limit_tables_number);
        this._limitTables.setToolTipText(Messages.SQLResultsViewPage_limit_tables_tooltip);
        this._limitTablesNum = new Text((Composite)this._otherOptionsGrp, 2048);
        this._limitTablesNum.setLayoutData((Object)new GridData(768));
        this.initilizeValues();
        this._maxRowCount.addModifyListener(this._modifyListener);
        this._maxDisplayRowCount.addModifyListener(this._modifyListener);
        this._limitTabsNum.addModifyListener(this._modifyListener);
        this._limitTablesNum.addModifyListener(this._modifyListener);
        this._limitTablesNum.notifyListeners(24, new Event());
        this._singleWindow.notifyListeners(13, new Event());
        this._multiWindows.notifyListeners(13, new Event());
        Composite tabs = new Composite(comp, 0);
        tabs.setLayoutData((Object)new GridData(1808));
        tabs.setLayout((Layout)layout);
        super.createContents(tabs);
        return comp;
    }

    protected void performDefaults() {
        if (this._store.getDefaultInt(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_WINDOW) == 1) {
            this._singleWindow.setSelection(true);
            this._multiWindows.setSelection(false);
            this._showRowCountMessage.setEnabled(true);
            this._splitMessages.setEnabled(false);
            this._limitTabsNum.setEnabled(false);
        } else {
            this._multiWindows.setSelection(true);
            this._singleWindow.setSelection(false);
            this._showRowCountMessage.setEnabled(false);
            this._splitMessages.setEnabled(true);
            this._limitTabsNum.setEnabled(true);
        }
        if (this._store.getDefaultInt(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_MODE) == 1) {
            this._textMode.setSelection(true);
            this._gridMode.setSelection(false);
            this._gridMode.notifyListeners(13, new Event());
        } else {
            this._textMode.setSelection(false);
            this._gridMode.setSelection(true);
            this._gridMode.notifyListeners(13, new Event());
        }
        this._showHeadings.setSelection(this._store.getDefaultBoolean(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_HEADING));
        this._showRowNumber.setSelection(this._store.getDefaultBoolean(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_ROW_NUMBER));
        this._showRowCountMessage.setSelection(this._store.getDefaultBoolean(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_ROW_COUNT_MSG));
        this._maxRowCount.setText(Integer.toString(this._store.getDefaultInt(PreferenceConstants.SQL_RESULTS_VIEW_MAX_ROW_COUNT)));
        this._maxDisplayRowCount.setText(Integer.toString(this._store.getDefaultInt(PreferenceConstants.SQL_RESULTS_VIEW_MAX_DISPLAY_ROW_COUNT)));
        this._nullDisplayStr.setText(this._store.getDefaultString(PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING));
        this._splitMessages.setSelection(this._store.getDefaultBoolean(PreferenceConstants.SQL_RESULTS_VIEW_SPLIT_MESSAGES));
        this._limitTabsNum.setText(Integer.toString(this._store.getDefaultInt(PreferenceConstants.SQL_RESULTS_VIEW_TABS_NUMBER)));
        this._limitTablesNum.setText(Integer.toString(this._store.getDefaultInt(PreferenceConstants.SQL_RESULTS_VIEW_TABLES_LIMITATION)));
        this._showLabels.setSelection(this._store.getDefaultBoolean(PreferenceConstants.SQL_RESULT_VIEW_SHOW_LABELS));
        super.performDefaults();
    }

    private void initilizeValues() {
        if (this._store.getInt(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_WINDOW) == 1) {
            this._singleWindow.setSelection(true);
            this._multiWindows.setSelection(false);
            this._showRowCountMessage.setEnabled(true);
            this._splitMessages.setEnabled(false);
            this._limitTabsNum.setEnabled(false);
        } else {
            this._multiWindows.setSelection(true);
            this._singleWindow.setSelection(false);
            this._showRowCountMessage.setEnabled(false);
            this._splitMessages.setEnabled(true);
            this._limitTabsNum.setEnabled(true);
        }
        if (this._store.getInt(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_MODE) == 1) {
            this._textMode.setSelection(true);
            this._gridMode.setSelection(false);
            this._gridMode.notifyListeners(13, new Event());
        } else {
            this._textMode.setSelection(false);
            this._gridMode.setSelection(true);
            this._gridMode.notifyListeners(13, new Event());
        }
        this._showHeadings.setSelection(this._store.getBoolean(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_HEADING));
        this._showRowNumber.setSelection(this._store.getBoolean(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_ROW_NUMBER));
        this._showRowCountMessage.setSelection(this._store.getBoolean(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_ROW_COUNT_MSG));
        this._maxRowCount.setText(Integer.toString(this._store.getInt(PreferenceConstants.SQL_RESULTS_VIEW_MAX_ROW_COUNT)));
        this._maxDisplayRowCount.setText(Integer.toString(this._store.getInt(PreferenceConstants.SQL_RESULTS_VIEW_MAX_DISPLAY_ROW_COUNT)));
        this._nullDisplayStr.setText(this._store.getString(PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING));
        this._splitMessages.setSelection(this._store.getBoolean(PreferenceConstants.SQL_RESULTS_VIEW_SPLIT_MESSAGES));
        this._limitTabsNum.setText(Integer.toString(this._store.getInt(PreferenceConstants.SQL_RESULTS_VIEW_TABS_NUMBER)));
        this._limitTablesNum.setText(Integer.toString(this._store.getInt(PreferenceConstants.SQL_RESULTS_VIEW_TABLES_LIMITATION)));
        this._showLabels.setSelection(this._store.getBoolean(PreferenceConstants.SQL_RESULT_VIEW_SHOW_LABELS));
    }

    public boolean performOk() {
        if (this._singleWindow.getSelection()) {
            this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_WINDOW, 1);
        } else {
            this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_WINDOW, 2);
        }
        if (this._textMode.getSelection()) {
            this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_MODE, 1);
        } else {
            this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_MODE, 2);
        }
        this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_HEADING, this._showHeadings.getSelection());
        this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_ROW_COUNT_MSG, this._showRowCountMessage.getSelection());
        this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_ROW_NUMBER, this._showRowNumber.getSelection());
        this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_MAX_ROW_COUNT, this._maxRowCount.getText().trim());
        this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_MAX_DISPLAY_ROW_COUNT, this._maxDisplayRowCount.getText().trim());
        this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING, this._nullDisplayStr.getText());
        this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_SPLIT_MESSAGES, this._splitMessages.getSelection());
        this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_TABS_NUMBER, this._limitTabsNum.getText().trim());
        this._store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_TABLES_LIMITATION, this._limitTablesNum.getText().trim());
        this._store.setValue(PreferenceConstants.SQL_RESULT_VIEW_SHOW_LABELS, this._showLabels.getSelection());
        return super.performOk();
    }

    public String getPreferencePageId() {
        return "org.eclipse.datatools.sqltools.result.displayOption";
    }
}

