/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizardPage;
import org.eclipse.datatools.connectivity.ui.Messages;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ConnectionProfileDetailsPage
extends BaseWizardPage
implements IContextProvider {
    protected Button btnPing;
    private boolean defaultAutoConnectOnFinishFlag = true;
    private Button autoConnectOnFinishButton = null;
    private Button autoConnectOnStartupButton = null;
    private boolean _showAutoConnect = true;
    private boolean _showAutoConnectOnFinish = true;
    private boolean _showPing = true;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public ConnectionProfileDetailsPage(String name) {
        super(name);
    }

    public ConnectionProfileDetailsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_NEW_CONNECTION_PROFILE_PAGE", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        Composite composite = new Composite(container, 0);
        FillLayout flayout = new FillLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        composite.setLayout((Layout)flayout);
        GridData compositeGD = new GridData(1808);
        compositeGD.horizontalSpan = 2;
        composite.setLayoutData((Object)compositeGD);
        this.createCustomControl(composite);
        if (this._showAutoConnectOnFinish) {
            this.autoConnectOnFinishButton = new Button(container, 32);
            this.autoConnectOnFinishButton.setText(Messages.ConnectionProfileDetailsPage_Autoconnect_finish);
            this.autoConnectOnFinishButton.setLayoutData((Object)new GridData(32));
            this.autoConnectOnFinishButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ConnectionProfileDetailsPage.this.setAutoConnectFinish(ConnectionProfileDetailsPage.this.autoConnectOnFinishButton.getSelection());
                }

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }
            });
            this.autoConnectOnFinishButton.setSelection(this.defaultAutoConnectOnFinishFlag);
        }
        if (this._showPing) {
            this.btnPing = new Button(container, 0);
            this.btnPing.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionProfileDetailsPage.this.testConnection();
                }
            });
            GridData pingGD = new GridData(896);
            if (!this._showAutoConnectOnFinish) {
                pingGD.horizontalSpan = 2;
            }
            this.btnPing.setLayoutData((Object)pingGD);
            this.btnPing.setText(ConnectivityUIPlugin.getDefault().getResourceString("ConnectionProfileDetailsPage.Button.TestConnection"));
        }
        if (this._showAutoConnect) {
            this.autoConnectOnStartupButton = new Button(container, 32);
            this.autoConnectOnStartupButton.setText(Messages.ConnectionProfileDetailsPage_Autoconnect_startup);
            GridData acStartupGD = new GridData(32);
            if (!this._showPing) {
                acStartupGD.horizontalSpan = 2;
            }
            this.autoConnectOnStartupButton.setLayoutData((Object)acStartupGD);
            this.autoConnectOnStartupButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ConnectionProfileDetailsPage.this.setAutoConnect(ConnectionProfileDetailsPage.this.autoConnectOnStartupButton.getSelection());
                }

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }
            });
        }
        if (this.getWizard() instanceof NewConnectionProfileWizard) {
            NewConnectionProfileWizard wiz = (NewConnectionProfileWizard)this.getWizard();
            wiz.getProfilePage().setAutoConnectOnFinish(this.defaultAutoConnectOnFinishFlag);
        }
    }

    public abstract void createCustomControl(Composite var1);

    protected void testConnection() {
        IWizard wiz = this.getWizard();
        if (wiz instanceof NewConnectionProfileWizard) {
            NewConnectionProfileWizard wizard = (NewConnectionProfileWizard)wiz;
            ConnectionProfile profile = new ConnectionProfile(wizard.getProfileName(), wizard.getProfileDescription(), wizard.getProfileProviderID(), wizard.getParentProfile(), wizard.getProfileIsAutoConnect());
            if (this.getErrorMessage() != null) {
                MessageDialog.openError((Shell)this.getWizard().getContainer().getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"), (String)this.getErrorMessage());
                return;
            }
            profile.setBaseProperties(wizard.getProfileProperties());
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)this.createTestConnectionRunnable((IConnectionProfile)profile));
        }
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected void setPingButtonEnabled(boolean enabled) {
        if (this.btnPing != null && !this.btnPing.isDisposed()) {
            this.btnPing.setEnabled(enabled);
        }
    }

    protected void setPingButtonVisible(boolean visible) {
        if (this.btnPing != null && !this.btnPing.isDisposed()) {
            this.btnPing.setVisible(visible);
        }
    }

    protected Runnable createTestConnectionRunnable(IConnectionProfile profile) {
        final PingJob pingJob = new PingJob(this.getShell(), profile);
        pingJob.schedule();
        return new Runnable(){

            public void run() {
                try {
                    pingJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
    }

    private void setAutoConnectFinish(boolean flag) {
        if (this.getWizard() instanceof NewConnectionProfileWizard) {
            NewConnectionProfileWizard wiz = (NewConnectionProfileWizard)this.getWizard();
            wiz.getProfilePage().setAutoConnectOnFinish(flag);
        }
    }

    private void setAutoConnect(boolean flag) {
        if (this.getWizard() instanceof NewConnectionProfileWizard) {
            NewConnectionProfileWizard wiz = (NewConnectionProfileWizard)this.getWizard();
            wiz.getProfilePage().setAutoConnect(flag);
        }
    }

    protected void setAutoConnectOnFinishDefault(boolean flag) {
        this.defaultAutoConnectOnFinishFlag = flag;
    }

    protected boolean getAutoConnectOnFinishDefault() {
        return this.defaultAutoConnectOnFinishFlag;
    }

    protected void setShowAutoConnectOnFinish(boolean flag) {
        this._showAutoConnectOnFinish = flag;
    }

    protected void setShowAutoConnect(boolean flag) {
        this._showAutoConnect = flag;
    }

    protected void setShowPing(boolean flag) {
        this._showPing = flag;
    }
}

