/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.preferences;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.XMLFileManager;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.DriversProvider;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DriverTableFilter;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeSorter;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.AbstractInvertableTableSorter;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.CategoryDescriptorNameComparator;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.CategoryUtils;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.DriverDialog;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.DriverListContentProvider;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.DriverListLabelProvider;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.TableSortSelectionListener;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DriverPreferences
extends PreferencePage
implements IWorkbenchPreferencePage,
IContextProvider {
    private static String ALL_STRING = DriverMgmtMessages.getString((String)"DriverDialog.AllFilter");
    private Button mAddButton;
    private Button mRemoveButton;
    private Button mEditButton;
    private Button mCopyButton;
    private TableViewer mTableViewer;
    private Combo mTypeCombo;
    private Combo mVendorCombo;
    private Action mAddAction;
    private Action mRemoveAction;
    private Action mEditAction;
    private Action mCopyAction;
    private boolean mDirty = false;
    private DriverTableFilter mViewerFilter;
    private DriverTableFilter mTypeFilter;
    private DriverTableFilter mVendorFilter;
    private IPropertySet selectedPS = null;
    private String mMessage = null;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public DriverPreferences() {
        this.noDefaultAndApplyButton();
    }

    public DriverPreferences(String title) {
        super(title);
        this.noDefaultAndApplyButton();
    }

    public DriverPreferences(String title, ImageDescriptor image) {
        super(title, image);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        this.mMessage = this.getMessage();
        Font font = parent.getFont();
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        content.setLayoutData((Object)data);
        content.setFont(font);
        Composite comboComposite = new Composite(content, 0);
        GridLayout combolayout = new GridLayout(2, false);
        combolayout.marginWidth = 0;
        combolayout.marginHeight = 0;
        comboComposite.setLayout((Layout)combolayout);
        GridData CCdata = new GridData();
        CCdata.horizontalAlignment = 4;
        CCdata.horizontalSpan = 2;
        comboComposite.setLayoutData((Object)CCdata);
        CategoryDescriptor[] roots = CategoryUtils.getOrderedRootCategories();
        if (this.mViewerFilter != null) {
            roots = new CategoryDescriptor[]{this.mViewerFilter.getCategoryDescriptor()};
        }
        if (roots != null && roots.length > 1) {
            Label tlabel = new Label(comboComposite, 16384);
            tlabel.setText(DriverMgmtMessages.getString((String)"DriverPreferences.DriverTypeFilter"));
            tlabel.setLayoutData((Object)new GridData());
            this.mTypeCombo = new Combo(comboComposite, 2056);
            this.mTypeCombo.setLayoutData((Object)new GridData(4, 0, true, false));
            this.mTypeCombo.add(ALL_STRING);
            this.mTypeCombo.setData(ALL_STRING, (Object)roots);
            int i = 0;
            while (i < roots.length) {
                this.mTypeCombo.add(roots[i].getName());
                this.mTypeCombo.setData(roots[i].getName(), (Object)roots[i]);
                ++i;
            }
            this.mTypeCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    DriverPreferences.this.handleTypeSelection();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }
            });
        }
        if (roots[0].getParent() == null || roots[0].getParent().getParent() != null) {
            Label vLabel = new Label(comboComposite, 16384);
            vLabel.setText(DriverMgmtMessages.getString((String)"DriverPreferences.VendorFilter"));
            vLabel.setLayoutData((Object)new GridData());
            this.mVendorCombo = new Combo(comboComposite, 2056);
            this.mVendorCombo.setLayoutData((Object)new GridData(4, 0, true, false));
            this.mVendorCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    DriverPreferences.this.handleVendorSelection();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }
            });
            if (roots != null && roots.length == 1) {
                CategoryDescriptor[] children = CategoryUtils.getOrderedChildCategories(roots[0].getId());
                if (children != null && children.length > 0) {
                    this.mVendorCombo.add(ALL_STRING);
                    int i = 0;
                    while (i < children.length) {
                        this.mVendorCombo.add(children[i].getName());
                        this.mVendorCombo.setData(children[i].getName(), (Object)children[i]);
                        ++i;
                    }
                } else {
                    this.mVendorCombo.setEnabled(false);
                }
            }
        }
        this.mTableViewer = new TableViewer(content, 67584);
        data = new GridData(1808);
        this.mTableViewer.getTable().setLayoutData((Object)data);
        this.mTableViewer.getTable().setFont(font);
        this.mTableViewer.getTable().setHeaderVisible(true);
        this.makeActions();
        this.hookContextMenu();
        TableSortSelectionListener tssl1 = DriverPreferences.createTableColumn(this.mTableViewer, DriverMgmtMessages.getString((String)"DriverPreferences.NameColumn"), DriverMgmtMessages.getString((String)"DriverPreferences.DriverNameColumn"), new TextSorter(0), 128, false);
        tssl1.getColumn().setWidth(200);
        tssl1.getColumn().setResizable(true);
        tssl1.chooseColumnForSorting();
        TableSortSelectionListener tssl2 = DriverPreferences.createTableColumn(this.mTableViewer, DriverMgmtMessages.getString((String)"DriverPreferences.VendorColumn"), DriverMgmtMessages.getString((String)"DriverPreferences.DriverVendorColumn"), new TextSorter(1), 128, true);
        tssl2.getColumn().setWidth(200);
        tssl2.getColumn().setResizable(true);
        TableSortSelectionListener tssl3 = DriverPreferences.createTableColumn(this.mTableViewer, DriverMgmtMessages.getString((String)"DriverPreferences.VersionColumn"), DriverMgmtMessages.getString((String)"DriverPreferences.DriverVersionColumn"), new TextSorter(2), 128, false);
        tssl3.getColumn().setWidth(100);
        tssl3.getColumn().setResizable(true);
        this.mTableViewer.setContentProvider((IContentProvider)new DriverListContentProvider());
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new DriverListLabelProvider());
        this.mTableViewer.setSorter((ViewerSorter)new DriverTreeSorter());
        if (this.mViewerFilter != null) {
            this.mTableViewer.addFilter((ViewerFilter)this.mViewerFilter);
        }
        this.mTableViewer.setInput((Object)DriversProvider.getInstance());
        this.mTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DriverPreferences.this.setMessage(DriverPreferences.this.mMessage);
                DriverPreferences.this.setErrorMessage(null);
                DriverPreferences.this.selectedPS = null;
                StructuredSelection selection = (StructuredSelection)DriverPreferences.this.mTableViewer.getSelection();
                DriverPreferences.this.updateButtons(selection.getFirstElement());
            }
        });
        this.mTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)DriverPreferences.this.mTableViewer.getSelection();
                DriverPreferences.this.editDriver((ISelection)selection);
            }
        });
        Composite groupComponent = new Composite(content, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(font);
        this.mAddButton = new Button(groupComponent, 8);
        this.mAddButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.addDriver"));
        this.mAddButton.setLayoutData((Object)data);
        this.mAddButton.setFont(font);
        this.setButtonLayoutData(this.mAddButton);
        this.mAddButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DriverPreferences.this.addDriver(DriverPreferences.this.mTableViewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mEditButton = new Button(groupComponent, 8);
        this.mEditButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.editDriver"));
        this.mEditButton.setLayoutData((Object)data);
        this.mEditButton.setFont(font);
        this.setButtonLayoutData(this.mEditButton);
        this.mEditButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DriverPreferences.this.editDriver(DriverPreferences.this.mTableViewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mRemoveButton = new Button(groupComponent, 8);
        this.mRemoveButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.removeDriver"));
        this.mRemoveButton.setLayoutData((Object)data);
        this.mRemoveButton.setFont(font);
        this.setButtonLayoutData(this.mRemoveButton);
        this.mRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DriverPreferences.this.removeDriver(DriverPreferences.this.mTableViewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mCopyButton = new Button(groupComponent, 8);
        this.mCopyButton.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.copyDriver"));
        this.mCopyButton.setLayoutData((Object)data);
        this.mCopyButton.setFont(font);
        this.setButtonLayoutData(this.mCopyButton);
        this.mCopyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DriverPreferences.this.copyDriver(DriverPreferences.this.mTableViewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (CategoryDescriptor.getRootCategories() != null && CategoryDescriptor.getRootCategories().length > 0) {
            this.mTableViewer.setSelection((ISelection)new StructuredSelection((Object)CategoryDescriptor.getRootCategories()[0]));
        }
        if (this.mTypeCombo != null) {
            this.mTypeCombo.select(0);
            this.handleTypeSelection();
        }
        if (this.mVendorCombo != null && this.mVendorCombo.getItemCount() > 0) {
            this.mVendorCombo.select(0);
            this.handleVendorSelection();
        }
        this.updateButtons(null);
        return content;
    }

    private void updateButtons(Object selection) {
        this.mAddButton.setEnabled(true);
        if (selection instanceof IPropertySet) {
            this.mRemoveAction.setEnabled(true);
            this.mEditAction.setEnabled(true);
            this.mCopyAction.setEnabled(true);
            this.mRemoveButton.setEnabled(true);
            this.mEditButton.setEnabled(true);
            this.mCopyButton.setEnabled(true);
            this.selectedPS = (IPropertySet)selection;
            if (this.selectedPS != null) {
                this.validate(this.selectedPS);
            }
        } else {
            this.mRemoveAction.setEnabled(false);
            this.mEditAction.setEnabled(false);
            this.mCopyAction.setEnabled(false);
            this.mRemoveButton.setEnabled(false);
            this.mEditButton.setEnabled(false);
            this.mCopyButton.setEnabled(false);
        }
    }

    private void addDriver(ISelection selection) {
        DriverDialog ddtt = new DriverDialog(this.getShell());
        ddtt.setEditMode(false);
        ddtt.setVendorFilter(this.mVendorFilter);
        ddtt.setTypeFilter(this.mTypeFilter);
        int rtn_code = ddtt.open();
        if (rtn_code != 0) {
            return;
        }
        DriverManager.getInstance().addDriverInstance(ddtt.getPropertySet());
        this.mTableViewer.getControl().setRedraw(false);
        this.mTableViewer.setInput((Object)DriversProvider.getInstance());
        this.mTableViewer.refresh();
        this.mDirty = true;
        DriverInstance instance = DriverManager.getInstance().getDriverInstanceByName(ddtt.getPropertySet().getName());
        this.mTableViewer.setSelection((ISelection)new StructuredSelection((Object)instance.getPropertySet()), true);
        this.mTableViewer.getControl().setRedraw(true);
    }

    private void editDriver(ISelection selection) {
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof IPropertySet) {
            IPropertySet instance = (IPropertySet)sselection.getFirstElement();
            IPropertySet copy = this.duplicatePropertySet(instance);
            DriverDialog dlg = new DriverDialog(this.getShell());
            dlg.setEditMode(true);
            dlg.setPropertySet(copy);
            if (dlg.open() == 0) {
                copy = dlg.getPropertySet();
                this.copyPropertySet(copy, instance);
                DriverManager.getInstance().removeDriverInstance(instance.getID());
                System.gc();
                DriverManager.getInstance().addDriverInstance(copy);
                this.mDirty = true;
                this.mTableViewer.refresh();
                this.validate(instance);
            }
        }
    }

    private void removeDriver(ISelection selection) {
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof IPropertySet) {
            IPropertySet instance = (IPropertySet)sselection.getFirstElement();
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)DriverMgmtMessages.getString((String)"DriverPreferences.title.removeMessage"), (String)DriverMgmtMessages.format((String)"DriverPreferences.text.removeMessage", (Object[])new String[]{instance.getName()}))) {
                int selIndex = this.mTableViewer.getTable().getSelectionIndex();
                DriverManager.getInstance().removeDriverInstance(instance.getID());
                this.mTableViewer.refresh();
                if (selIndex < this.mTableViewer.getTable().getItemCount() && selIndex > -1) {
                    Object obj = this.mTableViewer.getTable().getItem(selIndex).getData();
                    StructuredSelection ssel = new StructuredSelection(obj);
                    this.mTableViewer.setSelection((ISelection)ssel, true);
                } else if (selIndex - 1 > -1 && this.mTableViewer.getTable().getItem(--selIndex) != null) {
                    Object obj = this.mTableViewer.getTable().getItem(selIndex).getData();
                    StructuredSelection ssel = new StructuredSelection(obj);
                    this.mTableViewer.setSelection((ISelection)ssel, true);
                }
                this.mDirty = true;
            }
        }
    }

    private void copyDriver(ISelection selection) {
        IPropertySet instance;
        StructuredSelection sselection = (StructuredSelection)selection;
        if (sselection.getFirstElement() instanceof IPropertySet && (instance = (IPropertySet)sselection.getFirstElement()) != null) {
            IPropertySet cloned = (IPropertySet)((PropertySetImpl)instance).clone();
            String copyPrefix = DriverMgmtMessages.getString((String)"PropertySetImpl.copy_prefix");
            String copyIdSuffix = DriverMgmtMessages.getString((String)"PropertySetImpl.copy_id_suffix");
            String name = String.valueOf(copyPrefix) + instance.getName();
            String id = String.valueOf(instance.getID()) + copyIdSuffix;
            cloned.setID(id);
            cloned.setName(name);
            DriverManager.getInstance().addDriverInstance(cloned);
            this.mTableViewer.refresh();
            this.mDirty = true;
            this.mTableViewer.setSelection((ISelection)new StructuredSelection((Object)cloned));
        }
    }

    private void makeActions() {
        this.mAddAction = new AddAction();
        this.mAddAction.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.addDriver"));
        this.mEditAction = new EditAction();
        this.mEditAction.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.editDriver"));
        this.mRemoveAction = new RemoveAction();
        this.mRemoveAction.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.removeDriver"));
        this.mCopyAction = new CopyAction();
        this.mCopyAction.setText(DriverMgmtMessages.getString((String)"DriverPreferences.button.copyDriver"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)DriverPreferences.this.mAddAction);
                manager.add((IAction)DriverPreferences.this.mEditAction);
                manager.add((IAction)DriverPreferences.this.mRemoveAction);
                manager.add((IAction)DriverPreferences.this.mCopyAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.mTableViewer.getControl());
        this.mTableViewer.getControl().setMenu(menu);
    }

    private void validate(IPropertySet instance) {
        TemplateDescriptor template;
        this.setMessage(this.mMessage);
        this.setErrorMessage(null);
        String driverType = instance.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
        if (driverType != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
            DriverValidator validator = new DriverValidator(template, instance);
            String mErrorMessage = "";
            if (!validator.isValid()) {
                mErrorMessage = validator.getMessage();
                this.setErrorMessage(mErrorMessage);
            }
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        if (this.mDirty) {
            this.saveChanges();
        }
        super.performApply();
    }

    private void saveChanges() {
        XMLFileManager.setFileName((String)"driverStorage.xml");
        List psetsList = ((DriverListContentProvider)this.mTableViewer.getContentProvider()).getDriverInstances();
        Object[] objs = psetsList.toArray();
        IPropertySet[] propsets = new IPropertySet[objs.length];
        int i = 0;
        while (i < objs.length) {
            propsets[i] = (IPropertySet)objs[i];
            ++i;
        }
        try {
            XMLFileManager.saveNamedPropertySet((IPropertySet[])propsets);
        }
        catch (CoreException e) {
            ConnectivityUIPlugin.getDefault().log(e);
        }
        this.mDirty = false;
    }

    public boolean performOk() {
        if (this.mDirty) {
            this.saveChanges();
        }
        return super.performOk();
    }

    private IPropertySet duplicatePropertySet(IPropertySet pset) {
        PropertySetImpl newPset = new PropertySetImpl(pset.getName(), pset.getID());
        if (pset.getBaseProperties().size() > 0) {
            Properties newProps = new Properties();
            newPset.setBaseProperties(newProps);
            newPset.getBaseProperties().putAll((Map<?, ?>)pset.getBaseProperties());
        }
        return newPset;
    }

    private void copyPropertySet(IPropertySet fromPset, IPropertySet topset) {
        topset.setID(fromPset.getID());
        topset.setName(fromPset.getName());
        if (topset.getBaseProperties().size() > 0) {
            topset.getBaseProperties().putAll((Map<?, ?>)fromPset.getBaseProperties());
        }
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_DRIVER_PREFERENCES", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public static TableSortSelectionListener createTableColumn(TableViewer viewer, String text, String tooltip, AbstractInvertableTableSorter sorter, int initialDirection, boolean keepDirection) {
        TableColumn column = new TableColumn(viewer.getTable(), 16384);
        column.setText(text);
        column.setToolTipText(tooltip);
        return new TableSortSelectionListener(viewer, column, sorter, initialDirection, keepDirection);
    }

    private void handleTypeSelection() {
        if (this.mTableViewer != null && !this.mTableViewer.getTable().isDisposed()) {
            this.mTableViewer.getTable().setRedraw(false);
        }
        if (this.mTypeCombo == null) {
            return;
        }
        if (this.mTypeFilter != null && this.mTableViewer != null) {
            this.mTableViewer.removeFilter((ViewerFilter)this.mTypeFilter);
        }
        this.mVendorCombo.removeAll();
        if (this.mTypeCombo.getSelectionIndex() > -1) {
            String selectedText = this.mTypeCombo.getText().trim();
            if (selectedText.length() > 0) {
                Object data = this.mTypeCombo.getData(selectedText);
                CategoryDescriptor[] kids = null;
                if (data instanceof CategoryDescriptor) {
                    CategoryDescriptor cd = (CategoryDescriptor)data;
                    this.mTypeFilter = new DriverTableFilter();
                    this.mTypeFilter.setCategoryId(cd.getId());
                    this.mTableViewer.addFilter((ViewerFilter)this.mTypeFilter);
                    this.mTableViewer.refresh();
                    kids = CategoryUtils.getOrderedChildCategories(cd.getId());
                } else if (data instanceof CategoryDescriptor[]) {
                    kids = (CategoryDescriptor[])data;
                    Arrays.sort(kids, new CategoryDescriptorNameComparator());
                }
                if (kids != null && !selectedText.equals(ALL_STRING)) {
                    this.mVendorCombo.add(ALL_STRING);
                    int j = 0;
                    while (j < kids.length) {
                        this.mVendorCombo.add(kids[j].getName());
                        this.mVendorCombo.setData(kids[j].getName(), (Object)kids[j]);
                        ++j;
                    }
                    if (this.mVendorCombo.getItemCount() == 0) {
                        this.mVendorCombo.setEnabled(false);
                    }
                } else {
                    this.mVendorCombo.add(ALL_STRING);
                    int j = 0;
                    while (j < kids.length) {
                        CategoryDescriptor[] details = CategoryUtils.getOrderedChildCategories(kids[j].getId());
                        if (details != null && details.length > 0) {
                            int i = 0;
                            while (i < details.length) {
                                this.mVendorCombo.add(details[i].getName());
                                this.mVendorCombo.setData(details[i].getName(), (Object)details[i]);
                                ++i;
                            }
                        }
                        ++j;
                    }
                    if (this.mVendorCombo.getItemCount() == 0) {
                        this.mVendorCombo.setEnabled(false);
                    }
                }
                this.mVendorCombo.select(0);
            }
        } else {
            this.mVendorCombo.setEnabled(false);
        }
        if (this.mTableViewer != null && !this.mTableViewer.getTable().isDisposed()) {
            this.mTableViewer.getTable().setRedraw(true);
        }
    }

    private void handleVendorSelection() {
        if (this.mTableViewer != null && !this.mTableViewer.getTable().isDisposed()) {
            this.mTableViewer.getTable().setRedraw(false);
        }
        if (this.mVendorCombo == null) {
            return;
        }
        if (this.mTypeFilter != null && this.mTableViewer != null) {
            this.mTableViewer.removeFilter((ViewerFilter)this.mTypeFilter);
        }
        if (this.mTableViewer != null && this.mVendorCombo != null && this.mVendorCombo.getText().trim().length() > 0) {
            Object data;
            String selectedText;
            String selText = this.mVendorCombo.getText().trim();
            if (!selText.equalsIgnoreCase(ALL_STRING)) {
                CategoryDescriptor cd = (CategoryDescriptor)this.mVendorCombo.getData(selText);
                if (cd != null) {
                    this.mTypeFilter = new DriverTableFilter(false);
                    this.mTypeFilter.setCategoryId(cd.getId());
                    this.mTableViewer.addFilter((ViewerFilter)this.mTypeFilter);
                    this.mTableViewer.refresh();
                }
            } else if (this.mTypeCombo != null && (selectedText = this.mTypeCombo.getText().trim()).length() > 0 && (data = this.mTypeCombo.getData(selectedText)) instanceof CategoryDescriptor) {
                CategoryDescriptor cd = (CategoryDescriptor)data;
                this.mTypeFilter = new DriverTableFilter();
                this.mTypeFilter.setCategoryId(cd.getId());
                this.mTableViewer.addFilter((ViewerFilter)this.mTypeFilter);
                this.mTableViewer.refresh();
            }
        }
        if (this.mTableViewer != null && !this.mTableViewer.getTable().isDisposed()) {
            this.mTableViewer.getTable().setRedraw(true);
        }
    }

    private class AddAction
    extends Action {
        private AddAction() {
        }

        public void run() {
            DriverPreferences.this.addDriver(DriverPreferences.this.mTableViewer.getSelection());
        }
    }

    private class CopyAction
    extends Action {
        private CopyAction() {
        }

        public void run() {
            DriverPreferences.this.copyDriver(DriverPreferences.this.mTableViewer.getSelection());
        }
    }

    private class EditAction
    extends Action {
        private EditAction() {
        }

        public void run() {
            DriverPreferences.this.editDriver(DriverPreferences.this.mTableViewer.getSelection());
        }
    }

    private class RemoveAction
    extends Action {
        private RemoveAction() {
        }

        public void run() {
            DriverPreferences.this.removeDriver(DriverPreferences.this.mTableViewer.getSelection());
        }
    }

    private class TextSorter
    extends AbstractInvertableTableSorter {
        private int mColumn = -1;

        public TextSorter(int column) {
            this.mColumn = column;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            TableViewer tv;
            if (viewer instanceof TableViewer && (tv = (TableViewer)viewer).getLabelProvider() instanceof DriverListLabelProvider) {
                DriverListLabelProvider dtlp = (DriverListLabelProvider)tv.getLabelProvider();
                String text1 = dtlp.getColumnText(e1, this.mColumn);
                String text2 = dtlp.getColumnText(e2, this.mColumn);
                if (text1 == null) {
                    text1 = "";
                }
                if (text2 == null) {
                    text2 = "";
                }
                return Collator.getInstance().compare(text1, text2);
            }
            return Collator.getInstance().compare((String)e1, (String)e2);
        }
    }
}

