/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.tasks.bugs.AbstractSupportHandler;
import org.eclipse.mylyn.internal.provisional.tasks.bugs.ISupportResponse;
import org.eclipse.mylyn.internal.provisional.tasks.bugs.ITaskContribution;
import org.eclipse.mylyn.internal.tasks.bugs.DefaultSupportHandler;
import org.eclipse.mylyn.internal.tasks.bugs.SupportRequest;

public class SupportHandlerManager {
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_TASK_HANDLER = "handler";
    private static final String EXTENSION_ID_TASK_CONTRIBUTORS = "org.eclipse.mylyn.tasks.bugs.support";
    private final DefaultSupportHandler defaultSupportHandler = new DefaultSupportHandler();
    private boolean readExtensions;
    private final List<AbstractSupportHandler> taskContributors = new CopyOnWriteArrayList<AbstractSupportHandler>();

    public void addErrorReporter(AbstractSupportHandler taskContributor) {
        this.taskContributors.add(taskContributor);
    }

    public void process(final ITaskContribution contribution, final IProgressMonitor monitor) {
        this.readExtensions();
        for (final AbstractSupportHandler contributor : this.taskContributors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Task contributor failed", e));
                }

                public void run() throws Exception {
                    contributor.process(contribution, monitor);
                }
            });
            if (contribution.isHandled()) break;
        }
        if (!contribution.isHandled()) {
            this.defaultSupportHandler.process(contribution, monitor);
        }
    }

    public void postProcess(final ISupportResponse response, final IProgressMonitor monitor) {
        this.readExtensions();
        for (final AbstractSupportHandler contributor : this.taskContributors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Task contributor failed", e));
                }

                public void run() throws Exception {
                    contributor.postProcess(response, monitor);
                }
            });
        }
        this.defaultSupportHandler.postProcess(response, monitor);
    }

    public void preProcess(final SupportRequest request) {
        this.readExtensions();
        for (final AbstractSupportHandler contributor : this.taskContributors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Task contributor failed", e));
                }

                public void run() throws Exception {
                    contributor.preProcess(request);
                }
            });
        }
        this.defaultSupportHandler.preProcess(request);
    }

    private synchronized void readExtensions() {
        IExtension[] extensions;
        if (this.readExtensions) {
            return;
        }
        this.readExtensions = true;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_TASK_CONTRIBUTORS);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(ELEMENT_TASK_HANDLER)) {
                    this.readTaskContributor(element);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void readTaskContributor(IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension(ELEMENT_CLASS);
            if (object instanceof AbstractSupportHandler) {
                this.taskContributors.add((AbstractSupportHandler)object);
            } else {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", "Could not load task contributor extenstion: \"" + object.getClass().getCanonicalName() + "\"" + " does not implement \"" + AbstractSupportHandler.class.getCanonicalName() + "\""));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", "Could not load task contributor extension", e));
        }
    }

    public void removeErrorReporter(AbstractSupportHandler taskContributor) {
        this.taskContributors.remove(taskContributor);
    }
}

