/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.RepositoryPerson;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskRepository
extends PlatformObject {
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private static final String USERNAME = ".username";
    private static final String PASSWORD = ".password";
    private static final String SAVE_PASSWORD = ".savePassword";
    private static final String ENABLED = ".enabled";
    private static final String AUTH_REPOSITORY = "org.eclipse.mylyn.tasklist.repositories";
    private IStatus errorStatus = null;
    @Deprecated
    public static final String AUTH_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.password";
    @Deprecated
    public static final String AUTH_USERNAME = "org.eclipse.mylyn.tasklist.repositories.username";
    @Deprecated
    public static final String ANONYMOUS_LOGIN = "org.eclipse.mylyn.tasklist.repositories.anonymous";
    private static final String AUTH_HTTP = "org.eclipse.mylyn.tasklist.repositories.httpauth";
    @Deprecated
    public static final String AUTH_HTTP_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.httpauth.password";
    @Deprecated
    public static final String AUTH_HTTP_USERNAME = "org.eclipse.mylyn.tasklist.repositories.httpauth.username";
    public static final String NO_VERSION_SPECIFIED = "unknown";
    private static final String AUTH_SCHEME = "Basic";
    private static final String AUTH_REALM = "";
    private static final URL DEFAULT_URL;
    private static final String PROPERTY_CONFIG_TIMESTAMP = "org.eclipse.mylyn.tasklist.repositories.configuration.timestamp";
    public static final String PROXY_USEDEFAULT = "org.eclipse.mylyn.tasklist.repositories.proxy.usedefault";
    public static final String PROXY_HOSTNAME = "org.eclipse.mylyn.tasklist.repositories.proxy.hostname";
    public static final String PROXY_PORT = "org.eclipse.mylyn.tasklist.repositories.proxy.port";
    private static final String AUTH_PROXY = "org.eclipse.mylyn.tasklist.repositories.proxy";
    @Deprecated
    public static final String PROXY_USERNAME = "org.eclipse.mylyn.tasklist.repositories.proxy.username";
    @Deprecated
    public static final String PROXY_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.proxy.password";
    public static final String OFFLINE = "org.eclipse.mylyn.tasklist.repositories.offline";
    private static final Object LOCK;
    private final Set<PropertyChangeListener> propertyChangeListeners = new HashSet<PropertyChangeListener>();
    private static Map<String, Map<String, String>> credentials;
    private boolean isCachedUserName;
    private String cachedUserName;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Map<String, String> transientProperties = new HashMap<String, String>();
    private boolean isBugRepository = false;
    private volatile transient boolean updating;

    static {
        LOCK = new Object();
        credentials = new HashMap<String, Map<String, String>>();
        URL url = null;
        try {
            url = new URL("http://eclipse.org/mylyn");
        }
        catch (Exception exception) {}
        DEFAULT_URL = url;
    }

    private static String getKeyPrefix(AuthenticationType type) {
        switch (type) {
            case HTTP: {
                return AUTH_HTTP;
            }
            case PROXY: {
                return AUTH_PROXY;
            }
            case REPOSITORY: {
                return AUTH_REPOSITORY;
            }
        }
        throw new IllegalArgumentException("Unknown authentication type: " + type);
    }

    public TaskRepository(String connectorKind, String repositoryUrl) {
        this(connectorKind, repositoryUrl, NO_VERSION_SPECIFIED);
    }

    @Deprecated
    public TaskRepository(String kind, String serverUrl, Map<String, String> properties) {
        this.setProperty("kind", kind);
        this.setProperty("url", serverUrl);
        this.properties.putAll(properties);
        this.setProperty(PROXY_USEDEFAULT, new Boolean(true).toString());
    }

    @Deprecated
    public TaskRepository(String kind, String serverUrl, String version) {
        this(kind, serverUrl, version, DEFAULT_CHARACTER_ENCODING, TimeZone.getDefault().getID());
    }

    @Deprecated
    public TaskRepository(String connectorKind, String repositoryUrl, String version, String encoding, String timeZoneId) {
        Assert.isNotNull((Object)connectorKind);
        Assert.isNotNull((Object)repositoryUrl);
        this.setProperty("kind", connectorKind);
        this.setProperty("url", repositoryUrl);
        this.setProperty("version", version);
        this.setProperty("encoding", encoding);
        this.setProperty("timezone", timeZoneId);
        this.setProperty(PROXY_USEDEFAULT, new Boolean(true).toString());
        this.setProperty("org.eclipse.mylyn.tasklist.repositories.savePassword", String.valueOf(true));
        this.setProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.savePassword", String.valueOf(true));
        this.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.savePassword", String.valueOf(true));
    }

    private ISecurePreferences getSecurePreferences() {
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault().node("org.eclipse.mylyn.tasks.core");
        securePreferences = securePreferences.node(EncodingUtils.encodeSlashes((String)this.getRepositoryUrl()));
        return securePreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAuthInfo(String username, String password, String userProperty, String passwordProperty) {
        Object object = LOCK;
        synchronized (object) {
            if (Platform.isRunning()) {
                if (this.useSecureStorage()) {
                    try {
                        ISecurePreferences securePreferences = this.getSecurePreferences();
                        if (userProperty.equals(String.valueOf(TaskRepository.getKeyPrefix(AuthenticationType.REPOSITORY)) + USERNAME)) {
                            this.setProperty(userProperty, username);
                        } else {
                            securePreferences.put(userProperty, username, false);
                        }
                        securePreferences.put(passwordProperty, password, true);
                    }
                    catch (StorageException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not store authorization credentials", (Throwable)e));
                    }
                } else {
                    Map<String, String> map = this.getAuthInfo();
                    if (map == null) {
                        map = new HashMap<String, String>();
                    }
                    try {
                        try {
                            map.put(userProperty, username);
                            map.put(passwordProperty, password);
                            Platform.addAuthorizationInfo((URL)new URL(this.getRepositoryUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME, map);
                        }
                        catch (MalformedURLException malformedURLException) {
                            Platform.addAuthorizationInfo((URL)DEFAULT_URL, (String)this.getRepositoryUrl(), (String)AUTH_SCHEME, map);
                        }
                    }
                    catch (CoreException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not set authorization credentials", (Throwable)e));
                    }
                }
            } else {
                Map<String, String> headlessCreds = credentials.get(this.getRepositoryUrl());
                if (headlessCreds == null) {
                    headlessCreds = new HashMap<String, String>();
                    credentials.put(this.getRepositoryUrl(), headlessCreds);
                }
                headlessCreds.put(userProperty, username);
                headlessCreds.put(passwordProperty, password);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getAuthInfo() {
        Object object = LOCK;
        synchronized (object) {
            if (Platform.isRunning()) {
                try {
                    return Platform.getAuthorizationInfo((URL)new URL(this.getRepositoryUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME);
                }
                catch (MalformedURLException malformedURLException) {
                    return Platform.getAuthorizationInfo((URL)DEFAULT_URL, (String)this.getRepositoryUrl(), (String)AUTH_SCHEME);
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not retrieve authorization credentials", (Throwable)e));
                }
            } else {
                Map<String, String> headlessCreds = credentials.get(this.getRepositoryUrl());
                if (headlessCreds == null) {
                    headlessCreds = new HashMap<String, String>();
                    credentials.put(this.getRepositoryUrl(), headlessCreds);
                }
                return headlessCreds;
            }
            return null;
        }
    }

    @Deprecated
    public void clearCredentials() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TaskRepository) {
            TaskRepository repository = (TaskRepository)((Object)object);
            return this.getConnectorKind().equals(repository.getConnectorKind()) && this.getRepositoryUrl().equals(repository.getRepositoryUrl());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAuthenticationCredentials() {
        this.setProperty(String.valueOf(TaskRepository.getKeyPrefix(AuthenticationType.HTTP)) + ENABLED, null);
        this.setProperty(String.valueOf(TaskRepository.getKeyPrefix(AuthenticationType.PROXY)) + ENABLED, null);
        this.setProperty(String.valueOf(TaskRepository.getKeyPrefix(AuthenticationType.REPOSITORY)) + ENABLED, null);
        Object object = LOCK;
        synchronized (object) {
            this.isCachedUserName = false;
            this.transientProperties.clear();
            if (Platform.isRunning()) {
                if (this.useSecureStorage()) {
                    if (Platform.isRunning()) {
                        ISecurePreferences securePreferences = this.getSecurePreferences();
                        securePreferences.removeNode();
                        this.setProperty(AuthenticationType.REPOSITORY + USERNAME, AUTH_REALM);
                    } else {
                        Map<String, String> headlessCreds = credentials.get(this.getRepositoryUrl());
                        if (headlessCreds != null) {
                            headlessCreds.clear();
                        }
                    }
                } else {
                    try {
                        try {
                            Platform.flushAuthorizationInfo((URL)new URL(this.getRepositoryUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME);
                        }
                        catch (MalformedURLException malformedURLException) {
                            Platform.flushAuthorizationInfo((URL)DEFAULT_URL, (String)this.getRepositoryUrl(), (String)AUTH_SCHEME);
                        }
                    }
                    catch (CoreException e) {
                        StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not flush authorization credentials", (Throwable)e));
                    }
                }
            } else {
                Map<String, String> headlessCreds = credentials.get(this.getRepositoryUrl());
                if (headlessCreds != null) {
                    headlessCreds.clear();
                }
            }
        }
    }

    private boolean useSecureStorage() {
        String useSecure = this.getProperty("org.eclipse.mylyn.tasklist.repositories.configuration.securestorage");
        if (useSecure != null) {
            return "true".equals(useSecure);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAuthInfo(String property) {
        Object object = LOCK;
        synchronized (object) {
            block16: {
                if (!Platform.isRunning()) break block16;
                if (this.useSecureStorage()) {
                    String propertyValue = null;
                    if (property.equals(String.valueOf(TaskRepository.getKeyPrefix(AuthenticationType.REPOSITORY)) + USERNAME)) {
                        propertyValue = this.getProperty(property);
                    } else {
                        try {
                            ISecurePreferences securePreferences = this.getSecurePreferences();
                            propertyValue = securePreferences.get(property, null);
                        }
                        catch (StorageException e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not retrieve authorization credentials", (Throwable)e));
                        }
                        if (propertyValue == null) {
                            propertyValue = this.getFromLegacyKeystore(property);
                        }
                    }
                    return propertyValue;
                }
                try {
                    Map map = Platform.getAuthorizationInfo((URL)new URL(this.getRepositoryUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME);
                    if (map != null) {
                        String propertyValue = (String)map.get(property);
                        return propertyValue;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Map map = Platform.getAuthorizationInfo((URL)DEFAULT_URL, (String)this.getRepositoryUrl(), (String)AUTH_SCHEME);
                    if (map != null) {
                        String propertyValue = (String)map.get(property);
                        return propertyValue;
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not retrieve authorization credentials", (Throwable)e));
                }
                return null;
            }
            Map<String, String> headlessCreds = credentials.get(this.getRepositoryUrl());
            if (headlessCreds == null) {
                headlessCreds = new HashMap<String, String>();
                credentials.put(this.getRepositoryUrl(), headlessCreds);
            }
            return headlessCreds.get(property);
        }
    }

    private String getFromLegacyKeystore(String property) {
        String propertyValue = null;
        try {
            Map map = Platform.getAuthorizationInfo((URL)new URL(this.getRepositoryUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME);
            if (map != null && (propertyValue = (String)map.get(property)) != null) {
                ISecurePreferences securePreferences = this.getSecurePreferences();
                securePreferences.put(property, propertyValue, property.endsWith(PASSWORD));
                map.remove(property);
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not retrieve authorization credentials", (Throwable)e));
        }
        return propertyValue;
    }

    public String getCharacterEncoding() {
        String encoding = this.properties.get("encoding");
        return encoding == null || AUTH_REALM.equals(encoding) ? DEFAULT_CHARACTER_ENCODING : encoding;
    }

    public Date getConfigurationDate() {
        Date configDate = null;
        String value = this.getProperty(PROPERTY_CONFIG_TIMESTAMP);
        try {
            configDate = new Date(Long.valueOf(value));
        }
        catch (Exception exception) {}
        return configDate;
    }

    public String getConnectorKind() {
        String kind = this.properties.get("kind");
        if (kind != null) {
            return kind;
        }
        return "<unknown>";
    }

    public synchronized AuthenticationCredentials getCredentials(AuthenticationType authType) {
        String key = TaskRepository.getKeyPrefix(authType);
        String enabled = this.getProperty(String.valueOf(key) + ENABLED);
        if (enabled == null || "true".equals(enabled)) {
            String userName = this.getAuthInfo(String.valueOf(key) + USERNAME);
            String savePassword = this.getProperty(String.valueOf(key) + SAVE_PASSWORD);
            String password = savePassword != null && "true".equals(savePassword) ? this.getAuthInfo(String.valueOf(key) + PASSWORD) : this.transientProperties.get(String.valueOf(key) + PASSWORD);
            if (userName == null) {
                userName = AUTH_REALM;
            }
            if (password == null) {
                password = AUTH_REALM;
            }
            if (enabled == null && userName.length() == 0) {
                return null;
            }
            return new AuthenticationCredentials(userName, password);
        }
        return null;
    }

    @Deprecated
    public String getHttpPassword() {
        return this.getPassword(AuthenticationType.HTTP);
    }

    @Deprecated
    public String getHttpUser() {
        return this.getUserName(AuthenticationType.HTTP);
    }

    @Deprecated
    public String getPassword() {
        return this.getPassword(AuthenticationType.REPOSITORY);
    }

    private String getPassword(AuthenticationType authType) {
        AuthenticationCredentials credentials = this.getCredentials(authType);
        return credentials != null ? credentials.getPassword() : null;
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.properties);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Deprecated
    public String getProxyPassword() {
        return this.getPassword(AuthenticationType.PROXY);
    }

    @Deprecated
    public String getProxyUsername() {
        return this.getUserName(AuthenticationType.PROXY);
    }

    public String getRepositoryLabel() {
        String label = this.properties.get("label");
        if (label != null && label.length() > 0) {
            return label;
        }
        return this.getRepositoryUrl();
    }

    public boolean getSavePassword(AuthenticationType authType) {
        String value = this.getProperty(String.valueOf(TaskRepository.getKeyPrefix(authType)) + SAVE_PASSWORD);
        return value != null && "true".equals(value);
    }

    public String getSynchronizationTimeStamp() {
        return this.properties.get("lastsynctimestamp");
    }

    public String getTimeZoneId() {
        String timeZoneId = this.properties.get("timezone");
        return timeZoneId == null || AUTH_REALM.equals(timeZoneId) ? TimeZone.getDefault().getID() : timeZoneId;
    }

    public String getUrl() {
        return this.getRepositoryUrl();
    }

    public String getRepositoryUrl() {
        return this.properties.get("url");
    }

    public String getUserName() {
        if (!this.isCachedUserName) {
            this.cachedUserName = this.getUserName(AuthenticationType.REPOSITORY);
            this.isCachedUserName = true;
        }
        return this.cachedUserName;
    }

    private String getUserName(AuthenticationType authType) {
        AuthenticationCredentials credentials = this.getCredentials(authType);
        return credentials != null ? credentials.getUserName() : null;
    }

    public String getVersion() {
        String version = this.properties.get("version");
        return version == null || AUTH_REALM.equals(version) ? NO_VERSION_SPECIFIED : version;
    }

    @Deprecated
    public boolean hasCredentials() {
        String username = this.getUserName();
        String password = this.getPassword();
        return username != null && username.length() > 0 && password != null && password.length() > 0;
    }

    public int hashCode() {
        return this.getRepositoryUrl().hashCode() * 31 + this.getConnectorKind().hashCode();
    }

    public boolean hasProperty(String name) {
        String value = this.getProperty(name);
        return value != null && value.trim().length() > 0;
    }

    @Deprecated
    public boolean isAnonymous() {
        return this.getProperty(ANONYMOUS_LOGIN) == null || "true".equals(this.getProperty(ANONYMOUS_LOGIN));
    }

    public boolean isBugRepository() {
        return this.isBugRepository;
    }

    public boolean isDefaultProxyEnabled() {
        return "true".equals(this.getProperty(PROXY_USEDEFAULT));
    }

    public boolean isOffline() {
        return this.getProperty(OFFLINE) != null && "true".equals(this.getProperty(OFFLINE));
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Deprecated
    public void setAuthenticationCredentials(String username, String password) {
        this.setCredentials(AuthenticationType.REPOSITORY, username, password);
    }

    public void setBugRepository(boolean isBugRepository) {
        this.isBugRepository = isBugRepository;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.properties.put("encoding", characterEncoding == null ? DEFAULT_CHARACTER_ENCODING : characterEncoding);
    }

    public final void setConfigurationDate(Date date) {
        this.setProperty(PROPERTY_CONFIG_TIMESTAMP, String.valueOf(date.getTime()));
    }

    public synchronized void setCredentials(AuthenticationType authType, AuthenticationCredentials credentials, boolean savePassword) {
        String key = TaskRepository.getKeyPrefix(authType);
        this.setProperty(String.valueOf(key) + SAVE_PASSWORD, String.valueOf(savePassword));
        if (credentials == null) {
            this.setProperty(String.valueOf(key) + ENABLED, String.valueOf(false));
            this.transientProperties.remove(String.valueOf(key) + PASSWORD);
            this.addAuthInfo(AUTH_REALM, AUTH_REALM, String.valueOf(key) + USERNAME, String.valueOf(key) + PASSWORD);
        } else {
            this.setProperty(String.valueOf(key) + ENABLED, String.valueOf(true));
            if (savePassword) {
                this.addAuthInfo(credentials.getUserName(), credentials.getPassword(), String.valueOf(key) + USERNAME, String.valueOf(key) + PASSWORD);
                this.transientProperties.remove(String.valueOf(key) + PASSWORD);
            } else {
                this.addAuthInfo(credentials.getUserName(), AUTH_REALM, String.valueOf(key) + USERNAME, String.valueOf(key) + PASSWORD);
                this.transientProperties.put(String.valueOf(key) + PASSWORD, credentials.getPassword());
            }
        }
        if (authType == AuthenticationType.REPOSITORY) {
            if (credentials == null) {
                this.cachedUserName = null;
                this.isCachedUserName = false;
            } else {
                this.cachedUserName = credentials.getUserName();
                this.isCachedUserName = true;
            }
        }
    }

    private void setCredentials(AuthenticationType type, String username, String password) {
        if (username == null) {
            this.setCredentials(type, null, true);
        } else {
            this.setCredentials(type, new AuthenticationCredentials(username, password), true);
        }
    }

    @Deprecated
    public void setHttpAuthenticationCredentials(String username, String password) {
        this.setCredentials(AuthenticationType.HTTP, username, password);
    }

    public void setOffline(boolean offline) {
        this.properties.put(OFFLINE, String.valueOf(offline));
    }

    @Deprecated
    public void setProxyAuthenticationCredentials(String username, String password) {
        this.setCredentials(AuthenticationType.PROXY, username, password);
    }

    public void setRepositoryLabel(String repositoryLabel) {
        this.setProperty("label", repositoryLabel);
    }

    public void setSynchronizationTimeStamp(String syncTime) {
        this.setProperty("lastsynctimestamp", syncTime);
    }

    public void setProperty(String key, String newValue) {
        String oldValue = this.properties.get(key);
        if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
            this.properties.put(key, newValue);
            this.notifyChangeListeners(key, oldValue, newValue);
        }
    }

    private void notifyChangeListeners(String key, String old, String value) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, key, old, value);
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    public void setTimeZoneId(String timeZoneId) {
        this.setProperty("timezone", timeZoneId == null ? TimeZone.getDefault().getID() : timeZoneId);
    }

    @Deprecated
    public void setUrl(String newUrl) {
        this.setRepositoryUrl(newUrl);
    }

    public void setRepositoryUrl(String repositoryUrl) {
        Assert.isNotNull((Object)repositoryUrl);
        this.properties.put("url", repositoryUrl);
    }

    public void setVersion(String ver) {
        this.properties.put("version", ver == null ? NO_VERSION_SPECIFIED : ver);
    }

    public String toString() {
        return this.getRepositoryUrl();
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public IRepositoryPerson createPerson(String personId) {
        return new RepositoryPerson(this, personId);
    }

    public IStatus getStatus() {
        return this.errorStatus;
    }

    public void setStatus(IStatus errorStatus) {
        this.errorStatus = errorStatus;
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public void setDefaultProxyEnabled(boolean useDefaultProxy) {
        this.setProperty(PROXY_USEDEFAULT, String.valueOf(useDefaultProxy));
    }
}

