/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.internal.DomainSourceTypesRegistry;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainLoadingStrategy;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainSourceModelType;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataChangeNotificationEvent;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelMergeAssistant;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataObserver;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataTranslator;
import org.eclipse.jst.jsf.common.metadata.internal.IPathSensitiveMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModel;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelMergeAssistantImpl;
import org.eclipse.jst.jsf.common.metadata.internal.ModelNotSetException;
import org.eclipse.jst.jsf.common.metadata.internal.StandardModelFactory;

public class DomainLoadingStrategy
implements IDomainLoadingStrategy,
IMetaDataObserver {
    protected String domain;
    private MetaDataModel _model;
    private List _sourceTypes;
    private List _sources;

    public DomainLoadingStrategy(String domain) {
        this.domain = domain;
    }

    public void load(MetaDataModel model) {
        this._model = model;
        this._sourceTypes = this.loadDomainSourceModelTypes();
        this.sortSourceTypes(this._sourceTypes);
        this._sources = this.locateMetaDataSourceInstances(this._sourceTypes, model);
        this.mergeModel(model, this._sources);
    }

    public void reload() throws ModelNotSetException {
        if (this._model == null) {
            throw new ModelNotSetException();
        }
        this.removeOldLocatorObservers();
        this._sources = this.locateMetaDataSourceInstances(this._sourceTypes, this._model);
        this.mergeModel(this._model, this._sources);
    }

    protected void mergeModel(MetaDataModel model, List sources) {
        StandardModelFactory.debug(">> Begin Merge: " + model.getModelKey() + "(" + sources.size() + " sources)", StandardModelFactory.DEBUG_MD_LOAD);
        IMetaDataModelMergeAssistant assistant = this.createModelMergeAssistant(model);
        for (IMetaDataSourceModelProvider mds : sources) {
            for (IMetaDataTranslator translator : mds.getLocator().getDomainSourceModelType().getTranslators()) {
                if (!translator.canTranslate(mds)) continue;
                StandardModelFactory.debug(">>> Merging: " + model.getModelKey() + "::" + mds, StandardModelFactory.DEBUG_MD_LOAD);
                assistant.setSourceModelProvider(mds);
                try {
                    translator.translate(assistant);
                }
                catch (Exception e) {
                    StandardModelFactory.debug(">>>> Error during translate/merge of: " + model.getModelKey() + ": " + mds, StandardModelFactory.DEBUG_MD_LOAD);
                    JSFCommonPlugin.log(4, "Error during load of: " + mds, e);
                }
            }
        }
        assistant.setMergeComplete();
        StandardModelFactory.debug(">> End Merge: " + model.getModelKey(), StandardModelFactory.DEBUG_MD_LOAD);
    }

    protected IMetaDataModelMergeAssistant createModelMergeAssistant(MetaDataModel model) {
        return new MetaDataModelMergeAssistantImpl(model);
    }

    protected void sortSourceTypes(List sourceTypes) {
    }

    protected List loadDomainSourceModelTypes() {
        return DomainSourceTypesRegistry.getInstance().getDomainSourceTypes(this.domain);
    }

    protected List locateMetaDataSourceInstances(List sourceTypes, MetaDataModel model) {
        ArrayList<IMetaDataSourceModelProvider> sources = new ArrayList<IMetaDataSourceModelProvider>();
        for (IDomainSourceModelType sourceType : sourceTypes) {
            List providers;
            IMetaDataLocator locator = sourceType.getLocator();
            locator.setDomainSourceModelType(sourceType);
            if (locator instanceof IPathSensitiveMetaDataLocator) {
                ((IPathSensitiveMetaDataLocator)locator).setProjectContext(model.getModelKey().getProject());
            }
            if ((providers = sourceType.getLocator().locateMetaDataModelProviders(model.getModelKey().getUri())) != null && !providers.isEmpty()) {
                for (IMetaDataSourceModelProvider provider : providers) {
                    provider.setLocator(sourceType.getLocator());
                    sources.add(provider);
                }
            }
            sourceType.getLocator().addObserver(this);
        }
        return sources;
    }

    public void notifyMetadataChanged(IMetaDataChangeNotificationEvent event) {
        this._model.setNeedsRefresh();
    }

    public void cleanup() {
        this.removeOldLocatorObservers();
        this._sources = null;
        this._sourceTypes = null;
        this._model = null;
    }

    private void removeOldLocatorObservers() {
        if (this._sources != null) {
            for (IMetaDataSourceModelProvider provider : this._sources) {
                IMetaDataLocator locator;
                if (provider == null || (locator = provider.getLocator()) == null) continue;
                locator.removeObserver(this);
                locator.setDomainSourceModelType(null);
                provider.setLocator(null);
            }
        }
    }
}

