/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.util.Properties;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.NLSKeyHyperlink;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;

public class NLSStringHover
extends AbstractJavaEditorTextHover {
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (!(this.getEditor() instanceof JavaEditor)) {
            return null;
        }
        ITypeRoot je = this.getEditorInputJavaElement();
        if (je == null) {
            return null;
        }
        CompilationUnit ast = SharedASTProvider.getAST(je, SharedASTProvider.WAIT_NO, null);
        if (ast == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)ast, offset, 1);
        if (node instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)node;
            return new Region(stringLiteral.getStartPosition(), stringLiteral.getLength());
        }
        if (node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            return new Region(simpleName.getStartPosition(), simpleName.getLength());
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        NLSHoverControlInput info = this.internalGetHoverInfo(textViewer, hoverRegion);
        return info == null ? null : info.fInformation;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.internalGetHoverInfo(textViewer, hoverRegion);
    }

    private NLSHoverControlInput internalGetHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IStorage propertiesFile;
        if (!(this.getEditor() instanceof JavaEditor)) {
            return null;
        }
        ITypeRoot je = this.getEditorInputJavaElement();
        if (je == null) {
            return null;
        }
        CompilationUnit ast = SharedASTProvider.getAST(je, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
        if (ast == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)ast, hoverRegion.getOffset(), hoverRegion.getLength());
        if (!(node instanceof StringLiteral) && !(node instanceof SimpleName)) {
            return null;
        }
        if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
            return null;
        }
        AccessorClassReference ref = NLSHintHelper.getAccessorClassReference(ast, hoverRegion);
        if (ref == null) {
            return null;
        }
        try {
            propertiesFile = NLSHintHelper.getResourceBundle(je.getJavaProject(), ref);
            if (propertiesFile == null) {
                return new NLSHoverControlInput(this.toHtml(JavaHoverMessages.NLSStringHover_NLSStringHover_PropertiesFileNotDetectedWarning, ""), null, "", this.getEditor());
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        String propertiesFileName = propertiesFile.getName();
        Properties properties = NLSHintHelper.getProperties(propertiesFile);
        if (properties == null) {
            return null;
        }
        if (properties.isEmpty()) {
            return new NLSHoverControlInput(this.toHtml(propertiesFileName, JavaHoverMessages.NLSStringHover_NLSStringHover_missingKeyWarning), propertiesFile, "", this.getEditor());
        }
        String identifier = null;
        identifier = node instanceof StringLiteral ? ((StringLiteral)node).getLiteralValue() : ((SimpleName)node).getIdentifier();
        if (identifier == null) {
            return null;
        }
        String value = properties.getProperty(identifier, null);
        value = value != null ? HTMLPrinter.convertToHTMLContent((String)value) : JavaHoverMessages.NLSStringHover_NLSStringHover_missingKeyWarning;
        String buffer = this.toHtml(propertiesFileName, value);
        return new NLSHoverControlInput(buffer, propertiesFile, identifier, this.getEditor());
    }

    private String toHtml(String header, String string) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)header);
        HTMLPrinter.addParagraph((StringBuffer)buffer, (String)string);
        HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0);
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    private static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fPresenterControlCreator;

        public HoverControlCreator(IInformationControlCreator presenterControlCreator) {
            this.fPresenterControlCreator = presenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new NLSHoverControl(this, parent, EditorsUI.getTooltipAffordanceString()){
                final /* synthetic */ HoverControlCreator this$1;
                {
                    this.this$1 = hoverControlCreator;
                }

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return HoverControlCreator.access$0(this.this$1);
                }
            };
        }

        static /* synthetic */ IInformationControlCreator access$0(HoverControlCreator hoverControlCreator) {
            return hoverControlCreator.fPresenterControlCreator;
        }
    }

    static class NLSHoverControl
    extends DefaultInformationControl
    implements IInformationControlExtension2 {
        private NLSHoverControlInput fInput;

        public NLSHoverControl(Shell parent, ToolBarManager tbm) {
            super(parent, tbm);
        }

        public NLSHoverControl(Shell parent, String tooltipAffordanceString) {
            super(parent, tooltipAffordanceString);
        }

        public void setInput(Object input) {
            Assert.isLegal((boolean)(input instanceof NLSHoverControlInput));
            NLSHoverControlInput info = (NLSHoverControlInput)input;
            this.setInformation(info.fInformation);
            this.fInput = info;
        }

        public NLSHoverControlInput getInput() {
            return this.fInput;
        }
    }

    private static class NLSHoverControlInput {
        private IStorage fpropertiesFile;
        private String fKeyName;
        private String fInformation;
        private IEditorPart fActiveEditor;

        public NLSHoverControlInput(String information, IStorage propertiesFile, String key, IEditorPart editor) {
            this.fInformation = information;
            this.fpropertiesFile = propertiesFile;
            this.fKeyName = key;
            this.fActiveEditor = editor;
        }
    }

    private static final class OpenPropertiesFileAction
    extends Action {
        private NLSHoverControl fControl;

        public OpenPropertiesFileAction(NLSHoverControl control) {
            this.fControl = control;
            this.setText(JavaHoverMessages.NLSStringHover_open_in_properties_file);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "goto_input.gif");
        }

        public void run() {
            NLSHoverControlInput input = this.fControl.getInput();
            NLSKeyHyperlink.openKeyInPropertiesFile(input.fKeyName, input.fpropertiesFile, input.fActiveEditor);
        }
    }

    private static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private PresenterControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            ToolBarManager tbm = new ToolBarManager(0x800000);
            NLSHoverControl iControl = new NLSHoverControl(parent, tbm);
            OpenPropertiesFileAction openPropertiesFileAction = new OpenPropertiesFileAction(iControl);
            tbm.add((IAction)openPropertiesFileAction);
            tbm.update(true);
            return iControl;
        }
    }
}

