/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;

public class ImplementOccurrencesFinder
implements IOccurrencesFinder {
    public static final String ID = "ImplementOccurrencesFinder";
    private CompilationUnit fASTRoot;
    private ASTNode fStart;
    private List fResult = new ArrayList();
    private ASTNode fSelectedNode;
    private ITypeBinding fSelectedType;
    private String fDescription;

    public String initialize(CompilationUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, offset, length));
    }

    public String initialize(CompilationUnit root, ASTNode node) {
        if (!(node instanceof Name)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fSelectedNode = ASTNodes.getNormalizedNode(node);
        if (!(this.fSelectedNode instanceof Type)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        StructuralPropertyDescriptor location = this.fSelectedNode.getLocationInParent();
        if (location != TypeDeclaration.SUPERCLASS_TYPE_PROPERTY && location != TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY && location != EnumDeclaration.SUPER_INTERFACE_TYPES_PROPERTY) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fSelectedType = ((Type)this.fSelectedNode).resolveBinding();
        if (this.fSelectedType == null) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fStart = this.fSelectedNode.getParent();
        this.fASTRoot = root;
        this.fDescription = Messages.format(SearchMessages.ImplementOccurrencesFinder_occurrence_description, BasicElementLabels.getJavaElementName(this.fSelectedType.getName()));
        return null;
    }

    private void performSearch() {
        this.fStart.accept((ASTVisitor)new MethodVisitor());
        if (this.fSelectedNode != null) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(this.fSelectedNode.getStartPosition(), this.fSelectedNode.getLength(), 0, this.fDescription));
        }
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        this.performSearch();
        if (this.fResult.isEmpty()) {
            return null;
        }
        return this.fResult.toArray(new IOccurrencesFinder.OccurrenceLocation[this.fResult.size()]);
    }

    public int getSearchKind() {
        return 8;
    }

    public CompilationUnit getASTRoot() {
        return this.fASTRoot;
    }

    public String getJobLabel() {
        return SearchMessages.ImplementOccurrencesFinder_searchfor;
    }

    public String getElementName() {
        if (this.fSelectedNode != null) {
            return ASTNodes.asString(this.fSelectedNode);
        }
        return null;
    }

    public String getUnformattedPluralLabel() {
        return SearchMessages.ImplementOccurrencesFinder_label_plural;
    }

    public String getUnformattedSingularLabel() {
        return SearchMessages.ImplementOccurrencesFinder_label_singular;
    }

    public String getID() {
        return ID;
    }

    private class MethodVisitor
    extends ASTVisitor {
        private MethodVisitor() {
        }

        public boolean visit(MethodDeclaration node) {
            IMethodBinding method;
            IMethodBinding binding = node.resolveBinding();
            if (binding != null && !Modifier.isStatic((int)binding.getModifiers()) && (method = Bindings.findOverriddenMethodInHierarchy(ImplementOccurrencesFinder.this.fSelectedType, binding)) != null) {
                SimpleName name = node.getName();
                ImplementOccurrencesFinder.this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, ImplementOccurrencesFinder.this.fDescription));
            }
            return super.visit(node);
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclarationStatement node) {
            return false;
        }
    }
}

