/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.ColumnTable;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.ConnectionFilterPropertyPage;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConnectionFilterComposite
extends Composite
implements Listener {
    private static final ResourceLoader resource = ResourceLoader.getResourceLoader();
    protected ISelection selection;
    private Button disableFilterCheckbox;
    private Button expressionRadioButton;
    private Button selectionRadioButton;
    private Group expressionGroup;
    private Group selectionGroup;
    private Label expressionLabel;
    private Combo expressionPredicate;
    private Text expressionField;
    private Combo selectionPredicate;
    protected Table selectionTable;
    private Button selectAllButton;
    private Button deselectAllButton;
    private String STARTS_WITH_TEXT;
    private String CONTAINS_TEXT;
    private String ENDS_WITH_TEXT;
    private String NOT_START_WITH_TEXT;
    private String NOT_CONTAIN_TEXT;
    private String NOT_END_WITH_TEXT;
    private String INCLUDE_ITEMS_TEXT;
    private String EXCLUDE_ITEMS_TEXT;
    private static String LIKE_PREDICATE_TEXT = "LIKE";
    private static String IN_PREDICATE_TEXT = "IN";
    private static String NOT_PREDICATE_TEXT = "NOT";
    protected boolean isSelectionListPopulated = false;
    private static String IDENTIFIER_DELIMITER = "'";
    private String DEFAULT_MESSAGE = resource.queryString("_UI_DESCRIPTION_FILTER");
    private boolean hideExpressionOption = false;
    private boolean hideSelectionOption = false;
    protected String defaultTitleText = "Connection Filter Properties";
    private Collator collator = Collator.getInstance((Locale)Locale.getDefault());
    private IConnectionFilterProvider connectionFilterProvider;
    private ColumnTable columnTable;
    private boolean isMultiplePredicatesMode = false;

    public ConnectionFilterComposite(Composite parent, int style, IConnectionFilterProvider connectionFilterProvider, boolean hideExpressionOption, boolean hideSelectionOption) {
        super(parent, style);
        this.hideExpressionOption = hideExpressionOption;
        this.hideSelectionOption = hideSelectionOption;
        this.connectionFilterProvider = connectionFilterProvider;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        GridData gd = null;
        if (!hideExpressionOption) {
            this.expressionRadioButton = new Button((Composite)this, 16);
            this.expressionRadioButton.setText(resource.queryString("_UI_RADIO_BUTTON_EXPRESSION"));
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.expressionRadioButton.setLayoutData((Object)gd);
            this.expressionGroup = new Group((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.verticalSpacing = 5;
            this.expressionGroup.setLayout((Layout)layout);
            gd = new GridData(768);
            gd.verticalAlignment = 1;
            this.expressionGroup.setLayoutData((Object)gd);
            this.expressionLabel = new Label((Composite)this.expressionGroup, 0);
            this.expressionLabel.setText(resource.queryString("_UI_LABEL_EXPRESSION"));
            gd = new GridData();
            this.expressionLabel.setLayoutData((Object)gd);
            this.expressionPredicate = new Combo((Composite)this.expressionGroup, 8);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.expressionPredicate.setLayoutData((Object)gd);
            this.STARTS_WITH_TEXT = resource.queryString("_UI_COMBO_STARTS_WITH");
            this.CONTAINS_TEXT = resource.queryString("_UI_COMBO_CONTAINS");
            this.ENDS_WITH_TEXT = resource.queryString("_UI_COMBO_ENDS_WITH");
            this.NOT_START_WITH_TEXT = resource.queryString("_UI_COMBO_NOT_START_WITH");
            this.NOT_CONTAIN_TEXT = resource.queryString("_UI_COMBO_NOT_CONTAIN");
            this.NOT_END_WITH_TEXT = resource.queryString("_UI_COMBO_NOT_END_WITH");
            this.expressionPredicate.add(this.STARTS_WITH_TEXT);
            this.expressionPredicate.add(this.CONTAINS_TEXT);
            this.expressionPredicate.add(this.ENDS_WITH_TEXT);
            this.expressionPredicate.add(this.NOT_START_WITH_TEXT);
            this.expressionPredicate.add(this.NOT_CONTAIN_TEXT);
            this.expressionPredicate.add(this.NOT_END_WITH_TEXT);
            this.expressionField = new Text((Composite)this.expressionGroup, 2048);
            gd = new GridData(768);
            this.expressionField.setLayoutData((Object)gd);
        }
        if (!hideSelectionOption) {
            this.selectionRadioButton = new Button((Composite)this, 16);
            this.selectionRadioButton.setText(resource.queryString("_UI_RADIO_BUTTON_SELECTION"));
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.selectionRadioButton.setLayoutData((Object)gd);
            this.selectionGroup = new Group((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 5;
            this.selectionGroup.setLayout((Layout)layout);
            gd = new GridData(1808);
            this.selectionGroup.setLayoutData((Object)gd);
            this.selectionPredicate = new Combo((Composite)this.selectionGroup, 8);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            this.selectionPredicate.setLayoutData((Object)gd);
            this.INCLUDE_ITEMS_TEXT = resource.queryString("_UI_COMBO_INCLUDE_ITEMS");
            this.EXCLUDE_ITEMS_TEXT = resource.queryString("_UI_COMBO_EXCLUDE_ITEMS");
            this.selectionPredicate.add(this.INCLUDE_ITEMS_TEXT);
            this.selectionPredicate.add(this.EXCLUDE_ITEMS_TEXT);
            this.selectionTable = new Table((Composite)this.selectionGroup, 2080);
            gd = new GridData(1808);
            this.selectionTable.setLayoutData((Object)gd);
            Composite buttonComposite = new Composite((Composite)this.selectionGroup, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 5;
            buttonComposite.setLayout((Layout)layout);
            buttonComposite.setLayoutData((Object)new GridData(1042));
            this.selectAllButton = new Button(buttonComposite, 0);
            this.selectAllButton.setText(resource.queryString("_UI_BUTTON_SELECT_ALL"));
            this.selectAllButton.setLayoutData((Object)new GridData(770));
            this.deselectAllButton = new Button(buttonComposite, 0);
            this.deselectAllButton.setText(resource.queryString("_UI_BUTTON_DESELECT_ALL"));
            this.deselectAllButton.setLayoutData((Object)new GridData(770));
        }
        this.disableFilterCheckbox = new Button((Composite)this, 32);
        this.disableFilterCheckbox.setText(resource.queryString("_UI_CHECKBOX_DISABLE_FILTER"));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.disableFilterCheckbox.setLayoutData((Object)gd);
        this.disableFilterCheckbox.addListener(13, (Listener)this);
        if (!hideExpressionOption) {
            this.expressionRadioButton.addListener(13, (Listener)this);
            if (!hideSelectionOption) {
                this.selectionRadioButton.addListener(13, (Listener)this);
            }
            this.expressionField.addListener(24, (Listener)this);
        }
        if (!hideSelectionOption) {
            this.selectionTable.addListener(13, (Listener)this);
            this.selectionPredicate.addListener(13, (Listener)this);
            this.selectAllButton.addListener(13, (Listener)this);
            this.deselectAllButton.addListener(13, (Listener)this);
        }
        this.disableFilterCheckbox.setSelection(false);
        if (!hideExpressionOption) {
            this.expressionRadioButton.setSelection(true);
            this.expressionPredicate.select(this.expressionPredicate.indexOf(this.STARTS_WITH_TEXT));
            if (!hideSelectionOption) {
                this.selectionPredicate.select(this.selectionPredicate.indexOf(this.INCLUDE_ITEMS_TEXT));
                this.enableSelectionGroupControls(false);
            }
        } else if (!hideSelectionOption) {
            this.selectionPredicate.select(this.selectionPredicate.indexOf(this.INCLUDE_ITEMS_TEXT));
        }
    }

    public ConnectionFilterComposite(Composite parent, int style, IConnectionFilterProvider connectionFilterProvider, boolean hideExpressionOption, boolean hideSelectionOption, boolean isMultiplePredicatesMode, ConnectionFilter connFilter, ConnectionFilterPropertyPage connectionFilterPropertyPage) {
        super(parent, style);
        this.hideExpressionOption = hideExpressionOption;
        this.hideSelectionOption = hideSelectionOption;
        this.connectionFilterProvider = connectionFilterProvider;
        this.isMultiplePredicatesMode = isMultiplePredicatesMode;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        GridData gd = null;
        if (!hideExpressionOption) {
            this.expressionRadioButton = new Button((Composite)this, 16);
            this.expressionRadioButton.setText(resource.queryString("_UI_RADIO_BUTTON_EXPRESSION"));
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.expressionRadioButton.setLayoutData((Object)gd);
            this.expressionGroup = new Group((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.verticalSpacing = 5;
            this.expressionGroup.setLayout((Layout)layout);
            gd = new GridData(768);
            gd.verticalAlignment = 1;
            this.expressionGroup.setLayoutData((Object)gd);
            this.columnTable = new ColumnTable((Composite)this.expressionGroup, connectionFilterPropertyPage, connFilter);
            this.STARTS_WITH_TEXT = resource.queryString("_UI_COMBO_STARTS_WITH");
            this.CONTAINS_TEXT = resource.queryString("_UI_COMBO_CONTAINS");
            this.ENDS_WITH_TEXT = resource.queryString("_UI_COMBO_ENDS_WITH");
            this.NOT_START_WITH_TEXT = resource.queryString("_UI_COMBO_NOT_START_WITH");
            this.NOT_CONTAIN_TEXT = resource.queryString("_UI_COMBO_NOT_CONTAIN");
            this.NOT_END_WITH_TEXT = resource.queryString("_UI_COMBO_NOT_END_WITH");
        }
        if (!hideSelectionOption) {
            this.selectionRadioButton = new Button((Composite)this, 16);
            this.selectionRadioButton.setText(resource.queryString("_UI_RADIO_BUTTON_SELECTION"));
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.selectionRadioButton.setLayoutData((Object)gd);
            this.selectionGroup = new Group((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 5;
            this.selectionGroup.setLayout((Layout)layout);
            gd = new GridData(1808);
            this.selectionGroup.setLayoutData((Object)gd);
            this.selectionPredicate = new Combo((Composite)this.selectionGroup, 8);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            this.selectionPredicate.setLayoutData((Object)gd);
            this.INCLUDE_ITEMS_TEXT = resource.queryString("_UI_COMBO_INCLUDE_ITEMS");
            this.EXCLUDE_ITEMS_TEXT = resource.queryString("_UI_COMBO_EXCLUDE_ITEMS");
            this.selectionPredicate.add(this.INCLUDE_ITEMS_TEXT);
            this.selectionPredicate.add(this.EXCLUDE_ITEMS_TEXT);
            this.selectionTable = new Table((Composite)this.selectionGroup, 2080);
            gd = new GridData(1808);
            this.selectionTable.setLayoutData((Object)gd);
            Composite buttonComposite = new Composite((Composite)this.selectionGroup, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 5;
            buttonComposite.setLayout((Layout)layout);
            buttonComposite.setLayoutData((Object)new GridData(1042));
            this.selectAllButton = new Button(buttonComposite, 0);
            this.selectAllButton.setText(resource.queryString("_UI_BUTTON_SELECT_ALL"));
            this.selectAllButton.setLayoutData((Object)new GridData(770));
            this.deselectAllButton = new Button(buttonComposite, 0);
            this.deselectAllButton.setText(resource.queryString("_UI_BUTTON_DESELECT_ALL"));
            this.deselectAllButton.setLayoutData((Object)new GridData(770));
        }
        this.disableFilterCheckbox = new Button((Composite)this, 32);
        this.disableFilterCheckbox.setText(resource.queryString("_UI_CHECKBOX_DISABLE_FILTER"));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.disableFilterCheckbox.setLayoutData((Object)gd);
        this.disableFilterCheckbox.addListener(13, (Listener)this);
        if (!hideExpressionOption) {
            this.expressionRadioButton.addListener(13, (Listener)this);
            if (!hideSelectionOption) {
                this.selectionRadioButton.addListener(13, (Listener)this);
            }
        }
        if (!hideSelectionOption) {
            this.selectionTable.addListener(13, (Listener)this);
            this.selectionPredicate.addListener(13, (Listener)this);
            this.selectAllButton.addListener(13, (Listener)this);
            this.deselectAllButton.addListener(13, (Listener)this);
        }
        this.disableFilterCheckbox.setSelection(false);
        if (!hideExpressionOption) {
            this.expressionRadioButton.setSelection(true);
            if (!hideSelectionOption) {
                this.selectionPredicate.select(this.selectionPredicate.indexOf(this.INCLUDE_ITEMS_TEXT));
                this.enableSelectionGroupControls(false);
            }
        } else if (!hideSelectionOption) {
            this.selectionPredicate.select(this.selectionPredicate.indexOf(this.INCLUDE_ITEMS_TEXT));
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.disableFilterCheckbox) {
            this.enableFilterSpecificationControls(!this.disableFilterCheckbox.getSelection());
        } else if (source == this.expressionRadioButton) {
            this.enableFilterSpecificationControls(true);
        } else if (source == this.selectAllButton) {
            this.setAllTableItemsChecked(true);
        } else if (source == this.deselectAllButton) {
            this.setAllTableItemsChecked(false);
        }
        this.connectionFilterProvider.dataChanged();
    }

    private void setAllTableItemsChecked(boolean checked) {
        TableItem[] tableItems = this.selectionTable.getItems();
        int tableItemCount = tableItems.length;
        int index = 0;
        while (index < tableItemCount) {
            tableItems[index].setChecked(checked);
            ++index;
        }
    }

    private void enableExpressionGroupControls(boolean isEnabled) {
        if (!this.hideExpressionOption) {
            if (!this.isMultiplePredicatesMode) {
                this.expressionGroup.setEnabled(isEnabled);
                this.expressionLabel.setEnabled(isEnabled);
                this.expressionPredicate.setEnabled(isEnabled);
                this.expressionField.setEnabled(isEnabled);
            } else {
                this.expressionGroup.setEnabled(isEnabled);
            }
        }
    }

    private void enableSelectionGroupControls(boolean isEnabled) {
        if (!this.hideSelectionOption) {
            this.selectionGroup.setEnabled(isEnabled);
            this.selectionPredicate.setEnabled(isEnabled);
            this.selectionTable.setEnabled(isEnabled);
            this.selectAllButton.setEnabled(isEnabled);
            this.deselectAllButton.setEnabled(isEnabled);
            TableItem[] tableItems = this.selectionTable.getItems();
            int tableItemCount = tableItems.length;
            int index = 0;
            while (index < tableItemCount) {
                tableItems[index].setGrayed(!isEnabled);
                ++index;
            }
            if (isEnabled && !this.isSelectionListPopulated) {
                this.populateSelectionTableWithBusyCursor();
            }
        }
    }

    private void enableFilterSpecificationControls(boolean isEnabled) {
        if (!this.hideExpressionOption) {
            if (!this.isMultiplePredicatesMode) {
                if (isEnabled) {
                    this.expressionRadioButton.setEnabled(true);
                    if (!this.hideSelectionOption) {
                        this.selectionRadioButton.setEnabled(true);
                    }
                    if (this.expressionRadioButton.getSelection()) {
                        this.enableSelectionGroupControls(false);
                        this.enableExpressionGroupControls(true);
                    } else {
                        this.enableExpressionGroupControls(false);
                        this.enableSelectionGroupControls(true);
                    }
                } else {
                    this.enableExpressionGroupControls(false);
                    this.enableSelectionGroupControls(false);
                    this.expressionRadioButton.setEnabled(false);
                    if (!this.hideSelectionOption) {
                        this.selectionRadioButton.setEnabled(false);
                    }
                }
            } else if (isEnabled) {
                this.expressionRadioButton.setEnabled(true);
                this.selectionRadioButton.setEnabled(true);
                if (this.expressionRadioButton.getSelection()) {
                    this.enableSelectionGroupControls(false);
                    this.enableExpressionGroupControls(true);
                    this.columnTable.enableTableSpecificationControls(true);
                } else {
                    this.enableExpressionGroupControls(false);
                    this.columnTable.enableTableSpecificationControls(false);
                    this.enableSelectionGroupControls(true);
                }
            } else {
                this.enableExpressionGroupControls(false);
                this.enableSelectionGroupControls(false);
                this.expressionRadioButton.setEnabled(false);
                this.columnTable.enableTableSpecificationControls(false);
                this.selectionRadioButton.setEnabled(false);
            }
        } else {
            this.enableSelectionGroupControls(isEnabled);
        }
    }

    public void initializeValues() {
        ConnectionFilter connFilter;
        this.isSelectionListPopulated = false;
        if (!this.hideSelectionOption) {
            this.selectionTable.removeAll();
        }
        if ((connFilter = this.connectionFilterProvider.getConnectionFilter()) != null) {
            this.disableFilterCheckbox.setSelection(false);
            String predicate = connFilter.getPredicate();
            if (!this.hideExpressionOption && this.isPredicateAnExpression(predicate)) {
                this.expressionRadioButton.setSelection(true);
                if (!this.hideSelectionOption) {
                    this.selectionRadioButton.setSelection(false);
                }
                if (!this.isMultiplePredicatesMode) {
                    this.expressionPredicate.select(this.expressionPredicate.indexOf(this.findExpressionPredicate(predicate)));
                    this.expressionField.setText(this.findExpressionValue(predicate));
                } else {
                    this.columnTable.initializeValues(true);
                }
                this.enableFilterSpecificationControls(true);
            } else {
                if (!this.hideExpressionOption) {
                    if (!this.hideSelectionOption) {
                        this.selectionRadioButton.setSelection(true);
                    }
                    this.expressionRadioButton.setSelection(false);
                    if (this.isMultiplePredicatesMode) {
                        this.columnTable.initializeValues(false);
                    }
                }
                if (!this.hideSelectionOption) {
                    if (this.isPredicateNegated(predicate)) {
                        this.selectionPredicate.select(this.selectionPredicate.indexOf(this.EXCLUDE_ITEMS_TEXT));
                    }
                    this.populateSelectionTableWithBusyCursor();
                    this.selectSelectionFilterItems(this.findSelectionFilterItems(predicate));
                }
                this.enableFilterSpecificationControls(true);
            }
        } else {
            this.disableFilterCheckbox.setSelection(true);
            this.enableFilterSpecificationControls(false);
            if (this.isMultiplePredicatesMode) {
                this.columnTable.initializeValues(false);
            }
        }
    }

    private String[] findSelectionFilterItems(String filterPredicate) {
        Object[] filterItems = new String[]{};
        if (filterPredicate != null) {
            String[] predicateSubStrings = filterPredicate.split(IDENTIFIER_DELIMITER);
            int predicateSubStringsCount = predicateSubStrings.length;
            Vector<String> filterItemCollection = new Vector<String>();
            int index = 1;
            while (index < predicateSubStringsCount - 1) {
                filterItemCollection.add(predicateSubStrings[index]);
                ++index;
            }
            filterItems = new String[filterItemCollection.size()];
            filterItemCollection.copyInto(filterItems);
        }
        return filterItems;
    }

    private void selectSelectionFilterItems(String[] filterItems) {
        TableItem[] tableItems = this.selectionTable.getItems();
        Hashtable<String, TableItem> tableItemsCollection = new Hashtable<String, TableItem>();
        int tableItemsCount = tableItems.length;
        int index = 0;
        while (index < tableItemsCount) {
            tableItemsCollection.put(tableItems[index].getText(), tableItems[index]);
            ++index;
        }
        int filterItemsCount = filterItems.length;
        int index2 = 0;
        while (index2 < filterItemsCount) {
            Object tableItem = tableItemsCollection.get(filterItems[index2]);
            if (tableItem != null) {
                ((TableItem)tableItem).setChecked(true);
            }
            ++index2;
        }
    }

    private boolean isPredicateAnExpression(String filterPredicate) {
        boolean isExpression = false;
        if (filterPredicate != null && filterPredicate.split(IDENTIFIER_DELIMITER)[0].indexOf(LIKE_PREDICATE_TEXT) != -1) {
            isExpression = true;
        }
        return isExpression;
    }

    private boolean isPredicateNegated(String filterPredicate) {
        boolean isNegated = false;
        if (filterPredicate != null && filterPredicate.split(IDENTIFIER_DELIMITER)[0].indexOf(NOT_PREDICATE_TEXT) != -1) {
            isNegated = true;
        }
        return isNegated;
    }

    private String findExpressionValue(String filterPredicate) {
        String expressionValue = filterPredicate.split(IDENTIFIER_DELIMITER)[1];
        if (expressionValue.startsWith("%")) {
            expressionValue = expressionValue.substring(1);
        }
        if (expressionValue.endsWith("%")) {
            expressionValue = expressionValue.substring(0, expressionValue.length() - 1);
        }
        return expressionValue;
    }

    private String findExpressionPredicate(String filterPredicate) {
        String expressionValue;
        String expressionPredicate = this.CONTAINS_TEXT;
        boolean isNotLike = false;
        boolean startsWithPercentSign = false;
        boolean endsWithPercentSign = false;
        if (filterPredicate.startsWith(NOT_PREDICATE_TEXT)) {
            isNotLike = true;
        }
        if ((expressionValue = filterPredicate.split(IDENTIFIER_DELIMITER)[1]).startsWith("%")) {
            startsWithPercentSign = true;
        }
        if (expressionValue.endsWith("%")) {
            endsWithPercentSign = true;
        }
        if (startsWithPercentSign && endsWithPercentSign) {
            expressionPredicate = isNotLike ? this.NOT_CONTAIN_TEXT : this.CONTAINS_TEXT;
        } else if (startsWithPercentSign) {
            expressionPredicate = isNotLike ? this.NOT_END_WITH_TEXT : this.ENDS_WITH_TEXT;
        } else if (endsWithPercentSign) {
            expressionPredicate = isNotLike ? this.NOT_START_WITH_TEXT : this.STARTS_WITH_TEXT;
        }
        return expressionPredicate;
    }

    public boolean validatePage(DialogPage page) {
        boolean isValid = true;
        if (!this.disableFilterCheckbox.getSelection()) {
            if (!this.hideExpressionOption && this.expressionRadioButton.getSelection()) {
                if (!this.isMultiplePredicatesMode) {
                    if (this.expressionField.getText().length() == 0) {
                        page.setMessage(resource.queryString("_UI_MESSAGE_CRITERIA_REQUIRED"));
                        page.setErrorMessage(null);
                        isValid = false;
                    } else if (this.expressionField.getText().indexOf(IDENTIFIER_DELIMITER) > -1 || this.expressionField.getText().indexOf(34) > -1) {
                        page.setErrorMessage(resource.queryString("_UI_MESSAGE_NO_QUOTES"));
                        page.setDescription(this.DEFAULT_MESSAGE);
                        isValid = false;
                    }
                } else if (this.columnTable.hasEmptyExpression()) {
                    page.setMessage(resource.queryString("_UI_MESSAGE_CRITERIA_REQUIRED"));
                    page.setErrorMessage(null);
                    isValid = false;
                } else if (this.columnTable.hasQuoteInExpression()) {
                    page.setErrorMessage(resource.queryString("_UI_MESSAGE_NO_QUOTES"));
                    page.setMessage(this.DEFAULT_MESSAGE);
                    isValid = false;
                }
            } else if (!this.hideSelectionOption) {
                TableItem[] items = this.selectionTable.getItems();
                int itemCount = items.length;
                boolean isItemSelected = false;
                int index = 0;
                while (index < itemCount) {
                    if (items[index].getChecked()) {
                        isItemSelected = true;
                        break;
                    }
                    ++index;
                }
                if (!isItemSelected) {
                    page.setMessage(resource.queryString("_UI_MESSAGE_SELECTION_REQUIRED"));
                    page.setErrorMessage(null);
                    isValid = false;
                }
            }
        }
        if (isValid) {
            page.setMessage(this.DEFAULT_MESSAGE);
            page.setErrorMessage(null);
        }
        return isValid;
    }

    public String getPredicate() {
        String predicate = "";
        if (this.isFilterSpecified()) {
            if (!this.hideExpressionOption && this.expressionRadioButton.getSelection()) {
                String selectedPredicate = this.expressionPredicate.getItem(this.expressionPredicate.getSelectionIndex());
                String cleanedString = this.expressionField.getText().trim();
                if (selectedPredicate.equals(this.STARTS_WITH_TEXT)) {
                    predicate = String.valueOf(LIKE_PREDICATE_TEXT) + " " + IDENTIFIER_DELIMITER + cleanedString + "%" + IDENTIFIER_DELIMITER;
                } else if (selectedPredicate.equals(this.NOT_START_WITH_TEXT)) {
                    predicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + LIKE_PREDICATE_TEXT + " " + IDENTIFIER_DELIMITER + cleanedString + "%" + IDENTIFIER_DELIMITER;
                } else if (selectedPredicate.equals(this.CONTAINS_TEXT)) {
                    predicate = String.valueOf(LIKE_PREDICATE_TEXT) + " " + IDENTIFIER_DELIMITER + "%" + cleanedString + "%" + IDENTIFIER_DELIMITER;
                } else if (selectedPredicate.equals(this.NOT_CONTAIN_TEXT)) {
                    predicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + LIKE_PREDICATE_TEXT + " " + IDENTIFIER_DELIMITER + "%" + cleanedString + "%" + IDENTIFIER_DELIMITER;
                } else if (selectedPredicate.equals(this.ENDS_WITH_TEXT)) {
                    predicate = String.valueOf(LIKE_PREDICATE_TEXT) + " " + IDENTIFIER_DELIMITER + "%" + cleanedString + IDENTIFIER_DELIMITER;
                } else if (selectedPredicate.equals(this.NOT_END_WITH_TEXT)) {
                    predicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + LIKE_PREDICATE_TEXT + " " + IDENTIFIER_DELIMITER + "%" + cleanedString + IDENTIFIER_DELIMITER;
                }
            } else if (!this.hideSelectionOption) {
                String itemList = "";
                TableItem[] items = this.selectionTable.getItems();
                Vector<TableItem> selectedItemsCollection = new Vector<TableItem>();
                int itemCount = items.length;
                int index = 0;
                while (index < itemCount) {
                    if (items[index].getChecked()) {
                        selectedItemsCollection.add(items[index]);
                    }
                    ++index;
                }
                Object[] selectedItems = new TableItem[selectedItemsCollection.size()];
                selectedItemsCollection.copyInto(selectedItems);
                int selectedItemCount = selectedItems.length;
                if (selectedItemCount > 0) {
                    itemList = String.valueOf(itemList) + IDENTIFIER_DELIMITER + selectedItems[0].getText() + IDENTIFIER_DELIMITER;
                    int index2 = 1;
                    while (index2 < selectedItemCount) {
                        itemList = String.valueOf(itemList) + ", " + IDENTIFIER_DELIMITER + selectedItems[index2].getText() + IDENTIFIER_DELIMITER;
                        ++index2;
                    }
                    predicate = String.valueOf(IN_PREDICATE_TEXT) + "(" + itemList + ")";
                    if (this.selectionPredicate.getItem(this.selectionPredicate.getSelectionIndex()).equals(this.EXCLUDE_ITEMS_TEXT)) {
                        predicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + predicate;
                    }
                }
            }
        }
        return predicate;
    }

    public String getPredicates() {
        String predicates = "";
        if (this.isFilterSpecified()) {
            if (!this.hideExpressionOption && this.expressionRadioButton.getSelection()) {
                String[] operators = this.columnTable.getOperators();
                String[] values = this.columnTable.getValues();
                String condition = null;
                String SQLPredicate = "";
                condition = this.columnTable.isAnded() ? "AND" : "OR";
                int i = 0;
                while (i < operators.length) {
                    if (operators[i].equals(this.STARTS_WITH_TEXT)) {
                        SQLPredicate = String.valueOf(LIKE_PREDICATE_TEXT) + " " + IDENTIFIER_DELIMITER + values[i] + "%" + IDENTIFIER_DELIMITER;
                    } else if (operators[i].equals(this.NOT_START_WITH_TEXT)) {
                        SQLPredicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + LIKE_PREDICATE_TEXT + " " + IDENTIFIER_DELIMITER + values[i] + "%" + IDENTIFIER_DELIMITER;
                    } else if (operators[i].equals(this.CONTAINS_TEXT)) {
                        SQLPredicate = String.valueOf(LIKE_PREDICATE_TEXT) + " " + IDENTIFIER_DELIMITER + "%" + values[i] + "%" + IDENTIFIER_DELIMITER;
                    } else if (operators[i].equals(this.NOT_CONTAIN_TEXT)) {
                        SQLPredicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + LIKE_PREDICATE_TEXT + " " + IDENTIFIER_DELIMITER + "%" + values[i] + "%" + IDENTIFIER_DELIMITER;
                    } else if (operators[i].equals(this.ENDS_WITH_TEXT)) {
                        SQLPredicate = String.valueOf(LIKE_PREDICATE_TEXT) + " " + IDENTIFIER_DELIMITER + "%" + values[i] + IDENTIFIER_DELIMITER;
                    } else if (operators[i].equals(this.NOT_END_WITH_TEXT)) {
                        SQLPredicate = String.valueOf(NOT_PREDICATE_TEXT) + " " + LIKE_PREDICATE_TEXT + " " + IDENTIFIER_DELIMITER + "%" + values[i] + IDENTIFIER_DELIMITER;
                    }
                    predicates = operators.length == 1 ? SQLPredicate : String.valueOf(predicates) + " {" + i + "} " + SQLPredicate;
                    if (i + 1 != operators.length) {
                        predicates = String.valueOf(predicates) + " " + condition;
                    }
                    ++i;
                }
            } else if (!this.hideSelectionOption) {
                String itemList = "";
                TableItem[] items = this.selectionTable.getItems();
                Vector<TableItem> selectedItemsCollection = new Vector<TableItem>();
                int itemCount = items.length;
                int index = 0;
                while (index < itemCount) {
                    if (items[index].getChecked()) {
                        selectedItemsCollection.add(items[index]);
                    }
                    ++index;
                }
                Object[] selectedItems = new TableItem[selectedItemsCollection.size()];
                selectedItemsCollection.copyInto(selectedItems);
                int selectedItemCount = selectedItems.length;
                if (selectedItemCount > 0) {
                    itemList = String.valueOf(itemList) + IDENTIFIER_DELIMITER + selectedItems[0].getText() + IDENTIFIER_DELIMITER;
                    int index2 = 1;
                    while (index2 < selectedItemCount) {
                        itemList = String.valueOf(itemList) + ", " + IDENTIFIER_DELIMITER + selectedItems[index2].getText() + IDENTIFIER_DELIMITER;
                        ++index2;
                    }
                    predicates = String.valueOf(IN_PREDICATE_TEXT) + "(" + itemList + ")";
                    if (this.selectionPredicate.getItem(this.selectionPredicate.getSelectionIndex()).equals(this.EXCLUDE_ITEMS_TEXT)) {
                        predicates = String.valueOf(NOT_PREDICATE_TEXT) + " " + predicates;
                    }
                }
            }
        }
        return predicates.trim();
    }

    public boolean isFilterSpecified() {
        return !this.disableFilterCheckbox.getSelection();
    }

    public boolean isIncludeSelected() {
        return this.selectionPredicate.getItem(this.selectionPredicate.getSelectionIndex()).equals(this.INCLUDE_ITEMS_TEXT);
    }

    private EObject getParentEObject(Object current) {
        while (!(current instanceof EObject) && (current = ((IVirtualNode)current).getParent()) != null) {
        }
        return (EObject)current;
    }

    public void populateSelectionTable() {
        this.populateSelectionTableWithBusyCursor();
    }

    public void populateSelectionTable(Table selectionTable) {
        if (this.selection != null) {
            Object sel = ((StructuredSelection)this.selection).getFirstElement();
            selectionTable.removeAll();
            if (sel instanceof IVirtualNode) {
                ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
                EObject schema = this.getParentEObject(sel);
                Collection viewsCollection = containmentService.getContainedDisplayableElements(schema, ((IVirtualNode)sel).getGroupID());
                ArrayList viewsList = new ArrayList(viewsCollection);
                Collections.sort(viewsList, new Comparator(){

                    public int compare(Object sqlObject1, Object sqlObject2) {
                        return ConnectionFilterComposite.this.collator.getCollationKey(((SQLObject)sqlObject1).getName()).compareTo(ConnectionFilterComposite.this.collator.getCollationKey(((SQLObject)sqlObject2).getName()));
                    }
                });
                Iterator views = viewsList.iterator();
                while (views.hasNext()) {
                    TableItem tableItem = new TableItem(selectionTable, 0);
                    tableItem.setText(((SQLObject)views.next()).getName());
                }
            }
        }
    }

    private void populateSelectionTableWithBusyCursor() {
        try {
            try {
                Cursor waitCursor = new Cursor((Device)this.getShell().getDisplay(), 1);
                this.getShell().setCursor(waitCursor);
                this.connectionFilterProvider.populateSelectionTable(this.selectionTable);
                this.isSelectionListPopulated = true;
            }
            catch (Exception exception) {
                this.getShell().setCursor(null);
            }
        }
        finally {
            this.getShell().setCursor(null);
        }
    }

    public boolean isHideExpressionOption() {
        return this.hideExpressionOption;
    }

    public boolean isHideSelectionOption() {
        return this.hideSelectionOption;
    }

    public void performDefaults() {
        this.disableFilterCheckbox.setSelection(true);
        if (!this.isMultiplePredicatesMode) {
            this.expressionField.setText("");
            this.expressionPredicate.select(0);
        } else {
            this.columnTable.performDefaults();
        }
        if (!this.hideSelectionOption) {
            this.selectionTable.removeAll();
            this.selectionPredicate.select(0);
            this.selectionRadioButton.setSelection(false);
        }
        this.expressionRadioButton.setSelection(true);
        this.enableFilterSpecificationControls(false);
        this.isSelectionListPopulated = false;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

