/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiScope;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiScope;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.pde.api.tools.ui.internal.actions.DeltaSession;

public class CompareOperation
extends Job {
    private IApiBaseline baseline = null;
    private IStructuredSelection selection = null;

    public CompareOperation(IApiBaseline baseline, IStructuredSelection selection) {
        super(ActionMessages.CompareWithAction_comparing_apis);
        this.baseline = baseline;
        Assert.isNotNull((Object)this.baseline);
        this.selection = selection;
    }

    protected IStatus run(IProgressMonitor monitor) {
        block10: {
            monitor.beginTask(ActionMessages.CompareDialogCollectingElementTaskName, -1);
            String baselineName = this.baseline.getName();
            ApiScope scope = CompareOperation.walkStructureSelection(this.selection, monitor);
            try {
                IDelta delta;
                block9: {
                    monitor.subTask(ActionMessages.CompareDialogComputeDeltasTaskName);
                    try {
                        delta = ApiComparator.compare((IApiScope)scope, (IApiBaseline)this.baseline, (int)1, (boolean)false, (IProgressMonitor)monitor);
                        if (delta != null) break block9;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (CoreException e) {
                        ApiPlugin.log((Throwable)e);
                        break block10;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        break block10;
                    }
                }
                int size = this.selection.size();
                String description = NLS.bind((String)ActionMessages.CompareWithAction_compared_with_against, (Object[])new Object[]{new Integer(size), baselineName, new Integer(delta.getChildren().length)});
                if (size == 1) {
                    description = NLS.bind((String)ActionMessages.CompareWithAction_compared_project_with, (Object[])new Object[]{((IJavaElement)this.selection.getFirstElement()).getElementName(), baselineName, new Integer(delta.getChildren().length)});
                }
                ApiPlugin.getDefault().getSessionManager().addSession((ISession)new DeltaSession(description, delta, baselineName), true);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
        return Status.CANCEL_STATUS;
    }

    public static ApiScope walkStructureSelection(IStructuredSelection structuredSelection, IProgressMonitor monitor) {
        Object[] selected = structuredSelection.toArray();
        ApiScope scope = new ApiScope();
        IApiBaseline workspaceBaseline = ApiBaselineManager.getManager().getWorkspaceBaseline();
        if (workspaceBaseline == null) {
            return scope;
        }
        Arrays.sort(selected, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IJavaElement && o2 instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)o1;
                    IJavaElement element2 = (IJavaElement)o2;
                    return element.getElementType() - element2.getElementType();
                }
                return 0;
            }
        });
        int length = selected.length;
        int i = 0;
        while (i < length) {
            Object currentSelection = selected[i];
            if (currentSelection instanceof IJavaElement) {
                IJavaElement element = (IJavaElement)currentSelection;
                IJavaProject javaProject = element.getJavaProject();
                try {
                    switch (element.getElementType()) {
                        case 5: {
                            ICompilationUnit compilationUnit = (ICompilationUnit)element;
                            IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                            if (apiComponent != null) {
                                CompareOperation.addElementFor(compilationUnit, apiComponent, scope);
                            }
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)element;
                            IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                            IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)fragment.getAncestor(3);
                            boolean isArchive = false;
                            if (packageFragmentRoot != null) {
                                isArchive = packageFragmentRoot.isArchive();
                            }
                            if (apiComponent != null) {
                                CompareOperation.addElementFor(fragment, isArchive, apiComponent, scope);
                            }
                            break;
                        }
                        case 3: {
                            IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)element;
                            IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                            if (apiComponent != null) {
                                CompareOperation.addElementFor(fragmentRoot, apiComponent, scope);
                            }
                            break;
                        }
                        case 2: {
                            IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                            if (apiComponent == null) break;
                            scope.add((IApiElement)apiComponent);
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (JavaModelException e) {
                    ApiPlugin.log((Throwable)e);
                }
                catch (CoreException e) {
                    ApiPlugin.log((Throwable)e);
                }
            }
            ++i;
        }
        return scope;
    }

    private static void addElementFor(IPackageFragmentRoot fragmentRoot, IApiComponent apiComponent, ApiScope scope) throws JavaModelException, CoreException {
        boolean isArchive = fragmentRoot.isArchive();
        IJavaElement[] packageFragments = fragmentRoot.getChildren();
        int j = 0;
        int max2 = packageFragments.length;
        while (j < max2) {
            IPackageFragment packageFragment = (IPackageFragment)packageFragments[j];
            CompareOperation.addElementFor(packageFragment, isArchive, apiComponent, scope);
            ++j;
        }
    }

    private static void addElementFor(IPackageFragment packageFragment, boolean isArchive, IApiComponent apiComponent, ApiScope scope) throws JavaModelException, CoreException {
        IApiDescription apiDescription = apiComponent.getApiDescription();
        IApiAnnotations annotations = apiDescription.resolveAnnotations((IElementDescriptor)Factory.packageDescriptor((String)packageFragment.getElementName()));
        if (annotations == null || !VisibilityModifiers.isAPI((int)annotations.getVisibility())) {
            return;
        }
        if (isArchive) {
            IClassFile[] classFiles = packageFragment.getClassFiles();
            int i = 0;
            int max = classFiles.length;
            while (i < max) {
                CompareOperation.addElementFor(classFiles[i], apiComponent, scope);
                ++i;
            }
        } else {
            ICompilationUnit[] units = packageFragment.getCompilationUnits();
            int i = 0;
            int max = units.length;
            while (i < max) {
                CompareOperation.addElementFor(units[i], apiComponent, scope);
                ++i;
            }
        }
    }

    private static void addElementFor(IClassFile classFile, IApiComponent apiComponent, ApiScope scope) {
        try {
            IApiTypeRoot typeRoot = apiComponent.findTypeRoot(classFile.getType().getFullyQualifiedName());
            if (typeRoot != null) {
                scope.add((IApiElement)typeRoot);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log((Throwable)e);
        }
    }

    private static void addElementFor(ICompilationUnit compilationUnit, IApiComponent component, ApiScope scope) throws JavaModelException {
        IType[] types = compilationUnit.getTypes();
        int i = 0;
        int max = types.length;
        while (i < max) {
            try {
                IApiTypeRoot typeRoot = component.findTypeRoot(types[i].getFullyQualifiedName());
                if (typeRoot != null) {
                    scope.add((IApiElement)typeRoot);
                }
            }
            catch (CoreException e) {
                ApiPlugin.log((Throwable)e);
            }
            ++i;
        }
    }
}

