/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.progress.UIJob;

public class OpenPropertyPageResolution
implements IMarkerResolution2 {
    private String fPageName = null;
    private String fPageId = null;
    private IAdaptable fElement = null;

    public OpenPropertyPageResolution(String pagename, String pageid, IAdaptable element) {
        Assert.isNotNull((Object)pagename, (String)MarkerMessages.OpenPropertyPageResolution_the_page_name_cannot_be_null);
        this.fPageName = pagename;
        Assert.isNotNull((Object)pageid, (String)MarkerMessages.OpenPropertyPageResolution_page_id_cannot_be_null);
        this.fPageId = pageid;
        Assert.isNotNull((Object)element, (String)MarkerMessages.OpenPropertyPageResolution_element_cannot_be_null);
        this.fElement = element;
    }

    public String getDescription() {
        return NLS.bind((String)MarkerMessages.OpenPropertyPageResolution_opens_the_property_page, (Object)this.fPageName);
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_OPEN_PAGE");
    }

    public String getLabel() {
        return NLS.bind((String)MarkerMessages.OpenPropertyPageResolution_open_the_property_page, (Object)this.fPageName);
    }

    public void run(IMarker marker) {
        UIJob job = new UIJob(MarkerMessages.OpenPropertyPageResolution_opening_property_page_job_name){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SWTFactory.showPropertiesDialog(ApiUIPlugin.getShell(), OpenPropertyPageResolution.this.fPageId, OpenPropertyPageResolution.this.fElement, null);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }
}

