/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.ui.progress.UIJob;

public class CreateApiFilterOperation
extends UIJob {
    private IMarker[] fMarkers = null;

    public CreateApiFilterOperation(IMarker[] markers) {
        super(MarkerMessages.CreateApiFilterOperation_0);
        this.fMarkers = markers;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            HashMap<IProject, HashSet> map = new HashMap<IProject, HashSet>(this.fMarkers.length);
            IResource resource = null;
            IProject project = null;
            IMarker marker = null;
            IApiProblem problem = null;
            HashSet problems = null;
            int i = 0;
            while (i < this.fMarkers.length) {
                marker = this.fMarkers[i];
                resource = marker.getResource();
                project = resource.getProject();
                if (project == null) {
                    return Status.CANCEL_STATUS;
                }
                problems = (HashSet)map.get(project);
                if (problems == null) {
                    problems = new HashSet();
                    map.put(project, problems);
                }
                String typeNameFromMarker = Util.getTypeNameFromMarker((IMarker)marker);
                problem = ApiProblemFactory.newApiProblem((String)resource.getProjectRelativePath().toPortableString(), (String)typeNameFromMarker, (String[])this.getMessageArgumentsFromMarker(marker), null, null, (int)marker.getAttribute("lineNumber", -1), (int)marker.getAttribute("charStart", -1), (int)marker.getAttribute("charEnd", -1), (int)marker.getAttribute("problemid", 0));
                problems.add(problem);
                Util.touchCorrespondingResource((IProject)project, (IResource)resource, (String)typeNameFromMarker);
                ++i;
            }
            IApiComponent component = null;
            Set pjs = map.keySet();
            Iterator iter = pjs.iterator();
            while (iter.hasNext()) {
                project = (IProject)iter.next();
                component = ApiPlugin.getDefault().getApiBaselineManager().getWorkspaceBaseline().getApiComponent(project);
                if (component == null) {
                    return Status.CANCEL_STATUS;
                }
                IApiFilterStore store = component.getFilterStore();
                problems = (HashSet)map.get(project);
                if (problems == null) continue;
                store.addFiltersFor(problems.toArray(new IApiProblem[problems.size()]));
            }
            if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                Util.getBuildJob((IProject[])pjs.toArray(new IProject[pjs.size()]), (int)10).schedule();
            }
            return Status.OK_STATUS;
        }
        catch (CoreException ce) {
            ApiUIPlugin.log(ce);
            return Status.CANCEL_STATUS;
        }
    }

    private String[] getMessageArgumentsFromMarker(IMarker marker) {
        ArrayList args = new ArrayList();
        String arguments = marker.getAttribute("messagearguments", null);
        if (arguments != null) {
            return arguments.split("#");
        }
        return args.toArray(new String[args.size()]);
    }
}

