/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.eclipselink.core.resource.java.TimeOfDayAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceTimeOfDayAnnotation
extends SourceAnnotation<Type>
implements TimeOfDayAnnotation {
    private final DeclarationAnnotationElementAdapter<Integer> hourDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> hourAdapter;
    private Integer hour;
    private final DeclarationAnnotationElementAdapter<Integer> minuteDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> minuteAdapter;
    private Integer minute;
    private final DeclarationAnnotationElementAdapter<Integer> secondDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> secondAdapter;
    private Integer second;
    private final DeclarationAnnotationElementAdapter<Integer> millisecondDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> millisecondAdapter;
    private Integer millisecond;

    public SourceTimeOfDayAnnotation(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter daa) {
        super(parent, (Member)type, daa);
        this.hourDeclarationAdapter = SourceTimeOfDayAnnotation.buildHourAdapter(daa);
        this.hourAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, this.hourDeclarationAdapter);
        this.minuteDeclarationAdapter = SourceTimeOfDayAnnotation.buildMinuteAdapter(daa);
        this.minuteAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, this.minuteDeclarationAdapter);
        this.secondDeclarationAdapter = SourceTimeOfDayAnnotation.buildSecondAdapter(daa);
        this.secondAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, this.secondDeclarationAdapter);
        this.millisecondDeclarationAdapter = SourceTimeOfDayAnnotation.buildMillisecondAdapter(daa);
        this.millisecondAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, this.millisecondDeclarationAdapter);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.TimeOfDay";
    }

    public void initialize(CompilationUnit astRoot) {
        this.hour = this.buildHour(astRoot);
        this.minute = this.buildMinute(astRoot);
        this.second = this.buildSecond(astRoot);
        this.millisecond = this.buildMillisecond(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setHour(this.buildHour(astRoot));
        this.setMinute(this.buildMinute(astRoot));
        this.setSecond(this.buildSecond(astRoot));
        this.setMillisecond(this.buildMillisecond(astRoot));
    }

    @Override
    public Integer getHour() {
        return this.hour;
    }

    @Override
    public void setHour(Integer hour) {
        if (this.attributeValueHasNotChanged(this.hour, hour)) {
            return;
        }
        Integer old = this.hour;
        this.hour = hour;
        this.hourAdapter.setValue((Object)hour);
        this.firePropertyChanged("hour", old, hour);
    }

    private Integer buildHour(CompilationUnit astRoot) {
        return (Integer)this.hourAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getHourTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.hourDeclarationAdapter, astRoot);
    }

    @Override
    public Integer getMinute() {
        return this.minute;
    }

    @Override
    public void setMinute(Integer newMinute) {
        if (this.attributeValueHasNotChanged(this.minute, newMinute)) {
            return;
        }
        Integer oldMinute = this.minute;
        this.minute = newMinute;
        this.minuteAdapter.setValue((Object)newMinute);
        this.firePropertyChanged("minute", oldMinute, newMinute);
    }

    private Integer buildMinute(CompilationUnit astRoot) {
        return (Integer)this.minuteAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getMinuteTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.minuteDeclarationAdapter, astRoot);
    }

    @Override
    public Integer getSecond() {
        return this.second;
    }

    @Override
    public void setSecond(Integer newSecond) {
        if (this.attributeValueHasNotChanged(this.second, newSecond)) {
            return;
        }
        Integer oldSecond = this.second;
        this.second = newSecond;
        this.secondAdapter.setValue((Object)newSecond);
        this.firePropertyChanged("second", oldSecond, newSecond);
    }

    private Integer buildSecond(CompilationUnit astRoot) {
        return (Integer)this.secondAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSecondTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.secondDeclarationAdapter, astRoot);
    }

    @Override
    public Integer getMillisecond() {
        return this.millisecond;
    }

    @Override
    public void setMillisecond(Integer newMillisecond) {
        if (this.attributeValueHasNotChanged(this.millisecond, newMillisecond)) {
            return;
        }
        Integer oldMillisecond = this.millisecond;
        this.millisecond = newMillisecond;
        this.millisecondAdapter.setValue((Object)newMillisecond);
        this.firePropertyChanged("millisecond", oldMillisecond, newMillisecond);
    }

    private Integer buildMillisecond(CompilationUnit astRoot) {
        return (Integer)this.millisecondAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getMillisecondTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.millisecondDeclarationAdapter, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildHourAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "hour", false, NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildMinuteAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "minute", false, NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildSecondAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "second", false, NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildMillisecondAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "millisecond", false, NumberIntegerExpressionConverter.instance());
    }
}

