/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceNamedConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceConverterAnnotation
extends SourceNamedConverterAnnotation
implements ConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Converter");
    private static final DeclarationAnnotationElementAdapter<String> CONVERTER_CLASS_ADAPTER = SourceConverterAnnotation.buildConverterClassAdapter();
    private final AnnotationElementAdapter<String> converterClassAdapter;
    private String converterClass;

    public SourceConverterAnnotation(JavaResourcePersistentMember parent, Member member) {
        super((JavaResourceNode)parent, member, DECLARATION_ANNOTATION_ADAPTER);
        this.converterClassAdapter = new ShortCircuitAnnotationElementAdapter(member, CONVERTER_CLASS_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Converter";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.converterClass = this.buildConverterClass(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setConverterClass(this.buildConverterClass(astRoot));
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String converterClass) {
        if (this.attributeValueHasNotChanged(this.converterClass, converterClass)) {
            return;
        }
        String old = this.converterClass;
        this.converterClass = converterClass;
        this.converterClassAdapter.setValue((Object)converterClass);
        this.firePropertyChanged("converterClass", old, converterClass);
    }

    private String buildConverterClass(CompilationUnit astRoot) {
        return (String)this.converterClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getConverterClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(CONVERTER_CLASS_ADAPTER, astRoot);
    }

    @Override
    public boolean converterClassImplementsInterface(String interfaceName, CompilationUnit astRoot) {
        return this.converterClass != null && JDTTools.typeIsSubTypeOf((Expression)this.converterClassAdapter.getExpression(astRoot), (String)interfaceName);
    }

    private static DeclarationAnnotationElementAdapter<String> buildConverterClassAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "converterClass", false, SimpleTypeStringExpressionConverter.instance());
    }
}

