/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.ReadOnly;
import org.eclipse.jpt.eclipselink.core.resource.java.ReadOnlyAnnotation;

public class EclipseLinkJavaReadOnly
extends AbstractJavaJpaContextNode
implements ReadOnly {
    protected Boolean specifiedReadOnly;
    protected JavaResourcePersistentType resourcePersistentType;

    public EclipseLinkJavaReadOnly(JavaTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    protected String getReadOnlyAnnotationName() {
        return "org.eclipse.persistence.annotations.ReadOnly";
    }

    protected ReadOnlyAnnotation getResourceReadOnly() {
        return (ReadOnlyAnnotation)this.resourcePersistentType.getSupportingAnnotation(this.getReadOnlyAnnotationName());
    }

    protected void addResourceReadOnly() {
        this.resourcePersistentType.addSupportingAnnotation(this.getReadOnlyAnnotationName());
    }

    protected void removeResourceReadOnly() {
        this.resourcePersistentType.removeSupportingAnnotation(this.getReadOnlyAnnotationName());
    }

    public boolean isReadOnly() {
        return this.getSpecifiedReadOnly() != null ? this.getSpecifiedReadOnly().booleanValue() : this.isDefaultReadOnly();
    }

    public boolean isDefaultReadOnly() {
        return false;
    }

    public Boolean getSpecifiedReadOnly() {
        return this.specifiedReadOnly;
    }

    public void setSpecifiedReadOnly(Boolean newReadOnly) {
        if (this.specifiedReadOnly == newReadOnly) {
            return;
        }
        Boolean oldReadOnly = this.specifiedReadOnly;
        this.specifiedReadOnly = newReadOnly;
        if (newReadOnly != null && newReadOnly.booleanValue()) {
            this.addResourceReadOnly();
        } else if (this.getResourceReadOnly() != null) {
            this.removeResourceReadOnly();
        }
        this.firePropertyChanged("specifiedReadOnly", oldReadOnly, newReadOnly);
    }

    protected void setSpecifiedReadOnly_(Boolean newReadOnly) {
        Boolean oldReadOnly = this.specifiedReadOnly;
        this.specifiedReadOnly = newReadOnly;
        this.firePropertyChanged("specifiedReadOnly", oldReadOnly, newReadOnly);
    }

    public void initialize(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.specifiedReadOnly = this.readOnly();
    }

    public void update(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.setSpecifiedReadOnly_(this.readOnly());
    }

    private Boolean readOnly() {
        return this.getResourceReadOnly() == null ? null : Boolean.TRUE;
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        ReadOnlyAnnotation resourceReadOnly = this.getResourceReadOnly();
        return resourceReadOnly == null ? null : resourceReadOnly.getTextRange(astRoot);
    }
}

