/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.eclipselink.core.context.ConversionValue;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaConversionValue;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaObjectTypeConverter
extends EclipseLinkJavaConverter
implements ObjectTypeConverter {
    private String dataType;
    private String objectType;
    private String defaultObjectValue;
    private final List<EclipseLinkJavaConversionValue> conversionValues = new ArrayList<EclipseLinkJavaConversionValue>();

    public EclipseLinkJavaObjectTypeConverter(JavaJpaContextNode parent) {
        super(parent);
    }

    @Override
    public String getType() {
        return "objectTypeConverter";
    }

    @Override
    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ObjectTypeConverter";
    }

    @Override
    protected ObjectTypeConverterAnnotation getAnnotation() {
        return (ObjectTypeConverterAnnotation)super.getAnnotation();
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        this.getAnnotation().setDataType(newDataType);
        this.firePropertyChanged("dataType", oldDataType, newDataType);
    }

    protected void setDataType_(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        this.firePropertyChanged("dataType", oldDataType, newDataType);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        this.getAnnotation().setObjectType(newObjectType);
        this.firePropertyChanged("objectType", oldObjectType, newObjectType);
    }

    protected void setObjectType_(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        this.firePropertyChanged("objectType", oldObjectType, newObjectType);
    }

    public ListIterator<EclipseLinkJavaConversionValue> conversionValues() {
        return new CloneListIterator(this.conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.conversionValues.size();
    }

    @Override
    public EclipseLinkJavaConversionValue addConversionValue(int index) {
        EclipseLinkJavaConversionValue conversionValue = new EclipseLinkJavaConversionValue(this);
        this.conversionValues.add(index, conversionValue);
        ConversionValueAnnotation resourceConversionValue = this.getAnnotation().addConversionValue(index);
        conversionValue.initialize(resourceConversionValue);
        this.fireItemAdded("conversionValues", index, conversionValue);
        return conversionValue;
    }

    @Override
    public EclipseLinkJavaConversionValue addConversionValue() {
        return this.addConversionValue(this.conversionValues.size());
    }

    protected void addConversionValue(int index, EclipseLinkJavaConversionValue conversionValue) {
        this.addItemToList(index, conversionValue, this.conversionValues, "conversionValues");
    }

    protected void addConversionValue(EclipseLinkJavaConversionValue conversionValue) {
        this.addConversionValue(this.conversionValues.size(), conversionValue);
    }

    @Override
    public void removeConversionValue(ConversionValue conversionValue) {
        this.removeConversionValue(this.conversionValues.indexOf(conversionValue));
    }

    @Override
    public void removeConversionValue(int index) {
        EclipseLinkJavaConversionValue removedConversionValue = this.conversionValues.remove(index);
        this.getAnnotation().removeConversionValue(index);
        this.fireItemRemoved("conversionValues", index, removedConversionValue);
    }

    protected void removeConversionValue_(EclipseLinkJavaConversionValue conversionValue) {
        this.removeItemFromList(conversionValue, this.conversionValues, "conversionValues");
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.conversionValues, (int)targetIndex, (int)sourceIndex);
        this.getAnnotation().moveConversionValue(targetIndex, sourceIndex);
        this.fireItemMoved("conversionValues", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<String> dataValues() {
        return new TransformationListIterator<EclipseLinkJavaConversionValue, String>(this.conversionValues()){

            protected String transform(EclipseLinkJavaConversionValue next) {
                return next.getDataValue();
            }
        };
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        this.getAnnotation().setDefaultObjectValue(newDefaultObjectValue);
        this.firePropertyChanged("defaultObjectValue", oldDefaultObjectValue, newDefaultObjectValue);
    }

    protected void setDefaultObjectValue_(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        this.firePropertyChanged("defaultObjectValue", oldDefaultObjectValue, newDefaultObjectValue);
    }

    @Override
    protected void initialize(JavaResourcePersistentMember jrpm) {
        super.initialize(jrpm);
        ObjectTypeConverterAnnotation resourceConverter = this.getAnnotation();
        this.dataType = this.dataType(resourceConverter);
        this.objectType = this.objectType(resourceConverter);
        this.defaultObjectValue = this.defaultObjectValue(resourceConverter);
        this.initializeConversionValues(resourceConverter);
    }

    protected void initializeConversionValues(ObjectTypeConverterAnnotation resourceConverter) {
        if (resourceConverter == null) {
            return;
        }
        ListIterator<ConversionValueAnnotation> resourceConversionValues = resourceConverter.conversionValues();
        while (resourceConversionValues.hasNext()) {
            this.conversionValues.add(this.buildConversionValue(resourceConversionValues.next()));
        }
    }

    protected EclipseLinkJavaConversionValue buildConversionValue(ConversionValueAnnotation resourceConversionValue) {
        EclipseLinkJavaConversionValue conversionValue = new EclipseLinkJavaConversionValue(this);
        conversionValue.initialize(resourceConversionValue);
        return conversionValue;
    }

    @Override
    public void update(JavaResourcePersistentMember jrpm) {
        super.update(jrpm);
        ObjectTypeConverterAnnotation resourceConverter = this.getAnnotation();
        this.setDataType_(this.dataType(resourceConverter));
        this.setObjectType_(this.objectType(resourceConverter));
        this.setDefaultObjectValue_(this.defaultObjectValue(resourceConverter));
        this.updateConversionValues(resourceConverter);
    }

    protected void updateConversionValues(ObjectTypeConverterAnnotation resourceConverter) {
        ListIterator<EclipseLinkJavaConversionValue> contextConversionValues = this.conversionValues();
        ListIterator<ConversionValueAnnotation> resourceConversionValues = resourceConverter.conversionValues();
        while (contextConversionValues.hasNext()) {
            EclipseLinkJavaConversionValue conversionValues = contextConversionValues.next();
            if (resourceConversionValues.hasNext()) {
                conversionValues.update(resourceConversionValues.next());
                continue;
            }
            this.removeConversionValue_(conversionValues);
        }
        while (resourceConversionValues.hasNext()) {
            this.addConversionValue(this.buildConversionValue(resourceConversionValues.next()));
        }
    }

    protected String dataType(ObjectTypeConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getDataType();
    }

    protected String objectType(ObjectTypeConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getObjectType();
    }

    protected String defaultObjectValue(ObjectTypeConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getDefaultObjectValue();
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        ListIterator<EclipseLinkJavaConversionValue> stream = this.conversionValues();
        while (stream.hasNext()) {
            ((EclipseLinkJavaConversionValue)stream.next()).validate(messages, reporter, astRoot);
        }
    }
}

