/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class DefaultEclipseLinkJpaValidationMessages {
    private static String[] DEFAULT_PARMS = new String[0];
    private static TextRange DEFAULT_TEXT_RANGE = TextRange.Empty.instance();

    public static IMessage buildMessage(int severity, String messageId, Object targetObject) {
        return DefaultEclipseLinkJpaValidationMessages.buildMessage(severity, messageId, DEFAULT_PARMS, targetObject);
    }

    public static IMessage buildMessage(int severity, String messageId, String[] parms, Object targetObject) {
        return DefaultEclipseLinkJpaValidationMessages.buildMessage(severity, messageId, parms, targetObject, DEFAULT_TEXT_RANGE);
    }

    public static IMessage buildMessage(int severity, String messageId, Object targetObject, TextRange textRange) {
        return DefaultEclipseLinkJpaValidationMessages.buildMessage(severity, messageId, DEFAULT_PARMS, targetObject, textRange);
    }

    public static IMessage buildMessage(int severity, String messageId, String[] parms, Object targetObject, TextRange textRange) {
        EclipseLinkMessage message = new EclipseLinkMessage("eclipselink_jpa_validation", severity, messageId, parms, targetObject);
        if (textRange == null) {
            JptCorePlugin.log((Throwable)new IllegalArgumentException("Null text range for message ID: " + messageId));
        } else {
            message.setLineNo(textRange.getLineNumber());
            message.setOffset(textRange.getOffset());
            message.setLength(textRange.getLength());
        }
        return message;
    }

    private DefaultEclipseLinkJpaValidationMessages() {
        throw new UnsupportedOperationException();
    }

    private static class EclipseLinkMessage
    extends Message {
        public EclipseLinkMessage(String aBundleName, int aSeverity, String anId, String[] aParams, Object aTargetObject) {
            super(aBundleName, aSeverity, anId, aParams, aTargetObject);
        }

        public ResourceBundle getBundle(Locale locale, ClassLoader classLoader) {
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(this.getBundleName(), locale, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (MissingResourceException missingResourceException) {
                return super.getBundle(locale, classLoader);
            }
            return bundle;
        }
    }
}

