/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.processes.servicesubsystem;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.processes.IProcessService;
import org.eclipse.rse.subsystems.processes.core.subsystem.IHostProcessToRemoteProcessAdapter;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessContext;
import org.eclipse.rse.subsystems.processes.core.subsystem.impl.RemoteProcessContext;
import org.eclipse.rse.subsystems.processes.core.subsystem.impl.RemoteProcessSubSystemImpl;
import org.eclipse.rse.subsystems.processes.servicesubsystem.IProcessServiceSubSystem;
import org.eclipse.rse.subsystems.processes.servicesubsystem.IProcessServiceSubSystemConfiguration;

public class ProcessServiceSubSystem
extends RemoteProcessSubSystemImpl
implements IProcessServiceSubSystem {
    protected IProcessService _hostProcessService;
    protected IHostProcessToRemoteProcessAdapter _hostProcessToRemoteProcessAdapter;
    static /* synthetic */ Class class$0;

    public ProcessServiceSubSystem(IHost host, IConnectorService connectorService, IProcessService hostProcessService, IHostProcessToRemoteProcessAdapter adapter) {
        super(host, connectorService);
        this._hostProcessService = hostProcessService;
        this._hostProcessToRemoteProcessAdapter = adapter;
    }

    public IProcessService getProcessService() {
        return this._hostProcessService;
    }

    public void setProcessService(IProcessService service) {
        this._hostProcessService = service;
    }

    public IHostProcessToRemoteProcessAdapter getHostProcessToRemoteProcessAdapter() {
        return this._hostProcessToRemoteProcessAdapter;
    }

    public void setHostProcessToRemoteProcessAdapter(IHostProcessToRemoteProcessAdapter hostProcessAdapter) {
        this._hostProcessToRemoteProcessAdapter = hostProcessAdapter;
    }

    public IRemoteProcess getRemoteProcessObject(long pid) throws SystemMessageException {
        this.checkIsConnected((IProgressMonitor)new NullProgressMonitor());
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setPid("" + pid);
        RemoteProcessContext context = new RemoteProcessContext(this, null, (IHostProcessFilter)rpfs);
        IHostProcess process = this.getProcessService().getProcess(pid, null);
        return this.getHostProcessToRemoteProcessAdapter().convertToRemoteProcess(context, null, process);
    }

    public String[] getSignalTypes() throws SystemMessageException {
        return this.getProcessService().getSignalTypes();
    }

    public boolean kill(IRemoteProcess process, String signal) throws SystemMessageException {
        this.checkIsConnected((IProgressMonitor)new NullProgressMonitor());
        return this.getProcessService().kill(process.getPid(), signal, null);
    }

    public IRemoteProcess[] listAllProcesses(IHostProcessFilter processFilter, IRemoteProcessContext context, IProgressMonitor monitor) throws InterruptedException, SystemMessageException {
        this.checkIsConnected(monitor);
        IHostProcess[] processes = this.getProcessService().listAllProcesses(processFilter, monitor);
        return this.getHostProcessToRemoteProcessAdapter().convertToRemoteProcesses(context, null, processes);
    }

    public IRemoteProcess[] listChildProcesses(IRemoteProcess parent, IHostProcessFilter processFilter, IRemoteProcessContext context, IProgressMonitor monitor) throws SystemMessageException {
        this.checkIsConnected(monitor);
        IHostProcess[] processes = this.getProcessService().listChildProcesses(parent.getPid(), processFilter, monitor);
        return this.getHostProcessToRemoteProcessAdapter().convertToRemoteProcesses(context, parent, processes);
    }

    public IRemoteProcess[] listChildProcesses(IRemoteProcess parent, IRemoteProcessContext context, IProgressMonitor monitor) throws SystemMessageException {
        this.checkIsConnected(monitor);
        IHostProcess[] processes = this.getProcessService().listChildProcesses(parent.getPid(), monitor);
        return this.getHostProcessToRemoteProcessAdapter().convertToRemoteProcesses(context, parent, processes);
    }

    protected void internalSwitchSubSystemConfiguration(ISubSystemConfiguration configuration) {
        IProcessServiceSubSystemConfiguration config = (IProcessServiceSubSystemConfiguration)configuration;
        IHost host = this.getHost();
        this.setProcessService(config.getProcessService(host));
        this.setHostProcessToRemoteProcessAdapter(config.getHostProcessAdapter());
    }

    public boolean canSwitchTo(ISubSystemConfiguration configuration) {
        return configuration instanceof IProcessServiceSubSystemConfiguration;
    }

    public Class getServiceType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.processes.IProcessService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        this.getProcessService().initService(monitor);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        this.getProcessService().uninitService(monitor);
        super.uninitializeSubSystem(monitor);
    }
}

