/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.internal.files.ui.view.DownloadAndOpenJob;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SystemEditFilesAction
extends SystemBaseAction {
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();

    public SystemEditFilesAction(String text, String tooltip, Shell parent) {
        super(text, tooltip, parent);
        this.init();
    }

    private void init() {
        this.allowOnMultipleSelection(true);
    }

    private IFile getLocalResource(IRemoteFile remoteFile) {
        return (IFile)UniversalFileTransferUtility.getTempFileFor(remoteFile);
    }

    protected IEditorDescriptor getDefaultEditor(IRemoteFile remoteFile) {
        IFile localFile = this.getLocalResource(remoteFile);
        if (localFile == null) {
            return this.registry.getDefaultEditor(remoteFile.getName());
        }
        return IDE.getDefaultEditor((IFile)localFile);
    }

    public void run() {
        IStructuredSelection selection = this.getSelection();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof IRemoteFile)) continue;
            this.process((IRemoteFile)obj);
        }
    }

    private boolean isFileCached(ISystemEditableRemoteObject editable, IRemoteFile remoteFile) {
        boolean newFile;
        IFile file = editable.getLocalResource();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        boolean bl = newFile = !file.exists();
        if (!newFile && file.exists()) {
            long storedModifiedStamp = properties.getRemoteFileTimeStamp();
            IRemoteFileSubSystem subsystem = remoteFile.getParentRemoteFileSubSystem();
            try {
                remoteFile = subsystem.getRemoteFileObject(remoteFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {}
            long remoteModifiedStamp = remoteFile.getLastModified();
            boolean dirty = properties.getDirty();
            boolean remoteNewer = storedModifiedStamp != remoteModifiedStamp;
            String remoteEncoding = remoteFile.getEncoding();
            String storedEncoding = properties.getEncoding();
            boolean encodingChanged = storedEncoding == null || !remoteEncoding.equals(storedEncoding);
            boolean usedBinary = properties.getUsedBinaryTransfer();
            boolean isBinary = remoteFile.isBinary();
            return !dirty && !remoteNewer && usedBinary == isBinary && !encodingChanged;
        }
        return false;
    }

    protected void process(IRemoteFile remoteFile) {
        SystemEditableRemoteFile editable;
        IEditorDescriptor des = this.getDefaultEditor(remoteFile);
        if (des != null) {
            des.getId();
        }
        if ((editable = SystemRemoteEditManager.getEditableRemoteObject(remoteFile, des)) == null) {
            return;
        }
        try {
            if (editable.checkOpenInEditor() != 0) {
                if (this.isFileCached(editable, remoteFile)) {
                    editable.openEditor();
                } else {
                    DownloadAndOpenJob oJob = new DownloadAndOpenJob(editable, false);
                    oJob.schedule();
                }
            } else {
                editable.setLocalResourceProperties();
                editable.openEditor();
            }
        }
        catch (Exception exception) {}
    }
}

