/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.view.ContextObject;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.IViewLinker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;

public class LinkWithSystemViewAction
implements IViewActionDelegate {
    private SystemViewPart _systemViewPart;
    private IAction _action;
    private IViewLinker _linker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void init(IViewPart view) {
        this._systemViewPart = (SystemViewPart)view;
        this._linker = new ViewLinker();
    }

    public void run(IAction action) {
        if (this._systemViewPart != null) {
            boolean isToggled = action.isChecked();
            this._systemViewPart.setLinkingEnabled(isToggled, this._linker);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this._action == null) {
            this._action = action;
            this._action.setChecked(this._systemViewPart.isLinkingEnabled());
        }
        if (this._systemViewPart.isLinkingEnabled() && !this._action.isChecked()) {
            this._action.setChecked(true);
            this._systemViewPart.setLinkingEnabled(true, this._linker);
        }
    }

    private class LinkFromFilterJob
    extends Job {
        private ISubSystem _subSystem;
        private IAdaptable _targetRemoteObj;
        private ISystemTree _systemTree;

        public LinkFromFilterJob(IAdaptable targetRemoteObject, ISystemTree systemTree) {
            super(FileResources.MESSAGE_EXPANDING_FILTER);
            this._targetRemoteObj = targetRemoteObject;
            this._subSystem = this.getSubSystem(this._targetRemoteObj);
            this._systemTree = systemTree;
        }

        private ISystemViewElementAdapter getAdapter(IAdaptable adaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz);
        }

        private ISubSystem getSubSystem(IAdaptable adaptable) {
            ISystemViewElementAdapter adapter = this.getAdapter(adaptable);
            return adapter.getSubSystem((Object)adaptable);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                ISystemFilterReference ref = this.findMatchingFilterReference();
                if (ref == null) {
                    return Status.OK_STATUS;
                }
                ContextObject contextObject = new ContextObject((Object)ref, this._subSystem, ref);
                Object[] children = this.getAdapter((IAdaptable)ref).getChildren((IContextObject)contextObject, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().asyncExec((Runnable)new ShowChildrenInTree(ref, children, ref, this._systemTree, this._targetRemoteObj));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }

        private ISystemFilterReference findMatchingFilterReference() {
            String remoteObjectName = this.getAbsolutePath(this._targetRemoteObj);
            ISystemFilterPoolReferenceManager refmgr = this._subSystem.getFilterPoolReferenceManager();
            if (refmgr != null) {
                ISystemFilterReference[] refs = refmgr.getSystemFilterReferences(this._subSystem);
                int i = 0;
                while (i < refs.length) {
                    ISystemFilterReference ref = refs[i];
                    if (this.doesFilterEncompass(ref.getReferencedFilter(), remoteObjectName)) {
                        return ref;
                    }
                    ++i;
                }
            }
            return null;
        }

        private String getAbsolutePath(IAdaptable adaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz);
            return adapter.getAbsoluteName((Object)adaptable);
        }

        private boolean doesFilterEncompass(ISystemFilter filter, String remoteObjectAbsoluteName) {
            boolean would = false;
            String[] strings = filter.getFilterStrings();
            if (strings != null) {
                int idx = 0;
                while (!would && idx < strings.length) {
                    if (strings[idx].equals("/*")) {
                        would = true;
                    } else if (strings[idx].equals("./*")) {
                        try {
                            IAdaptable homeObj = (IAdaptable)this._subSystem.getObjectWithAbsoluteName(".", (IProgressMonitor)new NullProgressMonitor());
                            if (homeObj != null) {
                                String homePath = this.getAbsolutePath(homeObj);
                                would = remoteObjectAbsoluteName.startsWith(homePath);
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        would = this.doesFilterStringEncompass(strings[idx], remoteObjectAbsoluteName);
                    }
                    ++idx;
                }
            }
            return would;
        }

        private boolean doesFilterStringEncompass(String filterString, String remoteObjectAbsoluteName) {
            if (this._subSystem instanceof IRemoteFileSubSystem) {
                RemoteFileFilterString rffs = new RemoteFileFilterString(((IRemoteFileSubSystem)this._subSystem).getParentRemoteFileSubSystemConfiguration(), filterString);
                if (remoteObjectAbsoluteName.endsWith(" -folder")) {
                    if (!rffs.getShowSubDirs()) {
                        return false;
                    }
                    remoteObjectAbsoluteName = remoteObjectAbsoluteName.substring(0, remoteObjectAbsoluteName.indexOf(" -folder"));
                }
                if (!rffs.getShowFiles()) {
                    return false;
                }
                String container = rffs.getPath();
                if (container == null) {
                    return false;
                }
                if (container.equals(".")) {
                    try {
                        IAdaptable containerObj = (IAdaptable)this._subSystem.getObjectWithAbsoluteName(container, (IProgressMonitor)new NullProgressMonitor());
                        if (containerObj != null) {
                            container = this.getAbsolutePath(containerObj);
                        }
                    }
                    catch (Exception exception) {}
                }
                if (remoteObjectAbsoluteName.startsWith(container)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class LinkFromFolderJob
    extends Job {
        private ISubSystem _subSystem;
        private IAdaptable _remoteFolder;
        private IAdaptable _targetRemoteObj;
        private ISystemTree _systemTree;
        private ISystemFilterReference _filterRef;
        private ISystemViewElementAdapter _adapter;

        public LinkFromFolderJob(IAdaptable remoteFolder, ISystemFilterReference filterRef, IAdaptable targetRemoteObj, ISystemTree systemTree) {
            super(FileResources.MESSAGE_EXPANDING_FOLDER);
            this._remoteFolder = remoteFolder;
            this._subSystem = this.getSubSystem(remoteFolder);
            this._filterRef = filterRef;
            this._targetRemoteObj = targetRemoteObj;
            this._systemTree = systemTree;
        }

        private ISubSystem getSubSystem(IAdaptable adaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz);
            return adapter.getSubSystem((Object)adaptable);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)this._remoteFolder.getAdapter((Class)clazz);
                ContextObject contextObject = new ContextObject((Object)this._remoteFolder, this._subSystem, this._filterRef);
                Object[] children = adapter.getChildren((IContextObject)contextObject, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().asyncExec((Runnable)new ShowChildrenInTree(this._remoteFolder, children, this._filterRef, this._systemTree, this._targetRemoteObj));
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }
    }

    private class SelectFileJob
    extends Job {
        private ISubSystem _subSystem;
        private String _path;
        private ISystemTree _systemTree;

        public SelectFileJob(ISubSystem subSystem, String path, ISystemTree systemTree) {
            super(FileResources.MESSSAGE_QUERYING_FILE);
            this._subSystem = subSystem;
            this._path = path;
            this._systemTree = systemTree;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IAdaptable remoteObj = (IAdaptable)this._subSystem.getObjectWithAbsoluteName(this._path, monitor);
                Display.getDefault().asyncExec(new Runnable(this, remoteObj){
                    final /* synthetic */ SelectFileJob this$1;
                    private final /* synthetic */ IAdaptable val$remoteObj;
                    {
                        this.this$1 = selectFileJob;
                        this.val$remoteObj = iAdaptable;
                    }

                    public void run() {
                        TreeItem item = (TreeItem)SelectFileJob.access$0(this.this$1).findFirstRemoteItemReference((Object)this.val$remoteObj, null);
                        if (item != null) {
                            SelectFileJob.access$0(this.this$1).getTree().setSelection(item);
                        } else {
                            LinkFromFilterJob job = SelectFileJob.access$1(this.this$1).new LinkFromFilterJob(this.val$remoteObj, SelectFileJob.access$0(this.this$1));
                            job.schedule();
                        }
                    }
                });
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }

        static /* synthetic */ ISystemTree access$0(SelectFileJob selectFileJob) {
            return selectFileJob._systemTree;
        }

        static /* synthetic */ LinkWithSystemViewAction access$1(SelectFileJob selectFileJob) {
            return selectFileJob.LinkWithSystemViewAction.this;
        }
    }

    private class ShowChildrenInTree
    implements Runnable {
        private Object _parentObject;
        private Object[] _children;
        private ISystemTree _systemTree;
        private IAdaptable _targetRemoteObj;
        private ISystemFilterReference _filterReference;

        public ShowChildrenInTree(Object parentObject, Object[] children, ISystemFilterReference filterReference, ISystemTree systemTree, IAdaptable targetRemoteObj) {
            this._parentObject = parentObject;
            this._children = children;
            this._systemTree = systemTree;
            this._targetRemoteObj = targetRemoteObj;
            this._filterReference = filterReference;
        }

        private String getAbsolutePath(IAdaptable adaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz);
            return adapter.getAbsoluteName((Object)adaptable);
        }

        public void run() {
            this._systemTree.revealAndExpand(this._filterReference.getSubSystem(), this._filterReference.getReferencedFilter());
            Vector matches = new Vector();
            this._systemTree.findAllRemoteItemReferences(this._parentObject, this._parentObject, matches);
            if (matches.size() > 0) {
                TreeItem item = (TreeItem)matches.get(0);
                this._systemTree.createTreeItems(item, this._children);
                item.setExpanded(true);
                IAdaptable containingFolder = null;
                int i = 0;
                while (i < item.getItemCount()) {
                    TreeItem childItem = item.getItem(i);
                    Object data = childItem.getData();
                    if (data instanceof IAdaptable) {
                        String targetPath;
                        IAdaptable childObj = (IAdaptable)data;
                        String childPath = this.getAbsolutePath(childObj);
                        if (childPath.equals(targetPath = this.getAbsolutePath(this._targetRemoteObj))) {
                            this._systemTree.getTree().setSelection(childItem);
                            return;
                        }
                        if (targetPath.startsWith(childPath)) {
                            containingFolder = childObj;
                        }
                    }
                    ++i;
                }
                if (containingFolder != null) {
                    LinkFromFolderJob job = new LinkFromFolderJob(containingFolder, this._filterReference, this._targetRemoteObj, this._systemTree);
                    job.schedule();
                }
            }
        }
    }

    public class ViewLinker
    implements IViewLinker {
        public void linkViewToEditor(Object remoteObject, IWorkbenchPage page) {
            Object obj = remoteObject;
            if (obj instanceof IAdaptable) {
                try {
                    ISystemRemoteElementAdapter adapter;
                    IAdaptable iAdaptable = (IAdaptable)obj;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null && adapter.canEdit(obj)) {
                        IEditorReference[] editorRefs = page.getEditorReferences();
                        int i = 0;
                        while (i < editorRefs.length) {
                            IEditorInput input;
                            IEditorReference editorRef = editorRefs[i];
                            IEditorPart editor = editorRef.getEditor(false);
                            if (editor != null && (input = editor.getEditorInput()) instanceof FileEditorInput) {
                                SystemIFileProperties properties;
                                String path;
                                ((FileEditorInput)input).getFile();
                                IFile file = ((FileEditorInput)input).getFile();
                                if (file.getProject().getName().equals("RemoteSystemsTempFiles") && (path = (properties = new SystemIFileProperties((IResource)file)).getRemoteFilePath()) != null && path.equals(adapter.getAbsoluteName(obj))) {
                                    page.bringToTop((IWorkbenchPart)editor);
                                    return;
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void linkEditorToView(IEditorPart editor, ISystemTree systemTree) {
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                fileInput.getFile();
                IFile file = fileInput.getFile();
                SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
                Object rmtEditable = properties.getRemoteFileObject();
                IAdaptable remoteObj = null;
                ISubSystem subSystem = null;
                if (rmtEditable != null && rmtEditable instanceof ISystemEditableRemoteObject) {
                    ISystemEditableRemoteObject editable = (ISystemEditableRemoteObject)rmtEditable;
                    remoteObj = editable.getRemoteObject();
                    TreeItem item = (TreeItem)systemTree.findFirstRemoteItemReference((Object)remoteObj, null);
                    if (item != null) {
                        systemTree.getTree().setSelection(item);
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)remoteObj.getAdapter((Class)clazz);
                        subSystem = adapter.getSubSystem((Object)remoteObj);
                        LinkFromFilterJob job = new LinkFromFilterJob(remoteObj, systemTree);
                        job.schedule();
                    }
                } else {
                    String subsystemId = properties.getRemoteFileSubSystem();
                    String path = properties.getRemoteFilePath();
                    if (subsystemId != null && path != null && (subSystem = RSECorePlugin.getTheSystemRegistry().getSubSystem(subsystemId)) != null) {
                        SelectFileJob job = new SelectFileJob(subSystem, path, systemTree);
                        job.schedule();
                    }
                }
            }
        }
    }
}

