/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractTrinidadTransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.TransformOperationFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OutputFormattedOperation
extends AbstractTrinidadTransformOperation {
    private static final String STYLECLASS_INSTRUCTION = "AFInstructionText";
    private static final String STYLECLASS_PAGESTAMP = "OraPageStampText";
    private static final String STYLECLASS_INCONTEXTBRANDING = "p_InContextBrandingText";

    public Element transform(Element srcElement, Element curElement) {
        String value;
        String styleUsage;
        Element spanElement = this.createElement("span");
        ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_CopyAttributeWithRenameOperation, new String[]{"inlineStyle", "style"});
        operation.transform(srcElement, spanElement);
        String styleClass = srcElement.getAttribute("styleClass");
        if ((styleClass == null || styleClass.length() < 1) && (styleUsage = srcElement.getAttribute("styleUsage")) != null && styleUsage.length() > 8) {
            if (styleUsage.equals("instruction")) {
                styleClass = STYLECLASS_INSTRUCTION;
            } else if (styleUsage.equals("pageStamp")) {
                styleClass = STYLECLASS_PAGESTAMP;
            } else if (styleUsage.equals("inContextBranding")) {
                styleClass = STYLECLASS_INCONTEXTBRANDING;
            }
        }
        if (styleClass != null && styleClass.length() > 0) {
            this.appendAttribute(spanElement, "class", styleClass);
        }
        if ((value = srcElement.getAttribute("value")) != null && value.length() > 0) {
            StringBuffer wrappedValue = new StringBuffer();
            wrappedValue.append("<?xml version=\"1.0\"?><value>");
            wrappedValue.append(value);
            wrappedValue.append("</value>");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(wrappedValue.toString().getBytes());
            Element valueElement = this.getValueDocumentElement(inputStream);
            if (valueElement != null) {
                if (!this.appendValueNodes(spanElement, valueElement)) {
                    NodeList childNodes = spanElement.getChildNodes();
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        spanElement.removeChild(childNodes.item(i));
                        ++i;
                    }
                    this.appendChildText(value, spanElement);
                }
            } else {
                this.appendChildText(value, spanElement);
            }
        }
        return spanElement;
    }

    private Element getValueDocumentElement(InputStream inputStream) {
        Element element = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            element = document.getDocumentElement();
        }
        catch (Exception exception) {}
        return element;
    }

    private boolean appendValueNodes(Node parentNode, Node currentNode) {
        boolean success = true;
        try {
            NodeList childNodes = currentNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode instanceof Element) {
                    Element newElement = (Element)parentNode.appendChild(parentNode.getOwnerDocument().createElement(childNode.getNodeName()));
                    NamedNodeMap attrMap = childNode.getAttributes();
                    if (attrMap != null) {
                        int j = 0;
                        while (j < attrMap.getLength()) {
                            Attr attr = (Attr)attrMap.item(j);
                            newElement.setAttribute(attr.getName(), attr.getValue());
                            ++j;
                        }
                    }
                    success &= this.appendValueNodes(newElement, childNode);
                } else if (childNode instanceof Text) {
                    parentNode.appendChild(parentNode.getOwnerDocument().createTextNode(childNode.getTextContent()));
                }
                ++i;
            }
        }
        catch (Exception exception) {
            success = false;
        }
        return success;
    }
}

