/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.internal.core.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.server.generic.servertype.definition.Classpath;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;

public class ServerRuntimeMergeUtil {
    public static ServerRuntime combine(ServerRuntime serverdef, ServerRuntime runtimedef) {
        EList classpaths;
        EList properties = runtimedef.getProperty();
        if (properties != null) {
            Iterator iter = properties.iterator();
            while (iter.hasNext()) {
                Property prop = (Property)iter.next();
                ServerRuntimeMergeUtil.addPropertyIfNotPresent((List)serverdef.getProperty(), prop);
            }
        }
        if ((classpaths = runtimedef.getClasspath()) != null) {
            Iterator iter = classpaths.iterator();
            while (iter.hasNext()) {
                Classpath classpath = (Classpath)iter.next();
                ServerRuntimeMergeUtil.addClasspathIfNotPresent((List)serverdef.getClasspath(), classpath);
            }
        }
        return serverdef;
    }

    private static void addClasspathIfNotPresent(List classpaths, Classpath classpath) {
        if (!ServerRuntimeMergeUtil.containsClasspath(classpaths, classpath.getId())) {
            classpaths.add(classpath);
        }
    }

    private static boolean containsClasspath(List properties, String id) {
        boolean found = false;
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            Classpath classpath = (Classpath)iter.next();
            if (!classpath.getId().equals(id)) continue;
            found = true;
            break;
        }
        return found;
    }

    private static void addPropertyIfNotPresent(List properties, Property prop) {
        if (!ServerRuntimeMergeUtil.containsProperty(properties, prop.getId())) {
            properties.add(prop);
        }
    }

    private static boolean containsProperty(List properties, String id) {
        boolean found = false;
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!prop.getId().equals(id)) continue;
            found = true;
            break;
        }
        return found;
    }
}

